/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.wiki.actions;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.trac.core.AbstractWikiHandler;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPage;
import org.eclipse.mylyn.internal.trac.wiki.TracWikiPlugin;
import org.eclipse.mylyn.internal.trac.wiki.editor.TracWikiPageEditorInput;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class OpenWikiPageAction
extends Action
implements IViewActionDelegate {
    private TaskRepository repository;
    private AbstractWikiHandler wikiHandler;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        Object[] selections;
        OpenWikiPageSelectionDialog openDialog = new OpenWikiPageSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), true);
        if (openDialog.open() == 0 && (selections = openDialog.getResult()) != null) {
            int i = 0;
            while (i < selections.length) {
                OpenWikiPageJob job = new OpenWikiPageJob((String)selections[i]);
                job.schedule();
                ++i;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.repository = this.getSelectedRepository(selection);
        if (this.repository != null) {
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
            if (connector instanceof TracRepositoryConnector) {
                TracRepositoryConnector tracConnector = (TracRepositoryConnector)connector;
                this.wikiHandler = tracConnector.getWikiHandler();
                action.setEnabled(tracConnector.hasWiki(this.repository));
            } else {
                action.setEnabled(false);
            }
        } else {
            action.setEnabled(false);
        }
    }

    private TaskRepository getSelectedRepository(ISelection selection) {
        Object selectedObject;
        if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof TaskRepository) {
            return (TaskRepository)selectedObject;
        }
        return null;
    }

    private static void openWikiPageEditor(TaskRepository repository, TracWikiPage wikiPage, String pageUrl) {
        TracWikiPageEditorInput editorInput = new TracWikiPageEditorInput(repository, wikiPage, pageUrl);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TasksUiUtil.openEditor((IEditorInput)editorInput, (String)"org.eclipse.mylyn.trac.ui.editor.wikipage", (IWorkbenchPage)window.getActivePage());
    }

    private class OpenWikiPageJob
    extends Job {
        private String pageName;

        public OpenWikiPageJob(String pageName) {
            super("Opening Wiki Page");
            this.pageName = pageName;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block6: {
                try {
                    try {
                        final TracWikiPage page = OpenWikiPageAction.this.wikiHandler.getWikiPage(OpenWikiPageAction.this.repository, this.pageName, monitor);
                        if (page != null) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    OpenWikiPageAction.openWikiPageEditor(OpenWikiPageAction.this.repository, page, String.valueOf(OpenWikiPageAction.this.wikiHandler.getWikiUrl(OpenWikiPageAction.this.repository)) + OpenWikiPageJob.this.pageName);
                                }
                            });
                            break block6;
                        }
                        StatusHandler.displayStatus((String)"Unable to open wiki page", (IStatus)new Status(4, "org.eclipse.mylyn.trac.wiki", "Unable to retrieve wiki page " + this.pageName));
                    }
                    catch (CoreException e) {
                        StatusHandler.displayStatus((String)"Unable to open wiki page", (IStatus)e.getStatus());
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
            return Status.OK_STATUS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OpenWikiPageSelectionDialog
    extends FilteredItemsSelectionDialog {
        private static final String OPEN_WIKI_PAGE_DIALOG_DIALOG_SETTINGS = "org.eclipse.mylyn.trac.ui.open.wikipage";
        private String[] pageNames;
        private DownloadAllPageNamesJob downloadAllPageNamesJob;

        public OpenWikiPageSelectionDialog(Shell shell, boolean multi) {
            super(shell, multi);
            this.setTitle("Open Wiki Page");
            this.setSelectionHistory(new PageSelectionHistory());
            this.setInitialPattern("**");
            this.setPageNames();
        }

        private void setPageNames() {
            this.downloadAllPageNamesJob = new DownloadAllPageNamesJob();
            this.downloadAllPageNamesJob.setUser(true);
            this.downloadAllPageNamesJob.schedule();
        }

        private void stopDownloading() {
            if (this.downloadAllPageNamesJob != null) {
                this.downloadAllPageNamesJob.cancel();
            }
        }

        protected Control createExtendedContentArea(Composite parent) {
            return null;
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            if (this.pageNames == null) {
                return null;
            }
            return new FilteredItemsSelectionDialog.ItemsFilter(this){

                public boolean isConsistentItem(Object item) {
                    return true;
                }

                public boolean matchItem(Object item) {
                    if (item != null) {
                        return this.matches(item.toString());
                    }
                    return false;
                }
            };
        }

        protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
            if (this.pageNames != null) {
                progressMonitor.beginTask("Searching", this.pageNames.length);
                int i = 0;
                while (i < this.pageNames.length) {
                    contentProvider.add((Object)this.pageNames[i], itemsFilter);
                    progressMonitor.worked(1);
                    ++i;
                }
            }
            progressMonitor.done();
        }

        protected IDialogSettings getDialogSettings() {
            IDialogSettings settings = TracWikiPlugin.getDefault().getDialogSettings().getSection(OPEN_WIKI_PAGE_DIALOG_DIALOG_SETTINGS);
            if (settings == null) {
                settings = TracWikiPlugin.getDefault().getDialogSettings().addNewSection(OPEN_WIKI_PAGE_DIALOG_DIALOG_SETTINGS);
            }
            return settings;
        }

        public String getElementName(Object item) {
            return item.toString();
        }

        protected Comparator<Object> getItemsComparator() {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            };
        }

        protected IStatus validateItem(Object item) {
            return Status.OK_STATUS;
        }

        protected void cancelPressed() {
            this.stopDownloading();
            super.cancelPressed();
        }

        protected void handleShellCloseEvent() {
            this.stopDownloading();
            super.handleShellCloseEvent();
        }

        private class DownloadAllPageNamesJob
        extends Job {
            public DownloadAllPageNamesJob() {
                super("Downloading All Wiki Page Names");
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    OpenWikiPageSelectionDialog.this.pageNames = OpenWikiPageAction.this.wikiHandler.downloadAllPageNames(OpenWikiPageAction.this.repository, monitor);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            OpenWikiPageSelectionDialog.this.applyFilter();
                        }
                    });
                }
                catch (CoreException e) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            OpenWikiPageSelectionDialog.this.close();
                        }
                    });
                    StatusHandler.displayStatus((String)"Unable to download Wiki page names", (IStatus)e.getStatus());
                }
                return Status.OK_STATUS;
            }
        }

        private class PageSelectionHistory
        extends FilteredItemsSelectionDialog.SelectionHistory {
            private PageSelectionHistory() {
            }

            protected Object restoreItemFromMemento(IMemento memento) {
                return null;
            }

            protected void storeItemToMemento(Object item, IMemento memento) {
            }
        }
    }
}

