/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BrowserFormPage
extends FormPage {
    public static final String ID_EDITOR = "org.eclipse.mylyn.web.ui.editor";
    private Browser browser;

    public BrowserFormPage(FormEditor editor, String title) {
        super(editor, ID_EDITOR, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        try {
            AbstractTask task = ((TaskEditorInput)this.getEditorInput()).getTask();
            ScrolledForm form = managedForm.getForm();
            form.getBody().setLayout((Layout)new FillLayout());
            this.browser = new Browser(form.getBody(), 0);
            managedForm.getForm().setContent((Control)this.browser);
            this.browser.setUrl(task.getUrl());
        }
        catch (SWTError e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.web", "Could not create browser page: " + e.getMessage(), (Throwable)e));
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.web", "Could not create issue report page", (Throwable)e));
        }
    }

    public void dispose() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.dispose();
        }
        super.dispose();
    }
}

