/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParameterEditorDialog
extends Dialog {
    private String title;
    private String name;
    private String value;
    private Text valueText;
    private Text nameText;
    private Text status;

    public ParameterEditorDialog(Shell parent) {
        super(parent);
        this.title = "New Property";
    }

    public ParameterEditorDialog(Shell parent, String name, String value) {
        super(parent);
        this.title = "Edit Property";
        this.name = name;
        this.value = value;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("&Name:");
        this.nameText = new Text(composite, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 300;
        this.nameText.setLayoutData((Object)gridData);
        Label valueLabel = new Label(composite, 0);
        valueLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        valueLabel.setText("&Value:");
        this.valueText = new Text(composite, 2048);
        GridData gridData_1 = new GridData(4, 0x1000000, true, false);
        gridData_1.widthHint = 300;
        this.valueText.setLayoutData((Object)gridData_1);
        if (this.name != null) {
            this.nameText.setText(this.name.trim());
            this.valueText.setFocus();
        }
        if (this.value != null) {
            this.valueText.setText(this.value);
            this.valueText.setSelection(0, this.value.length());
        }
        ModifyListener updateListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterEditorDialog.this.updateButtons();
            }
        };
        this.nameText.addModifyListener(updateListener);
        this.valueText.addModifyListener(updateListener);
        new Label(composite, 0);
        this.status = new Text(composite, 8);
        this.status.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void create() {
        super.create();
        this.updateButtons();
    }

    private void updateButtons() {
        this.name = this.nameText.getText().trim();
        this.value = this.valueText.getText();
        this.getButton(0).setEnabled(this.isValid());
    }

    private boolean isValid() {
        if (this.name.length() == 0 || !Character.isLetter(this.name.charAt(0))) {
            this.status.setText("Name should be a Java identifier");
            return false;
        }
        int i = 1;
        while (i < this.name.length()) {
            char c = this.name.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '-') {
                this.status.setText("Name should be a Java identifier");
                return false;
            }
            ++i;
        }
        this.status.setText("");
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }
}

