/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.mylyn.internal.web.tasks.ParameterEditorDialog;
import org.eclipse.mylyn.internal.web.tasks.WebRepositoryConnector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersEditor
extends Composite {
    private Table paramsTable;

    public ParametersEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.paramsTable = new Table((Composite)this, 67586);
        GridData gridData1 = new GridData(4, 4, true, true, 1, 3);
        gridData1.minimumHeight = 70;
        this.paramsTable.setLayoutData((Object)gridData1);
        this.paramsTable.setLinesVisible(true);
        this.paramsTable.setHeaderVisible(true);
        TableColumn colVariable = new TableColumn(this.paramsTable, 0);
        colVariable.setWidth(170);
        colVariable.setText("Parameter");
        TableColumn colValue = new TableColumn(this.paramsTable, 0);
        colValue.setWidth(280);
        colValue.setText("Value");
        Button bAdd = new Button((Composite)this, 0);
        bAdd.setLayoutData((Object)new GridData(4, 128, false, false));
        bAdd.setText("&Add...");
        bAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterEditorDialog dlg = new ParameterEditorDialog(Display.getCurrent().getActiveShell());
                if (dlg.open() == 0) {
                    TableItem item = new TableItem(ParametersEditor.this.paramsTable, 0);
                    item.setText(new String[]{dlg.getName(), dlg.getValue()});
                }
            }
        });
        final Button bRemove = new Button((Composite)this, 0);
        bRemove.setLayoutData((Object)new GridData(4, 128, false, false));
        bRemove.setText("&Remove");
        bRemove.setEnabled(false);
        bRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = ParametersEditor.this.paramsTable.getSelectionIndices();
                ParametersEditor.this.paramsTable.remove(indices);
            }
        });
        final Button bEdit = new Button((Composite)this, 0);
        bEdit.setLayoutData((Object)new GridData(4, 128, false, true));
        bEdit.setText("&Edit...");
        bEdit.setEnabled(false);
        bEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = ParametersEditor.this.paramsTable.getSelection()[0];
                ParameterEditorDialog dlg = new ParameterEditorDialog(Display.getCurrent().getActiveShell(), item.getText(0), item.getText(1));
                if (dlg.open() == 0) {
                    item.setText(0, dlg.getName());
                    item.setText(1, dlg.getValue());
                }
            }
        });
        this.paramsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bRemove.setEnabled(ParametersEditor.this.paramsTable.getSelectionCount() > 0);
                bEdit.setEnabled(ParametersEditor.this.paramsTable.getSelectionCount() == 1);
            }
        });
    }

    public void removeAll() {
        this.paramsTable.removeAll();
    }

    public void add(String name, String value) {
        TableItem item = new TableItem(this.paramsTable, 0);
        item.setText(new String[]{name, value});
    }

    public Map<String, String> getParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        TableItem[] tableItemArray = this.paramsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            parameters.put("param_" + item.getText(0), item.getText(1));
            ++n2;
        }
        return parameters;
    }

    public void addParams(Map<String, String> props, LinkedHashMap<String, String> variables) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith("param_")) {
                params.put(key.substring("param_".length()), value);
            }
            for (String var : WebRepositoryConnector.getTemplateVariables(value)) {
                variables.put(var, "");
            }
        }
        variables.remove("serverUrl");
        variables.remove("userId");
        variables.remove("password");
        for (String string : variables.keySet()) {
            if (params.containsKey(string)) continue;
            params.put(string, "");
        }
        for (Map.Entry entry : params.entrySet()) {
            this.add((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

