/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.monitor.core.util.XmlStringConverter;
import org.eclipse.mylyn.internal.web.tasks.WebQuery;
import org.eclipse.mylyn.internal.web.tasks.WebRepositoryConnector;
import org.eclipse.mylyn.internal.web.tasks.WebTask;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskListFactory;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebTaskListFactory
extends AbstractTaskListFactory {
    private static final String KEY_WEB = "Web";
    private static final String KEY_WEB_QUERY = "WebQuery";
    private static final String KEY_WEB_ISSUE = "WebIssue";
    private static final String KEY_URL_TEMPLATE = "UrlTemplate";
    private static final String KEY_REGEXP = "Regexp";
    private static final String KEY_PREFIX = "TaskPrefix";
    private static final String KEY_KEY = "Key";

    public String getTaskElementName() {
        return KEY_WEB_ISSUE;
    }

    public Set<String> getQueryElementNames() {
        return Collections.singleton(KEY_WEB_QUERY);
    }

    public boolean canCreate(AbstractRepositoryQuery category) {
        return category instanceof WebQuery;
    }

    public boolean canCreate(AbstractTask task) {
        return task instanceof WebTask;
    }

    public void setAdditionalAttributes(AbstractRepositoryQuery query, Element node) {
        if (query instanceof WebQuery) {
            WebQuery webQuery = (WebQuery)query;
            node.setAttribute(KEY_URL_TEMPLATE, webQuery.getQueryUrlTemplate());
            node.setAttribute(KEY_REGEXP, webQuery.getQueryPattern());
            node.setAttribute(KEY_PREFIX, webQuery.getTaskPrefix());
            for (Map.Entry<String, String> e : webQuery.getQueryParameters().entrySet()) {
                node.setAttribute(XmlStringConverter.convertToXmlString((String)e.getKey()), XmlStringConverter.convertToXmlString((String)e.getValue()));
            }
        }
    }

    public void setAdditionalAttributes(AbstractTask task, Element element) {
        element.setAttribute(KEY_KEY, ((WebTask)task).getTaskId());
        element.setAttribute(KEY_PREFIX, ((WebTask)task).getTaskPrefix());
    }

    public AbstractTask createTask(String repositoryUrl, String taskId, String label, Element element) {
        String prefix = null;
        if (element.hasAttribute(KEY_PREFIX)) {
            prefix = element.getAttribute(KEY_PREFIX);
        }
        WebTask task = new WebTask(taskId, label, prefix, repositoryUrl, "web");
        return task;
    }

    public AbstractRepositoryQuery createQuery(String repositoryUrl, String queryString, String label, Element element) {
        String queryUrlTemplate = element.getAttribute(KEY_URL_TEMPLATE);
        String queryPattern = element.getAttribute(KEY_REGEXP);
        String taskPrefix = element.getAttribute(KEY_PREFIX);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            if (name.startsWith("param_")) {
                params.put(XmlStringConverter.convertXmlToString((String)name), XmlStringConverter.convertXmlToString((String)attr.getValue()));
            }
            ++i;
        }
        if (queryUrlTemplate == null || queryUrlTemplate.length() == 0) {
            queryUrlTemplate = queryString;
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("web", repositoryUrl);
            queryString = WebRepositoryConnector.evaluateParams(queryUrlTemplate, params, repository);
        }
        return new WebQuery(label, queryString, queryUrlTemplate, queryPattern, taskPrefix, repositoryUrl, params);
    }

    public String getQueryElementName(AbstractRepositoryQuery query) {
        return query instanceof WebQuery ? KEY_WEB_QUERY : "";
    }
}

