/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.net.Proxy;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.ui.Messages;
import org.eclipse.mylyn.xplanner.ui.XPlannerAttributeFactory;
import org.eclipse.mylyn.xplanner.ui.XPlannerClientFacade;
import org.eclipse.mylyn.xplanner.ui.XPlannerMylynUIPlugin;
import org.eclipse.mylyn.xplanner.ui.XPlannerRepositoryUtils;
import org.eclipse.mylyn.xplanner.ui.XPlannerTask;
import org.xplanner.soap.TaskData;
import org.xplanner.soap.TimeEntryData;
import org.xplanner.soap.UserStoryData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerTaskDataHandler
extends AbstractTaskDataHandler {
    private AbstractAttributeFactory attributeFactory = new XPlannerAttributeFactory();

    public XPlannerTaskDataHandler(TaskList taskList) {
    }

    public RepositoryTaskData downloadTaskData(AbstractTask repositoryTask, TaskRepository repository, Proxy proxySettings) throws CoreException, LoginException {
        if (!(repositoryTask instanceof XPlannerTask)) {
            return null;
        }
        RepositoryTaskData repositoryTaskData = null;
        XPlannerTask xplannerTask = (XPlannerTask)repositoryTask;
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        repositoryTaskData = XPlannerRepositoryUtils.createRepositoryTaskData(repository, xplannerTask, client);
        return repositoryTaskData;
    }

    public boolean initializeTaskData(TaskRepository repository, RepositoryTaskData data, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public boolean initializeTaskData(TaskRepository repository, RepositoryTaskData data, UserStoryData userStory) throws CoreException {
        if (repository == null || data == null || userStory == null) {
            return false;
        }
        XPlannerRepositoryUtils.setupNewTaskAttributes(userStory, data);
        return true;
    }

    public AbstractAttributeFactory getAttributeFactory(String repositoryUrl, String repositoryKind, String taskKind) {
        return this.attributeFactory;
    }

    public AbstractAttributeFactory getAttributeFactory(RepositoryTaskData taskData) {
        return this.getAttributeFactory(taskData.getRepositoryUrl(), taskData.getRepositoryKind(), taskData.getTaskKind());
    }

    public String postTaskData(TaskRepository repository, RepositoryTaskData taskData, IProgressMonitor monitor) throws CoreException {
        String resultId = null;
        try {
            resultId = this.postChangesToRepository(taskData);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.core", 4, Messages.XPlannerOfflineTaskHandler_CANNOT_POST_DATA_TO_SERVER, null));
        }
        return resultId;
    }

    private String postChangesToRepository(RepositoryTaskData repositoryTaskData) throws CoreException {
        String error = null;
        String newTaskId = null;
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryTaskData.getRepositoryKind(), repositoryTaskData.getRepositoryUrl());
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        if (client != null) {
            try {
                TaskData taskData = null;
                if (repositoryTaskData.isNew()) {
                    taskData = XPlannerRepositoryUtils.createNewTaskData(repositoryTaskData, client);
                    if ((taskData = client.addTask(taskData)).getCreatedDate() == null) {
                        taskData.setCreatedDate(taskData.getLastUpdateTime());
                    }
                    newTaskId = "" + taskData.getId();
                } else {
                    taskData = client.getTask(Integer.valueOf(repositoryTaskData.getId()).intValue());
                }
                if (taskData != null) {
                    taskData.setName(repositoryTaskData.getSummary());
                    taskData.setDescription(XPlannerRepositoryUtils.getDescription(repositoryTaskData));
                    taskData.setEstimatedHours(Double.valueOf(repositoryTaskData.getAttribute("estimatedHours").getValue()).doubleValue());
                    taskData.setCompleted(XPlannerRepositoryUtils.isCompleted(repositoryTaskData));
                    int personId = client.getCurrentPersonId();
                    if (personId >= 0) {
                        taskData.setAcceptorId(personId);
                    }
                    Double currentActualHours = taskData.getActualHours();
                    Double changedActualHours = Double.valueOf(repositoryTaskData.getAttribute("actualHours").getValue());
                    if (currentActualHours < changedActualHours) {
                        TimeEntryData newTimeEntry = new TimeEntryData();
                        newTimeEntry.setDuration(changedActualHours - currentActualHours);
                        newTimeEntry.setPerson1Id(taskData.getAcceptorId());
                        newTimeEntry.setTaskId(taskData.getId());
                        newTimeEntry.setReportDate(Calendar.getInstance());
                        client.addTimeEntry(newTimeEntry);
                    }
                    XPlannerRepositoryUtils.ensureTaskDataValid(taskData);
                    client.update(taskData);
                } else {
                    UserStoryData userStory = client.getUserStory(Integer.valueOf(repositoryTaskData.getId()).intValue());
                    if (userStory != null) {
                        userStory.setName(repositoryTaskData.getSummary());
                        userStory.setDescription(XPlannerRepositoryUtils.getDescription(repositoryTaskData));
                        userStory.setActualHours(Double.valueOf(repositoryTaskData.getAttribute("actualHours").getValue()).doubleValue());
                        client.update(userStory);
                    }
                }
            }
            catch (NumberFormatException e) {
                XPlannerMylynUIPlugin.log(e.getCause(), "", false);
                error = e.getMessage();
            }
            catch (RemoteException e) {
                XPlannerMylynUIPlugin.log(e.getCause(), "", false);
                error = e.getMessage();
            }
        }
        if (error == null && repositoryTaskData.isNew()) {
            error = newTaskId;
        }
        return error;
    }

    public RepositoryTaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        return XPlannerRepositoryUtils.createRepositoryTaskData(repository, taskId);
    }

    public Set<String> getSubTaskIds(RepositoryTaskData taskData) {
        HashSet<String> subIds = new HashSet<String>();
        RepositoryTaskAttribute attribute = taskData.getAttribute(XPlannerAttributeFactory.Attribute.SUBTASK_IDS.getCommonAttributeKey());
        if (attribute != null) {
            subIds.addAll(attribute.getValues());
        }
        return subIds;
    }
}

