/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui.editor;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskTimingListener;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.xplanner.ui.XPlannerMylynUIPlugin;
import org.eclipse.mylyn.xplanner.ui.XPlannerRepositoryUtils;
import org.eclipse.mylyn.xplanner.ui.editor.Messages;
import org.eclipse.mylyn.xplanner.ui.editor.XPlannerEditorAttributeProvider;
import org.eclipse.mylyn.xplanner.ui.editor.XPlannerTaskEditorExtraControls;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class XPlannerTaskEditor
extends AbstractRepositoryTaskEditor
implements XPlannerEditorAttributeProvider,
ITaskTimingListener,
SelectionListener {
    private XPlannerTaskEditorExtraControls extraControls;
    private Button useTimeTrackingButton;
    private Button addToCurrentTimeButton;
    private Button replaceCurrentTimeButton;
    private Button roundToHalfHourButton;
    private boolean useAutoTimeTracking;
    private boolean roundToHalfHour;
    private boolean addToCurrentTime;

    public XPlannerTaskEditor(FormEditor editor) {
        super(editor);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.updateEditorTitle();
        this.extraControls = new XPlannerTaskEditorExtraControls(this, this.getRepositoryTaskData());
        this.setExpandAttributeSection(true);
    }

    protected void addRadioButtons(Composite buttonComposite) {
        this.createTimeTrackingPanel(buttonComposite);
    }

    protected void createPeopleLayout(Composite composite) {
    }

    protected void addActionButtons(Composite buttonComposite) {
        super.addActionButtons(buttonComposite);
    }

    protected void validateInput() {
        this.submitButton.setEnabled(true);
    }

    protected void createAttributeLayout(Composite composite) {
    }

    protected void addAttachContextButton(Composite buttonComposite, AbstractTask task) {
    }

    protected void createAttachmentLayout(Composite parent) {
    }

    protected void createCommentLayout(Composite composite) {
    }

    protected void createNewCommentLayout(Composite composite) {
    }

    protected ImageHyperlink createReplyHyperlink(int commentNum, Composite composite, String commentBody) {
        return null;
    }

    protected void createCustomAttributeLayout(Composite composite) {
        if (composite.getLayout() instanceof GridLayout) {
            GridLayout layout = (GridLayout)composite.getLayout();
            layout.numColumns = 1;
        }
        this.extraControls.createPartControlCustom(composite, true);
    }

    public RepositoryTaskData getRepositoryTaskData() {
        return this.taskData;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public String getFormTitle() {
        return MessageFormat.format(Messages.XPlannerTaskEditor_FORM_TASK_TITLE, XPlannerRepositoryUtils.getName(this.getRepositoryTaskData()), String.valueOf(this.getRepositoryTaskData().getId()));
    }

    public void setFocus() {
    }

    public String getPluginId() {
        return "org.eclipse.mylyn.xplanner.ui";
    }

    public boolean xplannerAttributeChanged(RepositoryTaskAttribute attribute) {
        return this.attributeChanged(attribute);
    }

    public void submitToRepository() {
        String errorMessage = null;
        Text errorControl = null;
        if (this.summaryText.getText().equals("")) {
            errorMessage = "Task name cannot be empty.";
            errorControl = this.summaryText;
        }
        if (errorMessage == null) {
            errorMessage = this.extraControls.validate();
        }
        if (errorMessage != null) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Submit Error", (String)errorMessage);
            if (errorControl != null) {
                errorControl.setFocus();
            }
        }
        if (errorMessage == null) {
            this.savePreferenceSettings();
            super.submitToRepository();
        }
    }

    private void loadValuesFromPreferenceSettings() {
        boolean useTimeTrackingPreference = XPlannerMylynUIPlugin.getBooleanPreference("UseAutoTimeTracking");
        this.useTimeTrackingButton.setSelection(useTimeTrackingPreference);
        this.setUseAutoTimeTracking(useTimeTrackingPreference);
        boolean roundToHalfHourPreference = XPlannerMylynUIPlugin.getBooleanPreference("RoundAutoTimeTrackingToHalfHour");
        this.roundToHalfHourButton.setSelection(roundToHalfHourPreference);
        this.setRoundToHalfHour(roundToHalfHourPreference);
        boolean addToCurrentTimePreference = XPlannerMylynUIPlugin.getBooleanPreference("AddAutoTrackedTimeToRepositoryValue");
        this.addToCurrentTimeButton.setSelection(addToCurrentTimePreference);
        this.replaceCurrentTimeButton.setSelection(!addToCurrentTimePreference);
        this.setAddToCurrentTime(addToCurrentTimePreference);
    }

    private void savePreferenceSettings() {
        XPlannerMylynUIPlugin.setBooleanPreference("UseAutoTimeTracking", this.isUseAutoTimeTracking());
        XPlannerMylynUIPlugin.setBooleanPreference("RoundAutoTimeTrackingToHalfHour", this.isRoundToHalfHour());
        XPlannerMylynUIPlugin.setBooleanPreference("AddAutoTrackedTimeToRepositoryValue", this.isAddToCurrentTime());
    }

    private void createTimeTrackingPanel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(this.getSite().getShell().getDisplay());
        Composite timeTrackingComposite = toolkit.createComposite(parent, 0);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)timeTrackingComposite);
        timeTrackingComposite.setLayout((Layout)new GridLayout(1, false));
        this.useTimeTrackingButton = toolkit.createButton(timeTrackingComposite, "Update actual task time from Mylyn's time tracker", 32);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)this.useTimeTrackingButton);
        this.useTimeTrackingButton.addSelectionListener((SelectionListener)this);
        this.roundToHalfHourButton = toolkit.createButton(timeTrackingComposite, "Round time to half hour", 32);
        GridDataFactory.fillDefaults().indent(new Point(15, 5)).applyTo((Control)this.roundToHalfHourButton);
        this.roundToHalfHourButton.addSelectionListener((SelectionListener)this);
        Composite updateMethodComposite = toolkit.createComposite(timeTrackingComposite);
        GridDataFactory.fillDefaults().indent(new Point(10, 0)).applyTo((Control)updateMethodComposite);
        updateMethodComposite.setLayout((Layout)new GridLayout(2, true));
        this.addToCurrentTimeButton = toolkit.createButton(updateMethodComposite, "Add to current repository time", 16);
        GridDataFactory.fillDefaults().applyTo((Control)this.addToCurrentTimeButton);
        this.addToCurrentTimeButton.setSelection(true);
        this.addToCurrentTimeButton.addSelectionListener((SelectionListener)this);
        this.replaceCurrentTimeButton = toolkit.createButton(updateMethodComposite, "Replace current repository time", 16);
        GridDataFactory.fillDefaults().applyTo((Control)this.replaceCurrentTimeButton);
        this.replaceCurrentTimeButton.addSelectionListener((SelectionListener)this);
        TasksUiPlugin.getTaskListManager().addTimingListener((ITaskTimingListener)this);
        this.loadValuesFromPreferenceSettings();
        this.updateTimeTrackingControls();
    }

    private void updateTimeTrackingControls() {
        boolean enabled = this.isUseAutoTimeTracking();
        this.roundToHalfHourButton.setEnabled(enabled);
        this.addToCurrentTimeButton.setEnabled(enabled);
        this.replaceCurrentTimeButton.setEnabled(enabled);
    }

    public void dispose() {
        this.savePreferenceSettings();
        TasksUiPlugin.getTaskListManager().removeTimingListener((ITaskTimingListener)this);
        super.dispose();
    }

    public void close() {
        this.savePreferenceSettings();
        super.close();
    }

    public void elapsedTimeUpdated(AbstractTask task, final long newElapsedTime) {
        if (!this.isUseAutoTimeTracking()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                XPlannerTaskEditor.this.extraControls.updateActualTimeWithElapsed(newElapsedTime, XPlannerTaskEditor.this.isAddToCurrentTime(), XPlannerTaskEditor.this.isRoundToHalfHour());
            }
        });
    }

    public void setUseAutoTimeTracking(boolean useTimeTracking) {
        this.useAutoTimeTracking = useTimeTracking;
    }

    public boolean isUseAutoTimeTracking() {
        return this.useAutoTimeTracking;
    }

    private void forceElapsedTimeUpdated() {
        AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(this.getRepositoryTaskData().getHandleIdentifier());
        long elapsedTimeMillis = TasksUiPlugin.getTaskActivityManager().getElapsedTime(TasksUiPlugin.getTaskListManager().getTaskList().getTask(this.getRepositoryTaskData().getHandleIdentifier()));
        this.elapsedTimeUpdated(task, elapsedTimeMillis);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.useTimeTrackingButton)) {
            this.updateTimeTrackingControls();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.useTimeTrackingButton)) {
            this.setUseAutoTimeTracking(this.useTimeTrackingButton.getSelection());
            if (this.isUseAutoTimeTracking()) {
                this.forceElapsedTimeUpdated();
            }
            this.updateTimeTrackingControls();
        } else if (source.equals(this.roundToHalfHourButton)) {
            this.setRoundToHalfHour(this.roundToHalfHourButton.getSelection());
            this.forceElapsedTimeUpdated();
        } else if (source.equals(this.replaceCurrentTimeButton)) {
            this.setAddToCurrentTime(!this.replaceCurrentTimeButton.getSelection());
            if (!this.isAddToCurrentTime()) {
                this.forceElapsedTimeUpdated();
            }
        } else if (source.equals(this.addToCurrentTimeButton)) {
            this.setAddToCurrentTime(this.addToCurrentTimeButton.getSelection());
            if (this.isAddToCurrentTime()) {
                this.forceElapsedTimeUpdated();
            }
        }
    }

    private boolean isRoundToHalfHour() {
        return this.roundToHalfHour;
    }

    private void setRoundToHalfHour(boolean roundToHalfHour) {
        this.roundToHalfHour = roundToHalfHour;
    }

    private boolean isAddToCurrentTime() {
        return this.addToCurrentTime;
    }

    private void setAddToCurrentTime(boolean addToCurrentTime) {
        this.addToCurrentTime = addToCurrentTime;
    }
}

