/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.model.filter;

import org.eclipse.mylyn.internal.jira.core.model.filter.DateFilter;

public class RelativeDateRangeFilter
extends DateFilter {
    private static final long serialVersionUID = 1L;
    private final RangeType previousRangeType;
    private final long previousCount;
    private final RangeType nextRangeType;
    private final long nextCount;

    public RelativeDateRangeFilter(RangeType rangeType, long count) {
        this(rangeType, count, RangeType.NONE, 0L);
    }

    public RelativeDateRangeFilter(RangeType previousRangeType, long previousCount, RangeType nextRangeType, long nextCount) {
        this.previousRangeType = previousRangeType;
        this.previousCount = previousCount;
        this.nextRangeType = nextRangeType;
        this.nextCount = nextCount;
    }

    public long previousMilliseconds() {
        return Math.abs(this.previousRangeType.getMultiplier() * this.previousCount);
    }

    public long nextMilliseconds() {
        return Math.abs(this.nextRangeType.getMultiplier() * this.nextCount);
    }

    public long getNextCount() {
        return this.nextCount;
    }

    public RangeType getNextRangeType() {
        return this.nextRangeType;
    }

    public long getPreviousCount() {
        return this.previousCount;
    }

    public RangeType getPreviousRangeType() {
        return this.previousRangeType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("from ");
        if (RangeType.NONE == this.previousRangeType) {
            sb.append("whenever");
        } else {
            sb.append(this.previousCount).append(this.previousRangeType);
        }
        sb.append(" to ");
        if (RangeType.NONE == this.nextRangeType) {
            sb.append("whenever");
        } else {
            sb.append(this.nextCount).append(this.nextRangeType);
        }
        return sb.toString();
    }

    DateFilter copy() {
        return new RelativeDateRangeFilter(this.previousRangeType, this.previousCount, this.nextRangeType, this.nextCount);
    }

    public static class RangeType {
        public static final RangeType NONE = new RangeType(0L);
        public static final RangeType MINUTE = new RangeType(60000L);
        public static final RangeType HOUR = new RangeType(3600000L);
        public static final RangeType DAY = new RangeType(86400000L);
        public static final RangeType WEEK = new RangeType(604800000L);
        private final long multiplier;

        private RangeType(long multiplier) {
            this.multiplier = multiplier;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public String toString() {
            if (HOUR.equals(this)) {
                return "h";
            }
            if (DAY.equals(this)) {
                return "d";
            }
            if (WEEK.equals(this)) {
                return "w";
            }
            if (MINUTE.equals(this)) {
                return "m";
            }
            return "none";
        }
    }
}

