/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.soap;

import java.io.File;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.FileProvider;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.eclipse.mylyn.internal.jira.core.model.Attachment;
import org.eclipse.mylyn.internal.jira.core.model.Comment;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.Group;
import org.eclipse.mylyn.internal.jira.core.model.Issue;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Query;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.Status;
import org.eclipse.mylyn.internal.jira.core.model.User;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.model.WebServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.model.filter.SingleIssueCollector;
import org.eclipse.mylyn.internal.jira.core.model.filter.SmartQuery;
import org.eclipse.mylyn.internal.jira.core.service.AbstractJiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraInsufficientPermissionException;
import org.eclipse.mylyn.internal.jira.core.service.JiraServiceUnavailableException;
import org.eclipse.mylyn.internal.jira.core.service.soap.Converter;
import org.eclipse.mylyn.internal.jira.core.service.soap.GZipJiraSoapServiceServiceLocator;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebIssueService;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.RssJiraFilterService;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteField;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteIssue;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteNamedObject;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.JiraSoapService;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemoteAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemotePermissionException;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.mylyn.web.core.AuthenticationCredentials;
import org.eclipse.mylyn.web.core.AuthenticationType;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraRpcClient
extends AbstractJiraClient {
    private static final String ERROR_RPC_NOT_ENABLED = "JIRA RPC services are not enabled. Please contact your JIRA administrator.";
    private static final String REMOTE_ERROR_BAD_ID = "White spaces are required between publicId and systemId.";
    private static final String REMOTE_ERROR_BAD_ENVELOPE_TAG = "Bad envelope tag:  html";
    private static final String REMOTE_ERROR_CONTENT_NOT_ALLOWED_IN_PROLOG = "Content is not allowed in prolog.";
    private static final String SOAP_SERVICE_URL = "/rpc/soap/jirasoapservice-v2";
    private static final long DEFAULT_SESSION_TIMEOUT = 600000L;
    private JiraSoapService soapService = null;
    private Lock soapServiceLock = new ReentrantLock();
    private JiraWebIssueService issueService = null;
    private RssJiraFilterService filterService = null;
    private LoginToken loginToken;

    public JiraRpcClient(AbstractWebLocation location, boolean useCompression) {
        super(location, useCompression);
        this.loginToken = new LoginToken(location, 600000L);
        this.filterService = new RssJiraFilterService(this);
        this.issueService = new JiraWebIssueService(this);
    }

    private JiraSoapService getSoapService() throws JiraException {
        this.soapServiceLock.lock();
        try {
            if (this.soapService == null) {
                GZipJiraSoapServiceServiceLocator locator = new GZipJiraSoapServiceServiceLocator((EngineConfiguration)new FileProvider(this.getClass().getClassLoader().getResourceAsStream("client-config.wsdd")));
                locator.setLocation(this.getLocation());
                locator.setCompression(this.useCompression());
                try {
                    this.soapService = locator.getJirasoapserviceV2(new URL(String.valueOf(this.getBaseUrl()) + SOAP_SERVICE_URL));
                }
                catch (ServiceException e) {
                    throw new JiraException(e);
                }
                catch (MalformedURLException e) {
                    throw new JiraException(e);
                }
                if (this.soapService == null) {
                    throw new JiraException("Initialization of JIRA Soap service failed");
                }
            }
            JiraSoapService jiraSoapService = this.soapService;
            return jiraSoapService;
        }
        finally {
            this.soapServiceLock.unlock();
        }
    }

    public User getUser(final String username) throws JiraException {
        return this.call(new RemoteRunnable<User>(){

            @Override
            public User run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getUser(JiraRpcClient.this.loginToken.getCurrentValue(), username));
            }
        });
    }

    @Override
    public Component[] getComponentsRemote(final String projectKey) throws JiraException {
        return this.call(new RemoteRunnable<Component[]>(){

            @Override
            public Component[] run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getComponents(JiraRpcClient.this.loginToken.getCurrentValue(), projectKey));
            }
        });
    }

    @Override
    public void login() throws JiraException {
        this.loginToken.expire();
        this.loginToken.getCurrentValue();
    }

    public Group getGroup(final String name) throws JiraException {
        return this.call(new RemoteRunnable<Group>(){

            @Override
            public Group run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getGroup(JiraRpcClient.this.loginToken.getCurrentValue(), name));
            }
        });
    }

    @Override
    public ServerInfo getServerInfoRemote() throws JiraException {
        ServerInfo serverInfo = this.call(new RemoteRunnable<ServerInfo>(){

            @Override
            public ServerInfo run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getServerInfo(JiraRpcClient.this.loginToken.getCurrentValue()));
            }
        });
        WebServerInfo webServerInfo = this.issueService.getWebServerInfo();
        serverInfo.setCharacterEncoding(webServerInfo.getCharacterEncoding());
        serverInfo.setWebBaseUrl(webServerInfo.getBaseUrl());
        return serverInfo;
    }

    @Override
    public Issue getIssueByKey(String issueKey) throws JiraException {
        SingleIssueCollector collector = new SingleIssueCollector();
        this.filterService.getIssueByKey(issueKey, collector);
        if (collector.getIssue() != null && collector.getIssue().getProject() == null) {
            throw new JiraException("Repository returned an unknown project for issue '" + collector.getIssue().getKey() + "'");
        }
        return collector.getIssue();
    }

    @Override
    public Issue getIssueById(String issueId) throws JiraException {
        String issueKey = this.getKeyFromId(issueId);
        return this.getIssueByKey(issueKey);
    }

    @Override
    public String getKeyFromId(final String issueId) throws JiraException {
        return this.call(new RemoteRunnable<String>(){

            @Override
            public String run() throws RemoteException, JiraException {
                RemoteIssue issue = JiraRpcClient.this.getSoapService().getIssueById(JiraRpcClient.this.loginToken.getCurrentValue(), issueId);
                return issue != null ? issue.getKey() : null;
            }
        });
    }

    @Override
    public RepositoryOperation[] getAvailableOperations(final String taskKey) throws JiraException {
        return this.call(new RemoteRunnable<RepositoryOperation[]>(){

            @Override
            public RepositoryOperation[] run() throws RemoteException, JiraException {
                RemoteNamedObject[] actions = JiraRpcClient.this.getSoapService().getAvailableActions(JiraRpcClient.this.loginToken.getCurrentValue(), taskKey);
                if (actions == null) {
                    return new RepositoryOperation[0];
                }
                RepositoryOperation[] operations = new RepositoryOperation[actions.length];
                int i = 0;
                while (i < actions.length) {
                    RemoteNamedObject action = actions[i];
                    operations[i] = new RepositoryOperation(action.getId(), action.getName());
                    ++i;
                }
                return operations;
            }
        });
    }

    @Override
    public String[] getActionFields(final String taskKey, final String actionId) throws JiraException {
        return this.call(new RemoteRunnable<String[]>(){

            @Override
            public String[] run() throws RemoteException, JiraException {
                RemoteField[] remoteFields = JiraRpcClient.this.getSoapService().getFieldsForAction(JiraRpcClient.this.loginToken.getCurrentValue(), taskKey, actionId);
                if (remoteFields == null) {
                    return new String[0];
                }
                String[] fields = new String[remoteFields.length];
                int i = 0;
                while (i < remoteFields.length) {
                    fields[i] = remoteFields[i].getId();
                    ++i;
                }
                return fields;
            }
        });
    }

    @Override
    public RepositoryTaskAttribute[] getEditableAttributes(final String taskKey) throws JiraException {
        return this.call(new RemoteRunnable<RepositoryTaskAttribute[]>(){

            @Override
            public RepositoryTaskAttribute[] run() throws RemoteException, JiraException {
                RemoteField[] fields = JiraRpcClient.this.getSoapService().getFieldsForEdit(JiraRpcClient.this.loginToken.getCurrentValue(), taskKey);
                if (fields == null) {
                    return new RepositoryTaskAttribute[0];
                }
                int add = 0;
                String version = JiraRpcClient.this.getServerInfo().getVersion();
                if (new JiraVersion(version).compareTo(JiraVersion.JIRA_3_12) < 0) {
                    add += 2;
                }
                RepositoryTaskAttribute[] attributes = new RepositoryTaskAttribute[fields.length + add];
                int i = 0;
                while (i < fields.length) {
                    RemoteField field = fields[i];
                    attributes[i] = new RepositoryTaskAttribute(field.getId(), field.getName(), false);
                    ++i;
                }
                if (add > 0) {
                    attributes[attributes.length - 2] = new RepositoryTaskAttribute("duedate", "Due Date", false);
                    attributes[attributes.length - 1] = new RepositoryTaskAttribute("fixVersions", "Fix Version/s", false);
                }
                return attributes;
            }
        });
    }

    @Override
    public CustomField[] getCustomAttributes() throws JiraException {
        return this.call(new RemoteRunnable<CustomField[]>(){

            @Override
            public CustomField[] run() throws RemoteException, JiraException {
                RemoteField[] remoteFields = JiraRpcClient.this.getSoapService().getCustomFields(JiraRpcClient.this.loginToken.getCurrentValue());
                CustomField[] fields = new CustomField[remoteFields.length];
                int i = 0;
                while (i < remoteFields.length) {
                    RemoteField remoteField = remoteFields[i];
                    fields[i] = new CustomField(remoteField.getId(), null, remoteField.getName(), Collections.<String>emptyList());
                    ++i;
                }
                return fields;
            }
        });
    }

    @Override
    public Issue createIssue(Issue issue) throws JiraException {
        String issueKey = this.issueService.createIssue(issue);
        return this.getIssueByKey(issueKey);
    }

    @Override
    public Issue createSubTask(Issue issue) throws JiraException {
        String issueKey = this.issueService.createSubTask(issue);
        return this.getIssueByKey(issueKey);
    }

    @Override
    public RemoteIssue getRemoteIssueByKey(final String key) throws JiraException {
        return this.call(new RemoteRunnable<RemoteIssue>(){

            @Override
            public RemoteIssue run() throws RemoteException, JiraException {
                return JiraRpcClient.this.getSoapService().getIssue(JiraRpcClient.this.loginToken.getCurrentValue(), key);
            }
        });
    }

    @Override
    public Project[] getProjectsRemote() throws JiraException {
        return this.call(new RemoteRunnable<Project[]>(){

            @Override
            public Project[] run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getProjects(JiraRpcClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    @Override
    public Project[] getProjectsRemoteNoSchemes() throws JiraException {
        return this.call(new RemoteRunnable<Project[]>(){

            @Override
            public Project[] run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getProjectsNoSchemes(JiraRpcClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    @Override
    public Status[] getStatusesRemote() throws JiraException {
        return this.call(new RemoteRunnable<Status[]>(){

            @Override
            public Status[] run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getStatuses(JiraRpcClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    @Override
    public IssueType[] getIssueTypesRemote() throws JiraException {
        return this.call(new RemoteRunnable<IssueType[]>(){

            @Override
            public IssueType[] run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getIssueTypes(JiraRpcClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    @Override
    public IssueType[] getSubTaskIssueTypesRemote() throws JiraException {
        return this.call(new RemoteRunnable<IssueType[]>(){

            @Override
            public IssueType[] run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getSubTaskIssueTypes(JiraRpcClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    @Override
    public Priority[] getPrioritiesRemote() throws JiraException {
        return this.call(new RemoteRunnable<Priority[]>(){

            @Override
            public Priority[] run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getPriorities(JiraRpcClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    @Override
    public Resolution[] getResolutionsRemote() throws JiraException {
        return this.call(new RemoteRunnable<Resolution[]>(){

            @Override
            public Resolution[] run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getResolutions(JiraRpcClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Comment[] getCommentsRemote(String issueKey) throws JiraException {
        return this.call(new RemoteRunnable<Comment[]>(){

            @Override
            public Comment[] run() throws RemoteException, JiraException {
                return null;
            }
        });
    }

    @Override
    public Version[] getVersionsRemote(final String componentKey) throws JiraException {
        return this.call(new RemoteRunnable<Version[]>(){

            @Override
            public Version[] run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getVersions(JiraRpcClient.this.loginToken.getCurrentValue(), componentKey));
            }
        });
    }

    @Override
    public void logout() {
        this.loginToken.expire();
    }

    @Override
    public NamedFilter[] getNamedFilters() throws JiraException {
        return this.call(new RemoteRunnable<NamedFilter[]>(){

            @Override
            public NamedFilter[] run() throws RemoteException, JiraException {
                return Converter.convert(JiraRpcClient.this.getSoapService().getSavedFilters(JiraRpcClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    static String unwrapRemoteException(RemoteException e) {
        AxisFault fault;
        Element httpErrorElement;
        if (e instanceof AxisFault && (httpErrorElement = (fault = (AxisFault)e).lookupFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE)) != null) {
            int responseCode = Integer.parseInt(httpErrorElement.getFirstChild().getTextContent());
            switch (responseCode) {
                case 500: {
                    return "Internal Server Error. Please contact your JIRA administrator.";
                }
                case 503: {
                    return ERROR_RPC_NOT_ENABLED;
                }
                case 404: {
                    return "No JIRA repository found at location.";
                }
                case 301: {
                    return "The location of the Jira server has moved.";
                }
            }
        }
        if (e.getCause() != null) {
            Throwable cause = e.getCause();
            if (cause instanceof UnknownHostException) {
                return "Unknown host.";
            }
            if (cause instanceof ConnectException) {
                return "Unable to connect to server.";
            }
            if (cause instanceof SAXException && (REMOTE_ERROR_BAD_ENVELOPE_TAG.equals(cause.getMessage()) || REMOTE_ERROR_BAD_ID.equals(cause.getMessage()) || REMOTE_ERROR_CONTENT_NOT_ALLOWED_IN_PROLOG.equals(cause.getMessage()))) {
                return ERROR_RPC_NOT_ENABLED;
            }
            return e.getCause().getLocalizedMessage();
        }
        if (e instanceof AxisFault) {
            return "Server error: " + e.getLocalizedMessage();
        }
        return e.getLocalizedMessage();
    }

    @Override
    public void search(Query query, IssueCollector collector) throws JiraException {
        if (query instanceof SmartQuery) {
            this.quickSearch(((SmartQuery)query).getKeywords(), collector);
        } else if (query instanceof FilterDefinition) {
            this.findIssues((FilterDefinition)query, collector);
        } else if (query instanceof NamedFilter) {
            this.executeNamedFilter((NamedFilter)query, collector);
        } else {
            throw new IllegalArgumentException("Unknown query type: " + query.getClass());
        }
    }

    public void findIssues(FilterDefinition filterDefinition, IssueCollector collector) throws JiraException {
        this.filterService.findIssues(filterDefinition, collector);
    }

    public void executeNamedFilter(NamedFilter filter, IssueCollector collector) throws JiraException {
        this.filterService.executeNamedFilter(filter, collector);
    }

    public void quickSearch(String searchString, IssueCollector collector) throws JiraException {
        this.filterService.quickSearch(searchString, collector);
    }

    @Override
    public void addCommentToIssue(Issue issue, String comment) throws JiraException {
        this.issueService.addCommentToIssue(issue, comment);
    }

    @Override
    public void updateIssue(Issue issue, String comment) throws JiraException {
        this.issueService.updateIssue(issue, comment);
    }

    @Override
    public void assignIssueTo(Issue issue, int assigneeType, String user, String comment) throws JiraException {
        this.issueService.assignIssueTo(issue, assigneeType, user, comment);
    }

    @Override
    public void advanceIssueWorkflow(Issue issue, String actionKey, String comment) throws JiraException {
        String[] fields = this.getActionFields(issue.getKey(), actionKey);
        this.issueService.advanceIssueWorkflow(issue, actionKey, comment, fields);
    }

    @Override
    public void attachFile(Issue issue, String comment, PartSource partSource, String contentType) throws JiraException {
        this.issueService.attachFile(issue, comment, partSource, contentType);
    }

    @Override
    public void attachFile(Issue issue, String comment, String filename, byte[] contents, String contentType) throws JiraException {
        this.issueService.attachFile(issue, comment, filename, contents, contentType);
    }

    @Override
    public void attachFile(Issue issue, String comment, String filename, File file, String contentType) throws JiraException {
        this.issueService.attachFile(issue, comment, filename, file, contentType);
    }

    @Override
    public byte[] retrieveFile(Issue issue, Attachment attachment) throws JiraException {
        byte[] result = new byte[(int)attachment.getSize()];
        this.issueService.retrieveFile(issue, attachment, result);
        return result;
    }

    @Override
    public void retrieveFile(Issue issue, Attachment attachment, OutputStream out) throws JiraException {
        this.issueService.retrieveFile(issue, attachment, out);
    }

    @Override
    public void watchIssue(Issue issue) throws JiraException {
        this.issueService.watchIssue(issue);
    }

    @Override
    public void unwatchIssue(Issue issue) throws JiraException {
        this.issueService.unwatchIssue(issue);
    }

    @Override
    public void voteIssue(Issue issue) throws JiraException {
        this.issueService.voteIssue(issue);
    }

    @Override
    public void unvoteIssue(Issue issue) throws JiraException {
        this.issueService.unvoteIssue(issue);
    }

    @Override
    public void deleteIssue(Issue issue) throws JiraException {
        this.issueService.deleteIssue(issue);
    }

    private <T> T call(RemoteRunnable<T> runnable, boolean retry) throws JiraException {
        int i = 0;
        while (i < 2) {
            try {
                return runnable.run();
            }
            catch (RemotePermissionException e) {
                throw new JiraInsufficientPermissionException(e.getMessage());
            }
            catch (RemoteAuthenticationException e) {
                if (!retry || i > 0) {
                    throw new JiraAuthenticationException(e.getMessage());
                }
                this.loginToken.expire();
            }
            catch (org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemoteException e) {
                throw new JiraServiceUnavailableException(e.getMessage());
            }
            catch (RemoteException e) {
                throw new JiraServiceUnavailableException(JiraRpcClient.unwrapRemoteException(e));
            }
            ++i;
        }
        throw new RuntimeException("Invalid section of code reached");
    }

    private <T> T call(RemoteRunnable<T> runnable) throws JiraException {
        while (true) {
            try {
                return this.call(runnable, true);
            }
            catch (JiraAuthenticationException e) {
                if (this.getLocation().requestCredentials(AuthenticationType.REPOSITORY, null) != AbstractWebLocation.ResultType.NOT_SUPPORTED) continue;
                throw e;
            }
            break;
        }
    }

    private class LoginToken {
        private final long timeout;
        private String token;
        private long lastAccessed;
        private final AbstractWebLocation location;
        private AuthenticationCredentials credentials;

        public LoginToken(AbstractWebLocation location, long timeout) {
            this.location = location;
            this.timeout = timeout;
            this.lastAccessed = -1L;
        }

        public synchronized String getCurrentValue() throws JiraException {
            AuthenticationCredentials newCredentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
            if (newCredentials == null) {
                this.expire();
                return "";
            }
            if (!newCredentials.equals((Object)this.credentials)) {
                this.expire();
                this.credentials = newCredentials;
            }
            if (System.currentTimeMillis() - this.lastAccessed >= this.timeout || this.token == null) {
                this.expire();
                this.token = (String)JiraRpcClient.this.call(new RemoteRunnable<String>(){

                    @Override
                    public String run() throws RemoteException, JiraException {
                        return JiraRpcClient.this.getSoapService().login(LoginToken.this.credentials.getUserName(), LoginToken.this.credentials.getPassword());
                    }
                }, false);
                this.lastAccessed = System.currentTimeMillis();
            }
            return this.token;
        }

        public synchronized void expire() {
            if (this.token != null) {
                try {
                    JiraRpcClient.this.getSoapService().logout(this.token);
                }
                catch (RemoteException remoteException) {
                }
                catch (JiraException jiraException) {}
                this.token = null;
                this.lastAccessed = -1L;
            }
        }

        public synchronized boolean isValidToken() {
            return this.token != null && System.currentTimeMillis() - this.lastAccessed < this.timeout;
        }

        public String toString() {
            long expiresIn = (this.timeout - (System.currentTimeMillis() - this.lastAccessed)) / 1000L;
            return "[credentials=" + this.credentials + ", timeout=" + this.timeout + ", valid=" + this.isValidToken() + ", expires=" + expiresIn + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface RemoteRunnable<T> {
        public T run() throws RemoteException, JiraException;
    }
}

