/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.text.html.HTML;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.eclipse.mylyn.internal.jira.core.model.Attachment;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.Issue;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.model.WebServerInfo;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraRemoteException;
import org.eclipse.mylyn.internal.jira.core.service.JiraRemoteMessageException;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSession;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSessionCallback;
import org.eclipse.mylyn.web.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.web.core.HtmlTag;

public class JiraWebIssueService {
    public static final String DATE_FORMAT = "dd-MMM-yyyy";
    public static final String DUE_DATE_FORMAT = "dd/MMM/yy";
    private final JiraClient server;

    public JiraWebIssueService(JiraClient server) {
        this.server = server;
    }

    public void addCommentToIssue(final Issue issue, final String comment) throws JiraException {
        final JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                StringBuffer rssUrlBuffer = new StringBuffer(baseUrl);
                rssUrlBuffer.append("/secure/AddComment.jspa");
                PostMethod post = new PostMethod(rssUrlBuffer.toString());
                post.setRequestHeader("Content-Type", s.getContentType());
                post.addParameter("comment", comment);
                post.addParameter("commentLevel", "");
                post.addParameter("id", issue.getId());
                try {
                    try {
                        client.executeMethod((HttpMethod)post);
                        if (!s.expectRedirect((HttpMethodBase)post, issue)) {
                            JiraWebIssueService.this.handleErrorMessage((HttpMethodBase)post);
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    post.releaseConnection();
                }
            }
        });
    }

    public void updateIssue(final Issue issue, final String comment) throws JiraException {
        final JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                Version[] fixVersions;
                Version[] versions;
                StringBuffer rssUrlBuffer = new StringBuffer(baseUrl);
                rssUrlBuffer.append("/secure/EditIssue.jspa");
                PostMethod post = new PostMethod(rssUrlBuffer.toString());
                post.setRequestHeader("Content-Type", s.getContentType());
                post.addParameter("summary", issue.getSummary());
                post.addParameter("issuetype", issue.getType().getId());
                if (issue.getPriority() != null) {
                    post.addParameter("priority", issue.getPriority().getId());
                }
                if (issue.getDue() != null) {
                    post.addParameter("duedate", new SimpleDateFormat(JiraWebIssueService.DUE_DATE_FORMAT, Locale.US).format(issue.getDue()));
                } else {
                    post.addParameter("duedate", "");
                }
                post.addParameter("timetracking", String.valueOf(Long.toString(issue.getInitialEstimate() / 60L)) + "m");
                Component[] components = issue.getComponents();
                if (components != null) {
                    if (components.length == 0) {
                        post.addParameter("components", "-1");
                    } else {
                        int i = 0;
                        while (i < components.length) {
                            post.addParameter("components", components[i].getId());
                            ++i;
                        }
                    }
                }
                if ((versions = issue.getReportedVersions()) != null) {
                    if (versions.length == 0) {
                        post.addParameter("versions", "-1");
                    } else {
                        int i = 0;
                        while (i < versions.length) {
                            post.addParameter("versions", versions[i].getId());
                            ++i;
                        }
                    }
                }
                if ((fixVersions = issue.getFixVersions()) != null) {
                    if (fixVersions.length == 0) {
                        post.addParameter("fixVersions", "-1");
                    } else {
                        int i = 0;
                        while (i < fixVersions.length) {
                            post.addParameter("fixVersions", fixVersions[i].getId());
                            ++i;
                        }
                    }
                }
                if (issue.getAssignee() != null) {
                    post.addParameter("assignee", issue.getAssignee());
                } else {
                    post.addParameter("assignee", "-1");
                }
                post.addParameter("reporter", issue.getReporter());
                post.addParameter("environment", issue.getEnvironment());
                post.addParameter("description", issue.getDescription());
                if (comment != null) {
                    post.addParameter("comment", comment);
                }
                post.addParameter("commentLevel", "");
                post.addParameter("id", issue.getId());
                if (issue.getSecurityLevel() != null) {
                    post.addParameter("security", issue.getSecurityLevel().getId());
                }
                JiraWebIssueService.this.addCustomFields(issue, post);
                try {
                    try {
                        client.executeMethod((HttpMethod)post);
                        if (!s.expectRedirect((HttpMethodBase)post, issue)) {
                            JiraWebIssueService.this.handleErrorMessage((HttpMethodBase)post);
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    post.releaseConnection();
                }
            }
        });
    }

    public void assignIssueTo(final Issue issue, final int assigneeType, final String user, final String comment) throws JiraException {
        final JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                StringBuffer rssUrlBuffer = new StringBuffer(baseUrl);
                rssUrlBuffer.append("/secure/AssignIssue.jspa");
                PostMethod post = new PostMethod(rssUrlBuffer.toString());
                post.setRequestHeader("Content-Type", s.getContentType());
                post.addParameter("assignee", JiraWebIssueService.this.getAssigneeParam(server, issue, assigneeType, user));
                if (comment != null) {
                    post.addParameter("comment", comment);
                }
                post.addParameter("commentLevel", "");
                post.addParameter("id", issue.getId());
                try {
                    try {
                        client.executeMethod((HttpMethod)post);
                        if (!s.expectRedirect((HttpMethodBase)post, issue)) {
                            JiraWebIssueService.this.handleErrorMessage((HttpMethodBase)post);
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    post.releaseConnection();
                }
            }
        });
    }

    public void advanceIssueWorkflow(final Issue issue, final String actionKey, final String comment, final String[] fields) throws JiraException {
        final JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                PostMethod post = new PostMethod(String.valueOf(baseUrl) + "/secure/CommentAssignIssue.jspa");
                post.setRequestHeader("Content-Type", s.getContentType());
                post.addParameter("id", issue.getId());
                post.addParameter("action", actionKey);
                if (comment != null) {
                    post.addParameter("comment", comment);
                }
                post.addParameter("commentLevel", "");
                String[] stringArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    String field = stringArray[n2];
                    String[] values = issue.getFieldValues(field);
                    if (values != null) {
                        String[] stringArray2 = values;
                        int n3 = values.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String value = stringArray2[n4];
                            post.addParameter(field, value);
                            ++n4;
                        }
                    }
                    ++n2;
                }
                try {
                    try {
                        client.executeMethod((HttpMethod)post);
                        if (!s.expectRedirect((HttpMethodBase)post, issue)) {
                            JiraWebIssueService.this.handleErrorMessage((HttpMethodBase)post);
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    post.releaseConnection();
                }
            }
        });
    }

    public void attachFile(Issue issue, String comment, PartSource partSource, String contentType) throws JiraException {
        this.attachFile(issue, comment, new FilePart("filename.1", partSource), contentType);
    }

    public void attachFile(Issue issue, String comment, String filename, byte[] contents, String contentType) throws JiraException {
        this.attachFile(issue, comment, new FilePart("filename.1", (PartSource)new ByteArrayPartSource(filename, contents)), contentType);
    }

    public void attachFile(Issue issue, String comment, String filename, File file, String contentType) throws JiraException {
        try {
            FilePartSource partSource = new FilePartSource(filename, file);
            this.attachFile(issue, comment, new FilePart("filename.1", (PartSource)partSource), contentType);
        }
        catch (FileNotFoundException e) {
            throw new JiraException(e);
        }
    }

    public void attachFile(final Issue issue, final String comment, final FilePart filePart, final String contentType) throws JiraException {
        final JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                StringBuffer attachFileURLBuffer = new StringBuffer(baseUrl);
                attachFileURLBuffer.append("/secure/AttachFile.jspa");
                PostMethod post = new PostMethod(attachFileURLBuffer.toString());
                ArrayList<Object> parts = new ArrayList<Object>();
                StringPart idPart = new StringPart("id", issue.getId());
                StringPart commentLevelPart = new StringPart("commentLevel", "");
                idPart.setTransferEncoding(null);
                idPart.setContentType(null);
                if (comment != null) {
                    StringPart commentPart = new StringPart("comment", comment);
                    commentPart.setTransferEncoding(null);
                    commentPart.setContentType(null);
                    parts.add(commentPart);
                }
                commentLevelPart.setTransferEncoding(null);
                commentLevelPart.setContentType(null);
                filePart.setTransferEncoding(null);
                if (contentType != null) {
                    filePart.setContentType(contentType);
                }
                parts.add(filePart);
                parts.add(idPart);
                parts.add(commentLevelPart);
                post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), post.getParams()));
                try {
                    try {
                        client.executeMethod((HttpMethod)post);
                        if (!s.expectRedirect((HttpMethodBase)post, "/secure/ManageAttachments.jspa?id=" + issue.getId())) {
                            JiraWebIssueService.this.handleErrorMessage((HttpMethodBase)post);
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    post.releaseConnection();
                }
            }
        });
    }

    public void retrieveFile(Issue issue, final Attachment attachment, final byte[] attachmentData) throws JiraException {
        JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                StringBuffer rssUrlBuffer = new StringBuffer(baseUrl);
                rssUrlBuffer.append("/secure/attachment/");
                rssUrlBuffer.append(attachment.getId());
                rssUrlBuffer.append("/");
                try {
                    rssUrlBuffer.append(URLEncoder.encode(attachment.getName(), server.getCharacterEncoding()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new JiraException(e);
                }
                GetMethod get = new GetMethod(rssUrlBuffer.toString());
                try {
                    try {
                        int result = client.executeMethod((HttpMethod)get);
                        if (result != 200) {
                            JiraWebIssueService.this.handleErrorMessage((HttpMethodBase)get);
                        } else {
                            byte[] data = get.getResponseBody();
                            if (data.length != attachmentData.length) {
                                throw new IOException("Unexpected attachment size (got " + data.length + ", expected " + attachmentData.length + ")");
                            }
                            System.arraycopy(data, 0, attachmentData, 0, attachmentData.length);
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    get.releaseConnection();
                }
            }
        });
    }

    public void retrieveFile(Issue issue, final Attachment attachment, final OutputStream out) throws JiraException {
        JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                StringBuffer rssUrlBuffer = new StringBuffer(baseUrl);
                rssUrlBuffer.append("/secure/attachment/");
                rssUrlBuffer.append(attachment.getId());
                rssUrlBuffer.append("/");
                try {
                    rssUrlBuffer.append(URLEncoder.encode(attachment.getName(), server.getCharacterEncoding()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new JiraException(e);
                }
                GetMethod get = new GetMethod(rssUrlBuffer.toString());
                try {
                    try {
                        int result = client.executeMethod((HttpMethod)get);
                        if (result != 200) {
                            JiraWebIssueService.this.handleErrorMessage((HttpMethodBase)get);
                        } else {
                            out.write(get.getResponseBody());
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    get.releaseConnection();
                }
            }
        });
    }

    public String createIssue(Issue issue) throws JiraException {
        return this.createIssue("/secure/CreateIssueDetails.jspa", issue);
    }

    public String createSubTask(Issue issue) throws JiraException {
        return this.createIssue("/secure/CreateSubTaskIssueDetails.jspa", issue);
    }

    private String createIssue(final String url, final Issue issue) throws JiraException {
        final String[] issueKey = new String[1];
        final JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                block23: {
                    int i;
                    StringBuffer attachFileURLBuffer = new StringBuffer(baseUrl);
                    attachFileURLBuffer.append(url);
                    PostMethod post = new PostMethod(attachFileURLBuffer.toString());
                    post.setRequestHeader("Content-Type", s.getContentType());
                    post.addParameter("pid", issue.getProject().getId());
                    post.addParameter("issuetype", issue.getType().getId());
                    post.addParameter("summary", issue.getSummary());
                    if (issue.getPriority() != null) {
                        post.addParameter("priority", issue.getPriority().getId());
                    }
                    if (issue.getDue() != null) {
                        post.addParameter("duedate", new SimpleDateFormat(JiraWebIssueService.DUE_DATE_FORMAT, Locale.US).format(issue.getDue()));
                    }
                    post.addParameter("timetracking", String.valueOf(Long.toString(issue.getInitialEstimate() / 60L)) + "m");
                    if (issue.getComponents() != null) {
                        i = 0;
                        while (i < issue.getComponents().length) {
                            post.addParameter("components", issue.getComponents()[i].getId());
                            ++i;
                        }
                    } else {
                        post.addParameter("components", "-1");
                    }
                    if (issue.getReportedVersions() != null) {
                        i = 0;
                        while (i < issue.getReportedVersions().length) {
                            post.addParameter("versions", issue.getReportedVersions()[i].getId());
                            ++i;
                        }
                    } else {
                        post.addParameter("versions", "-1");
                    }
                    if (issue.getFixVersions() != null) {
                        i = 0;
                        while (i < issue.getFixVersions().length) {
                            post.addParameter("fixVersions", issue.getFixVersions()[i].getId());
                            ++i;
                        }
                    } else {
                        post.addParameter("fixVersions", "-1");
                    }
                    if (issue.getAssignee() == null) {
                        post.addParameter("assignee", "-1");
                    } else if (issue.getAssignee().length() == 0) {
                        post.addParameter("assignee", "");
                    } else {
                        post.addParameter("assignee", issue.getAssignee());
                    }
                    post.addParameter("reporter", server.getUserName());
                    post.addParameter("environment", issue.getEnvironment() != null ? issue.getEnvironment() : "");
                    post.addParameter("description", issue.getDescription() != null ? issue.getDescription() : "");
                    if (issue.getParentId() != null) {
                        post.addParameter("parentIssueId", issue.getParentId());
                    }
                    JiraWebIssueService.this.addCustomFields(issue, post);
                    try {
                        try {
                            client.executeMethod((HttpMethod)post);
                            if (!s.expectRedirect((HttpMethodBase)post, "/browse/")) {
                                JiraWebIssueService.this.handleErrorMessage((HttpMethodBase)post);
                                break block23;
                            }
                            Header locationHeader = post.getResponseHeader("location");
                            String location = locationHeader.getValue();
                            int i2 = location.lastIndexOf("/");
                            if (i2 != -1) {
                                issueKey[0] = location.substring(i2);
                                break block23;
                            }
                            throw new JiraException("The server redirected to an unexpected location while creating an issue: " + location);
                        }
                        catch (IOException e) {
                            throw new JiraException(e);
                        }
                    }
                    finally {
                        post.releaseConnection();
                    }
                }
            }
        });
        assert (issueKey[0] != null);
        return issueKey[0];
    }

    public void watchIssue(Issue issue) throws JiraException {
        this.watchUnwatchIssue(issue, true);
    }

    public void unwatchIssue(Issue issue) throws JiraException {
        this.watchUnwatchIssue(issue, false);
    }

    private void watchUnwatchIssue(final Issue issue, final boolean watch) throws JiraException {
        JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                StringBuffer urlBuffer = new StringBuffer(baseUrl);
                urlBuffer.append("/browse/").append(issue.getKey());
                urlBuffer.append("?watch=").append(Boolean.toString(watch));
                HeadMethod head = new HeadMethod(urlBuffer.toString());
                try {
                    try {
                        int result = client.executeMethod((HttpMethod)head);
                        if (result != 200) {
                            throw new JiraException("Changing watch status failed. Return code: " + result);
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    head.releaseConnection();
                }
            }
        });
    }

    public void voteIssue(Issue issue) throws JiraException {
        this.voteUnvoteIssue(issue, true);
    }

    public void unvoteIssue(Issue issue) throws JiraException {
        this.voteUnvoteIssue(issue, false);
    }

    private void voteUnvoteIssue(final Issue issue, final boolean vote) throws JiraException {
        if (!issue.canUserVote(this.server.getUserName())) {
            return;
        }
        JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                StringBuffer urlBuffer = new StringBuffer(baseUrl);
                urlBuffer.append("/browse/").append(issue.getKey());
                urlBuffer.append("?vote=").append(vote ? "vote" : "unvote");
                HeadMethod head = new HeadMethod(urlBuffer.toString());
                try {
                    try {
                        int result = client.executeMethod((HttpMethod)head);
                        if (result != 200) {
                            throw new JiraException("Changing vote failed. Return code: " + result);
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    head.releaseConnection();
                }
            }
        });
    }

    public void deleteIssue(final Issue issue) throws JiraException {
        JiraWebSession s = new JiraWebSession(this.server);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                StringBuffer urlBuffer = new StringBuffer(baseUrl);
                urlBuffer.append("/secure/DeleteIssue.jspa");
                urlBuffer.append("?id=").append(issue.getId());
                urlBuffer.append("&confirm=true");
                HeadMethod head = new HeadMethod(urlBuffer.toString());
                try {
                    try {
                        int result = client.executeMethod((HttpMethod)head);
                        if (result != 200) {
                            throw new JiraException("Deleting issue failed. Return code: " + result);
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    head.releaseConnection();
                }
            }
        });
    }

    public WebServerInfo getWebServerInfo() throws JiraException {
        final WebServerInfo webServerInfo = new WebServerInfo();
        final JiraWebSession s = new JiraWebSession(this.server);
        s.setLogEnabled(true);
        s.doInSession(new JiraWebSessionCallback(){

            public void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException {
                webServerInfo.setCharacterEncoding(s.getBaseURL());
                webServerInfo.setCharacterEncoding(s.getCharacterEncoding());
                webServerInfo.setInsecureRedirect(s.isInsecureRedirect());
            }
        });
        return webServerInfo;
    }

    private String getAssigneeParam(JiraClient server, Issue issue, int assigneeType, String user) {
        switch (assigneeType) {
            case 2: {
                return issue.getAssignee();
            }
            case 1: {
                return "-1";
            }
            case 3: {
                return "";
            }
            case 5: {
                return server.getUserName();
            }
            case 4: {
                return user;
            }
        }
        return user;
    }

    protected void handleErrorMessage(HttpMethodBase method) throws IOException, JiraException {
        String response = method.getResponseBodyAsString();
        if (method.getStatusCode() == 503) {
            throw new JiraRemoteException("JIRA system error", null);
        }
        if (response == null) {
            throw new JiraRemoteMessageException("Error making JIRA request: " + method.getStatusCode(), "");
        }
        StringReader reader = new StringReader(response);
        try {
            try {
                StringBuilder msg = new StringBuilder();
                HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                    HtmlTag tag;
                    String classValue;
                    if (token.getType() == HtmlStreamTokenizer.Token.TAG && (classValue = (tag = (HtmlTag)token.getValue()).getAttribute("class")) != null) {
                        if (tag.getTagType() == HtmlTag.Type.DIV) {
                            if (classValue.startsWith("infoBox")) {
                                throw new JiraRemoteMessageException(this.getContent(tokenizer, HtmlTag.Type.DIV));
                            }
                            if (classValue.startsWith("errorArea")) {
                                throw new JiraRemoteMessageException(this.getContent(tokenizer, HtmlTag.Type.DIV));
                            }
                        } else if (tag.getTagType() == HtmlTag.Type.SPAN && classValue.startsWith("errMsg")) {
                            msg.append(this.getContent(tokenizer, HtmlTag.Type.SPAN));
                        }
                    }
                    token = tokenizer.nextToken();
                }
                if (msg.length() == 0) {
                    throw new JiraRemoteMessageException(response);
                }
                throw new JiraRemoteMessageException(msg.toString());
            }
            catch (ParseException parseException) {
                throw new JiraRemoteMessageException("Error parsing JIRA response: " + method.getStatusCode(), "");
            }
        }
        catch (Throwable throwable) {
            reader.close();
            throw throwable;
        }
    }

    private String getContent(HtmlStreamTokenizer tokenizer, HTML.Tag closingTag) throws IOException, ParseException {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            HtmlTag tag;
            if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == closingTag) {
                if (tag.isEndTag()) {
                    if (count == 0) break;
                    --count;
                } else {
                    ++count;
                }
            }
            sb.append(token.toString());
            token = tokenizer.nextToken();
        }
        return sb.toString();
    }

    private void addCustomFields(Issue issue, PostMethod post) {
        CustomField[] customFieldArray = issue.getCustomFields();
        int n = customFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomField customField = customFieldArray[n2];
            for (String value : customField.getValues()) {
                String key = customField.getKey();
                if (key != null && (key.startsWith("com.atlassian.jira.toolkit") || key.startsWith("com.atlassian.jira.ext.charting"))) continue;
                post.addParameter(customField.getId(), value == null ? "" : value);
            }
            ++n2;
        }
    }
}

