/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.model.Issue;
import org.eclipse.mylyn.internal.jira.core.service.JiraAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraServiceUnavailableException;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSessionCallback;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.mylyn.web.core.AuthenticationCredentials;
import org.eclipse.mylyn.web.core.AuthenticationType;
import org.eclipse.mylyn.web.core.WebClientUtil;

public class JiraWebSession {
    private static final int MAX_REDIRECTS = 3;
    private final JiraClient client;
    private String baseUrl;
    private String characterEncoding;
    private boolean secure;
    private boolean insecureRedirect;
    private boolean logEnabled;
    private AbstractWebLocation location;
    protected static final String USER_AGENT = "JiraConnector";

    public JiraWebSession(JiraClient client, String baseUrl) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.secure = baseUrl.startsWith("https");
        this.location = client.getLocation();
    }

    public JiraWebSession(JiraClient client) {
        this(client, client.getBaseUrl());
    }

    public void doInSession(JiraWebSessionCallback callback) throws JiraException {
        HttpClient httpClient = new HttpClient();
        WebClientUtil.setupHttpClient((HttpClient)httpClient, (String)USER_AGENT, (AbstractWebLocation)this.location);
        this.login(httpClient);
        try {
            try {
                callback.execute(httpClient, this.client, this.baseUrl);
            }
            catch (IOException e) {
                throw new JiraException(e);
            }
        }
        finally {
            this.logout(httpClient);
        }
    }

    protected String getCharacterEncoding() {
        return this.characterEncoding;
    }

    protected String getContentType() throws JiraException {
        return "application/x-www-form-urlencoded; charset=" + this.client.getCharacterEncoding();
    }

    protected String getBaseURL() {
        return this.baseUrl;
    }

    protected boolean isInsecureRedirect() {
        return this.insecureRedirect;
    }

    protected boolean isSecure() {
        return this.secure;
    }

    protected boolean isLogEnabled() {
        return this.logEnabled;
    }

    protected void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    private void login(HttpClient httpClient) throws JiraException {
        RedirectTracker tracker = new RedirectTracker();
        String url = String.valueOf(this.baseUrl) + "/login.jsp";
        int i = 0;
        while (i <= 3) {
            block13: {
                AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
                if (credentials == null) {
                    credentials = new AuthenticationCredentials("", "");
                }
                PostMethod login = new PostMethod(url);
                login.setFollowRedirects(false);
                login.getParams().setCookiePolicy("compatibility");
                login.addParameter("os_username", credentials.getUserName());
                login.addParameter("os_password", credentials.getPassword());
                login.addParameter("os_destination", "/success");
                tracker.addUrl(url);
                try {
                    int statusCode = httpClient.executeMethod((HttpMethod)login);
                    if (this.needsReauthentication(httpClient, statusCode)) break block13;
                    if (statusCode != 302 && statusCode != 301) {
                        throw new JiraServiceUnavailableException("Unexpected status code during login: " + statusCode);
                    }
                    tracker.addRedirect(url, (HttpMethodBase)login, statusCode);
                    this.characterEncoding = login.getResponseCharSet();
                    Header locationHeader = login.getResponseHeader("location");
                    if (locationHeader == null) {
                        throw new JiraServiceUnavailableException("Invalid redirect, missing location");
                    }
                    url = locationHeader.getValue();
                    tracker.checkForCircle(url);
                    if (!this.insecureRedirect && this.isSecure() && url.startsWith("http://")) {
                        tracker.log("Redirect to insecure location during login to repository: " + this.client.getBaseUrl());
                        this.insecureRedirect = true;
                    }
                    if (!url.endsWith("/success")) break block13;
                    String newBaseUrl = url.substring(0, url.lastIndexOf("/success"));
                    if (this.baseUrl.equals(newBaseUrl)) {
                        return;
                    }
                    try {
                        this.baseUrl = newBaseUrl;
                        url = String.valueOf(newBaseUrl) + "/login.jsp";
                    }
                    catch (IOException e) {
                        throw new JiraServiceUnavailableException(e);
                    }
                }
                finally {
                    login.releaseConnection();
                }
            }
            ++i;
        }
        tracker.log("Exceeded maximum number of allowed redirects during login to repository: " + this.client.getBaseUrl());
        throw new JiraServiceUnavailableException("Exceeded maximum number of allowed redirects during login");
    }

    private boolean needsReauthentication(HttpClient httpClient, int code) throws JiraAuthenticationException {
        AuthenticationType authenticationType;
        if (code == 200) {
            authenticationType = AuthenticationType.REPOSITORY;
        } else if (code == 407) {
            authenticationType = AuthenticationType.PROXY;
        } else {
            return false;
        }
        if (this.location.requestCredentials(authenticationType, null) == AbstractWebLocation.ResultType.NOT_SUPPORTED) {
            throw new JiraAuthenticationException("Login failed.");
        }
        WebClientUtil.setupHttpClient((HttpClient)httpClient, (String)USER_AGENT, (AbstractWebLocation)this.location);
        return true;
    }

    private void logout(HttpClient httpClient) throws JiraException {
        GetMethod logout = new GetMethod(String.valueOf(this.baseUrl) + "/logout");
        logout.setFollowRedirects(false);
        try {
            try {
                httpClient.executeMethod((HttpMethod)logout);
            }
            catch (IOException iOException) {
                logout.releaseConnection();
            }
        }
        finally {
            logout.releaseConnection();
        }
    }

    protected boolean expectRedirect(HttpMethodBase method, Issue issue) throws JiraException {
        return this.expectRedirect(method, "/browse/" + issue.getKey());
    }

    protected boolean expectRedirect(HttpMethodBase method, String page) throws JiraException {
        if (method.getStatusCode() != 302) {
            return false;
        }
        Header locationHeader = method.getResponseHeader("location");
        if (locationHeader == null) {
            throw new JiraServiceUnavailableException("Invalid server response, missing redirect location");
        }
        String url = locationHeader.getValue();
        if (!url.startsWith(String.valueOf(this.baseUrl) + page)) {
            throw new JiraException("Server redirected to unexpected location: " + url);
        }
        return true;
    }

    private class RedirectInfo {
        final int statusCode;
        final String url;
        final Header[] responseHeaders;

        public RedirectInfo(String url, int statusCode, Header[] responseHeaders) {
            this.url = url;
            this.statusCode = statusCode;
            this.responseHeaders = responseHeaders;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Request: ");
            sb.append(this.url).append('\n');
            sb.append("Status: ").append(this.statusCode).append('\n');
            Header[] headerArray = this.responseHeaders;
            int n = this.responseHeaders.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                if (header.getName().equalsIgnoreCase("Server") || header.getName().equalsIgnoreCase("Location")) {
                    sb.append(header.toExternalForm());
                }
                ++n2;
            }
            return sb.toString();
        }
    }

    private class RedirectTracker {
        ArrayList<RedirectInfo> redirects = new ArrayList();
        Set<String> urls = new HashSet<String>();
        private boolean loggedCircle;

        private RedirectTracker() {
        }

        public void addUrl(String url) {
            this.urls.add(url);
        }

        public void checkForCircle(String url) {
            if (!this.loggedCircle && this.urls.contains(url)) {
                this.log("Circular redirect detected while login in to repository: " + JiraWebSession.this.client.getBaseUrl());
                this.loggedCircle = true;
            }
        }

        public void addRedirect(String url, HttpMethodBase method, int statusCode) {
            this.redirects.add(new RedirectInfo(url, statusCode, method.getResponseHeaders()));
        }

        public void log(String message) {
            if (!JiraWebSession.this.isLogEnabled()) {
                return;
            }
            MultiStatus status = new MultiStatus("org.eclipse.mylyn.internal.jira.core", 0, message, null);
            for (RedirectInfo info : this.redirects) {
                status.add((IStatus)new Status(2, "org.eclipse.mylyn.internal.jira.core", 0, info.toString(), null));
            }
            JiraCorePlugin.log((IStatus)status);
        }
    }
}

