/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web.rss;

import java.text.SimpleDateFormat;
import java.util.Locale;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.Status;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateRangeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.PriorityFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.RelativeDateRangeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.ResolutionFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.StatusFilter;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.RssFilterConverter;

public class Jira33RssFilterConverter
extends RssFilterConverter {
    private final String DATE_FORMAT = "dd/MMM/yy";

    protected String convertResolutionFilter(ResolutionFilter resolutionFilter) {
        if (resolutionFilter.isUnresolved()) {
            return "resolution=-1";
        }
        Resolution[] resolution = resolutionFilter.getResolutions();
        if (resolution.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("resolution=").append(resolution[0].getId());
        int i = 1;
        while (i < resolution.length) {
            buffer.append("&resolution=").append(resolution[i].getId());
            ++i;
        }
        return buffer.toString();
    }

    protected String convertPriorityFilter(PriorityFilter priorityFilter) {
        Priority[] priorities = priorityFilter.getPriorities();
        if (priorities.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("priority=").append(priorities[0].getId());
        int i = 1;
        while (i < priorities.length) {
            buffer.append("&priority=").append(priorities[i].getId());
            ++i;
        }
        return buffer.toString();
    }

    protected String convertStatusFilter(StatusFilter statusFilter) {
        Status[] statuses = statusFilter.getStatuses();
        if (statuses.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("status=").append(statuses[0].getId());
        int i = 1;
        while (i < statuses.length) {
            buffer.append("&status=").append(statuses[i].getId());
            ++i;
        }
        return buffer.toString();
    }

    protected String convertCreatedDateFilter(DateFilter createdDateFilter) {
        return this.createDateFilter(createdDateFilter, "created");
    }

    protected String convertUpdatedDateFilter(DateFilter updatedDateFilter) {
        return this.createDateFilter(updatedDateFilter, "updated");
    }

    protected String convertDueDateFilter(DateFilter dueDateFilter) {
        return this.createDateFilter(dueDateFilter, "duedate");
    }

    private String createDateFilter(DateFilter dateFilter, String name) {
        StringBuffer buffer = new StringBuffer();
        if (dateFilter instanceof DateRangeFilter) {
            SimpleDateFormat df = new SimpleDateFormat("dd/MMM/yy", Locale.US);
            DateRangeFilter filter = (DateRangeFilter)dateFilter;
            if (filter.getFromDate() != null) {
                buffer.append("&" + name + ":after=").append(df.format(filter.getFromDate()));
            }
            if (filter.getToDate() != null) {
                buffer.append("&" + name + ":before=").append(df.format(filter.getToDate()));
            }
        } else if (dateFilter instanceof RelativeDateRangeFilter) {
            RelativeDateRangeFilter filter = (RelativeDateRangeFilter)dateFilter;
            if (filter.previousMilliseconds() != 0L) {
                buffer.append("&" + name + ":previous=").append(this.createRelativeDateString(filter.getPreviousRangeType(), filter.getPreviousCount()));
            }
            if (filter.nextMilliseconds() != 0L) {
                buffer.append("&" + name + ":next=").append(this.createRelativeDateString(filter.getNextRangeType(), filter.getNextCount()));
            }
        }
        return buffer.toString();
    }

    private String createRelativeDateString(RelativeDateRangeFilter.RangeType rangeType, long count) {
        StringBuffer dateString = new StringBuffer("");
        dateString.append(Long.toString(count));
        if (RelativeDateRangeFilter.RangeType.MINUTE.equals(rangeType)) {
            dateString.append('m');
        } else if (RelativeDateRangeFilter.RangeType.HOUR.equals(rangeType)) {
            dateString.append('h');
        } else if (RelativeDateRangeFilter.RangeType.DAY.equals(rangeType)) {
            dateString.append('d');
        } else if (RelativeDateRangeFilter.RangeType.WEEK.equals(rangeType)) {
            dateString.append('w');
        }
        return dateString.toString();
    }
}

