/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web.rss;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.ParseCancelledException;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.RssContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class RssReader {
    private final JiraClient server;
    private final IssueCollector collector;

    public RssReader(JiraClient server, IssueCollector collector) {
        this.server = server;
        this.collector = collector;
    }

    public void readRssFeed(InputStream feed, String baseUrl) throws JiraException, IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setContentHandler(new RssContentHandler(this.server, this.collector, baseUrl));
            InputSource inputSource = new InputSource(feed);
            inputSource.setEncoding(this.server.getCharacterEncoding());
            reader.parse(inputSource);
            this.collector.done();
        }
        catch (ParseCancelledException parseCancelledException) {
        }
        catch (SAXException e) {
            throw new JiraException("Error parsing server response: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new JiraException("Internal error parsing server response", e);
        }
    }
}

