/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.model.Attachment;
import org.eclipse.mylyn.internal.jira.core.model.Issue;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.ui.AttachmentPartSource;
import org.eclipse.mylyn.internal.jira.ui.JiraClientFactory;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class JiraAttachmentHandler
extends AbstractAttachmentHandler {
    public static final String CONTEXT_ATTACHEMNT_FILENAME = "mylyn-context.zip";
    public static final String CONTEXT_ATTACHEMNT_FILENAME_LEGACY = "mylar-context.zip";

    public void downloadAttachment(TaskRepository repository, RepositoryAttachment attachment, OutputStream out, IProgressMonitor monitor) throws CoreException {
        String id = attachment.getAttributeValue("task.common.attachment.id");
        if (id == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.jira.ui", 7, "Attachment download from " + repository.getUrl() + " failed, missing attachment id.", null));
        }
        String key = attachment.getTaskId();
        if (key == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.jira.ui", 7, "Attachment download from " + repository.getUrl() + " failed, missing attachment key.", null));
        }
        JiraClient server = JiraClientFactory.getDefault().getJiraClient(repository);
        try {
            Issue issue = server.getIssueByKey(key);
            Attachment jiraAttachment = issue.getAttachmentById(id);
            server.retrieveFile(issue, jiraAttachment, out);
        }
        catch (JiraException e) {
            throw new CoreException(JiraCorePlugin.toStatus((TaskRepository)repository, (Throwable)e));
        }
    }

    public InputStream getAttachmentAsStream(TaskRepository repository, RepositoryAttachment attachment, IProgressMonitor monitor) throws CoreException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.downloadAttachment(repository, attachment, out, monitor);
        return new ByteArrayInputStream(out.toByteArray());
    }

    public void uploadAttachment(TaskRepository repository, AbstractTask task, ITaskAttachment attachment, String comment, IProgressMonitor monitor) throws CoreException {
        JiraClient server = JiraClientFactory.getDefault().getJiraClient(repository);
        try {
            Issue issue = server.getIssueByKey(task.getTaskKey());
            server.attachFile(issue, comment, (PartSource)new AttachmentPartSource(attachment), attachment.getContentType());
        }
        catch (JiraException e) {
            throw new CoreException(JiraCorePlugin.toStatus((TaskRepository)repository, (Throwable)e));
        }
    }

    public boolean canDownloadAttachment(TaskRepository repository, AbstractTask task) {
        return true;
    }

    public boolean canUploadAttachment(TaskRepository repository, AbstractTask task) {
        return true;
    }

    public boolean canDeprecate(TaskRepository repository, RepositoryAttachment attachment) {
        return false;
    }

    public void updateAttachment(TaskRepository repository, RepositoryAttachment attachment) throws CoreException {
        throw new UnsupportedOperationException();
    }
}

