/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import org.eclipse.mylyn.internal.jira.core.JiraClientManager;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.ui.IJiraClientFactory;
import org.eclipse.mylyn.internal.jira.ui.JiraUtils;
import org.eclipse.mylyn.tasks.core.ITaskRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.web.core.AbstractWebLocation;

public class JiraClientFactory
implements ITaskRepositoryListener,
IJiraClientFactory {
    private static JiraClientFactory instance = null;
    private JiraClientManager clientManager = null;
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory = new TaskRepositoryLocationFactory();
    private boolean forceTaskRepositoryLocationFactory;

    private JiraClientFactory() {
        this.clientManager = JiraCorePlugin.getDefault().getServerManager();
        TasksUiPlugin.getRepositoryManager().addListener((ITaskRepositoryListener)this);
    }

    public void clearClients() {
        this.clientManager.removeAllClients(false);
    }

    public void clearClientsAndConfigurationData() {
        this.clientManager.removeAllClients(true);
    }

    public synchronized JiraClient getJiraClient(TaskRepository repository) {
        JiraClient server = this.clientManager.getClient(repository.getUrl());
        if (server == null) {
            AbstractWebLocation location = this.taskRepositoryLocationFactory.createWebLocation(repository);
            String characterEncoding = null;
            if (JiraUtils.getCharacterEncodingValidated(repository)) {
                characterEncoding = repository.getCharacterEncoding();
            }
            server = this.clientManager.addClient(location, characterEncoding, JiraUtils.getCompression(repository));
        }
        return server;
    }

    public static synchronized JiraClientFactory getDefault() {
        if (instance == null) {
            instance = new JiraClientFactory();
        }
        return instance;
    }

    public synchronized void logOutFromAll() {
        try {
            JiraClient[] allServers = this.clientManager.getAllClients();
            int i = 0;
            while (i < allServers.length) {
                allServers[i].logout();
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public void repositoriesRead() {
    }

    public synchronized void repositoryAdded(TaskRepository repository) {
        if (repository.getConnectorKind().equals("jira")) {
            assert (this.clientManager.getClient(repository.getUrl()) == null);
            this.getJiraClient(repository);
        }
    }

    public synchronized void repositoryRemoved(TaskRepository repository) {
        if (repository.getConnectorKind().equals("jira")) {
            JiraClient server = this.clientManager.getClient(repository.getUrl());
            this.removeServer(server);
        }
    }

    public synchronized void repositorySettingsChanged(TaskRepository repository) {
        this.repositoryRemoved(repository);
        this.repositoryAdded(repository);
    }

    private synchronized void removeServer(JiraClient server) {
        if (server != null) {
            server.logout();
            this.clientManager.removeClient(server);
        }
    }

    public ServerInfo validateConnection(AbstractWebLocation location) throws JiraException {
        ServerInfo info = this.clientManager.validateConnection(location);
        JiraVersion serverVersion = new JiraVersion(info.getVersion());
        if (JiraVersion.MIN_VERSION.compareTo(serverVersion) > 0) {
            throw new JiraException("JIRA connector requires server " + JiraVersion.MIN_VERSION + " or later");
        }
        return info;
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory, boolean force) {
        if (this.forceTaskRepositoryLocationFactory) {
            return;
        }
        this.forceTaskRepositoryLocationFactory = force;
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }
}

