/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.jira.ui.JiraCustomQuery;
import org.eclipse.mylyn.internal.jira.ui.JiraImages;
import org.eclipse.mylyn.internal.jira.ui.JiraRepositoryQuery;
import org.eclipse.mylyn.internal.jira.ui.JiraTask;
import org.eclipse.mylyn.internal.jira.ui.wizards.EditJiraQueryWizard;
import org.eclipse.mylyn.internal.jira.ui.wizards.JiraQueryPage;
import org.eclipse.mylyn.internal.jira.ui.wizards.JiraRepositorySettingsPage;
import org.eclipse.mylyn.internal.jira.ui.wizards.NewJiraQueryWizard;
import org.eclipse.mylyn.internal.jira.ui.wizards.NewJiraTaskWizard;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraConnectorUi
extends AbstractRepositoryConnectorUi {
    public String getTaskKindLabel(AbstractTask repositoryTask) {
        return "Issue";
    }

    public String getTaskKindLabel(RepositoryTaskData taskData) {
        return "Issue";
    }

    public List<AbstractTaskContainer> getLegendItems() {
        ArrayList<AbstractTaskContainer> legendItems = new ArrayList<AbstractTaskContainer>();
        JiraTask bug = new JiraTask("", "bug", "Bug");
        bug.setTaskKind(JiraTask.Kind.BUG.toString());
        legendItems.add((AbstractTaskContainer)bug);
        JiraTask feature = new JiraTask("", "feature", "Feature");
        feature.setTaskKind(JiraTask.Kind.FEATURE.toString());
        legendItems.add((AbstractTaskContainer)feature);
        JiraTask improvement = new JiraTask("", "improvement", "Improvement");
        improvement.setTaskKind(JiraTask.Kind.IMPROVEMENT.toString());
        legendItems.add((AbstractTaskContainer)improvement);
        JiraTask task = new JiraTask("", "task", "Task");
        task.setTaskKind(JiraTask.Kind.TASK.toString());
        legendItems.add((AbstractTaskContainer)task);
        JiraTask subTask = new JiraTask("", "task", "Sub-task");
        subTask.setTaskKind(JiraTask.Kind.SUB_TASK.toString());
        legendItems.add((AbstractTaskContainer)subTask);
        return legendItems;
    }

    public ImageDescriptor getTaskKindOverlay(AbstractTask repositoryTask) {
        if (repositoryTask instanceof JiraTask) {
            JiraTask task = (JiraTask)repositoryTask;
            if (JiraTask.Kind.BUG.toString().equals(task.getTaskKind())) {
                return JiraImages.OVERLAY_BUG;
            }
            if (JiraTask.Kind.FEATURE.toString().equals(task.getTaskKind())) {
                return JiraImages.OVERLAY_FEATURE;
            }
            if (JiraTask.Kind.IMPROVEMENT.toString().equals(task.getTaskKind())) {
                return JiraImages.OVERLAY_IMPROVEMENT;
            }
            if (JiraTask.Kind.TASK.toString().equals(task.getTaskKind())) {
                return JiraImages.OVERLAY_TASK;
            }
            if (JiraTask.Kind.SUB_TASK.toString().equals(task.getTaskKind())) {
                return JiraImages.OVERLAY_SUB_TASK;
            }
        }
        return super.getTaskKindOverlay(repositoryTask);
    }

    public WizardPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new JiraQueryPage(repository);
    }

    public AbstractRepositorySettingsPage getSettingsPage() {
        return new JiraRepositorySettingsPage(this);
    }

    public IWizard getQueryWizard(TaskRepository repository, AbstractRepositoryQuery query) {
        if (query instanceof JiraRepositoryQuery || query instanceof JiraCustomQuery) {
            return new EditJiraQueryWizard(repository, query);
        }
        return new NewJiraQueryWizard(repository);
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository) {
        return new NewJiraTaskWizard(taskRepository, null);
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository, TaskSelection taskSelection) {
        return new NewJiraTaskWizard(taskRepository, taskSelection);
    }

    public String getConnectorKind() {
        return "jira";
    }

    public boolean hasSearchPage() {
        return true;
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int lineOffset, int regionOffset) {
        String[] taskIds;
        int endPos;
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        if (text.length() == 0) {
            return null;
        }
        int startPos = lineOffset;
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos >= text.length()) {
            startPos = text.length() - 1;
        }
        while (startPos > 0) {
            char c = text.charAt(startPos);
            if (Character.isWhitespace(c) || ",.;[](){}".indexOf(c) > -1) break;
            --startPos;
        }
        if ((endPos = lineOffset) < 0) {
            endPos = 0;
        } else if (endPos >= text.length()) {
            endPos = text.length() - 1;
        }
        while (endPos < text.length()) {
            char c = text.charAt(endPos);
            if (Character.isWhitespace(c) || ",.;[](){}".indexOf(c) > -1) break;
            ++endPos;
        }
        if ((taskIds = connector.getTaskIdsFromComment(repository, text.substring(startPos, endPos))) == null || taskIds.length == 0) {
            return null;
        }
        IHyperlink[] links = new IHyperlink[taskIds.length];
        int i = 0;
        while (i < taskIds.length) {
            String taskId = taskIds[i];
            int startRegion = text.indexOf(taskId, startPos);
            links[i] = new TaskHyperlink((IRegion)new Region(regionOffset + startRegion, taskId.length()), repository, taskId);
            ++i;
        }
        return links;
    }

    public boolean supportsDueDates(AbstractTask task) {
        RepositoryTaskData taskData;
        if (task instanceof JiraTask && (taskData = TasksUiPlugin.getTaskDataManager().getNewTaskData(task.getRepositoryUrl(), task.getTaskId())) != null && taskData.getAttribute("attribute.jira.due") != null) {
            return true;
        }
        return super.supportsDueDates(task);
    }
}

