/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.jira.core.model.filter.ContentFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.ui.JiraCustomQuery;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITaskFactory;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.ui.TaskFactory;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractNewRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.search.SearchHitCollector;

public class JiraStackTraceDuplicateDetector
extends AbstractDuplicateDetector {
    private static final String NO_STACK_MESSAGE = "Unable to locate a stack trace in the description text.";

    public SearchHitCollector getSearchHitCollector(TaskRepository repository, RepositoryTaskData taskData) {
        String searchString = AbstractNewRepositoryTaskEditor.getStackTraceFromDescription((String)taskData.getDescription());
        if (searchString == null) {
            MessageDialog.openWarning(null, (String)"No Stack Trace Found", (String)NO_STACK_MESSAGE);
            return null;
        }
        String encoding = repository.getCharacterEncoding();
        FilterDefinition filter = new FilterDefinition();
        filter.setContentFilter(new ContentFilter(searchString, false, true, false, true));
        JiraCustomQuery query = new JiraCustomQuery(repository.getUrl(), filter, encoding);
        return new SearchHitCollector(TasksUiPlugin.getTaskListManager().getTaskList(), repository, (AbstractRepositoryQuery)query, (ITaskFactory)new TaskFactory(repository, false, false));
    }
}

