/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.html.HTML2TextReader;
import org.eclipse.mylyn.internal.jira.core.model.Comment;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.Issue;
import org.eclipse.mylyn.internal.jira.core.model.IssueLink;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.SecurityLevel;
import org.eclipse.mylyn.internal.jira.core.model.Status;
import org.eclipse.mylyn.internal.jira.core.model.Subtask;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraInsufficientPermissionException;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteCustomFieldValue;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteIssue;
import org.eclipse.mylyn.internal.jira.ui.IJiraClientFactory;
import org.eclipse.mylyn.internal.jira.ui.JiraAttribute;
import org.eclipse.mylyn.internal.jira.ui.JiraAttributeFactory;
import org.eclipse.mylyn.internal.jira.ui.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.ui.JiraFieldType;
import org.eclipse.mylyn.internal.jira.ui.JiraRepositoryConnector;
import org.eclipse.mylyn.internal.jira.ui.JiraUiPlugin;
import org.eclipse.mylyn.internal.jira.ui.JiraUtils;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraTaskDataHandler
extends AbstractTaskDataHandler {
    private static final boolean TRACE_ENABLED = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.mylyn.internal.jira.ui/dataHandler"));
    private static final String REASSIGN_OPERATION = "reassign";
    private static final String LEAVE_OPERATION = "leave";
    private static final JiraAttributeFactory attributeFactory = new JiraAttributeFactory();
    private final IJiraClientFactory clientFactory;

    public JiraTaskDataHandler(IJiraClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public RepositoryTaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        try {
            Issue jiraIssue;
            JiraClient client = this.clientFactory.getJiraClient(repository);
            if (!client.hasDetails()) {
                client.refreshDetails((IProgressMonitor)new NullProgressMonitor());
            }
            if ((jiraIssue = this.getJiraIssue(client, taskId, repository.getUrl())) != null) {
                return this.createTaskData(repository, client, jiraIssue, null);
            }
            throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.mylyn.internal.jira.core", 0, "JIRA ticket not found: " + taskId, null));
        }
        catch (JiraException e) {
            IStatus status = JiraCorePlugin.toStatus((TaskRepository)repository, (Throwable)e);
            JiraTaskDataHandler.trace(status);
            throw new CoreException(status);
        }
    }

    private Issue getJiraIssue(JiraClient client, String taskId, String repositoryUrl) throws CoreException, JiraException {
        try {
            int id = Integer.parseInt(taskId);
            AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(repositoryUrl, "" + id);
            if (task != null) {
                return client.getIssueByKey(task.getTaskKey());
            }
            String issueKey = client.getKeyFromId(taskId);
            return client.getIssueByKey(issueKey);
        }
        catch (NumberFormatException numberFormatException) {
            return client.getIssueByKey(taskId);
        }
    }

    public RepositoryTaskData createTaskData(TaskRepository repository, JiraClient client, Issue jiraIssue, RepositoryTaskData oldTaskData) throws JiraException {
        RepositoryTaskData data = new RepositoryTaskData((AbstractAttributeFactory)attributeFactory, "jira", repository.getUrl(), jiraIssue.getId());
        this.initializeTaskData(data, client, jiraIssue.getProject());
        this.updateTaskData(data, jiraIssue, client, oldTaskData);
        this.addOperations(data, jiraIssue, client, oldTaskData);
        return data;
    }

    public void initializeTaskData(RepositoryTaskData data, JiraClient client, Project project) {
        data.removeAllAttributes();
        this.addAttribute(data, "task.common.date.created");
        this.addAttribute(data, "task.common.summary");
        this.addAttribute(data, "task.common.description");
        this.addAttribute(data, "task.common.status");
        this.addAttribute(data, "task.common.key");
        this.addAttribute(data, "task.common.resolution");
        this.addAttribute(data, "task.common.user.assigned");
        this.addAttribute(data, "task.common.user.reporter");
        this.addAttribute(data, "task.common.date.modified");
        this.addAttribute(data, "task.common.product");
        RepositoryTaskAttribute priorities = this.addAttribute(data, "task.common.priority");
        priorities.putMetaDataValue("type", JiraFieldType.SELECT.getKey());
        Priority[] jiraPriorities = client.getPriorities();
        int i = 0;
        while (i < jiraPriorities.length) {
            Priority priority = jiraPriorities[i];
            priorities.addOption(priority.getName(), priority.getId());
            if (i == jiraPriorities.length / 2) {
                priorities.setValue(priority.getName());
            }
            ++i;
        }
        RepositoryTaskAttribute types = this.addAttribute(data, "attribute.jira.type");
        types.putMetaDataValue("type", JiraFieldType.SELECT.getKey());
        IssueType[] jiraIssueTypes = client.getIssueTypes();
        int i2 = 0;
        while (i2 < jiraIssueTypes.length) {
            IssueType type = jiraIssueTypes[i2];
            if (!type.isSubTaskType()) {
                types.addOption(type.getName(), type.getId());
                if (i2 == 0) {
                    types.setValue(type.getName());
                }
            }
            ++i2;
        }
        this.addAttribute(data, "attribute.jira.issue_parent_key");
        this.addAttribute(data, "attribute.jira.issue_parent_id");
        this.addAttribute(data, "attribute.jira.due");
        this.addAttribute(data, "attribute.jira.estimate");
        RepositoryTaskAttribute affectsVersions = this.addAttribute(data, "attribute.jira.affectsversions");
        affectsVersions.putMetaDataValue("type", JiraFieldType.MULTISELECT.getKey());
        Version[] versionArray = project.getVersions();
        int n = versionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version version = versionArray[n2];
            affectsVersions.addOption(version.getName(), version.getId());
            ++n2;
        }
        RepositoryTaskAttribute components = this.addAttribute(data, "attribute.jira.components");
        components.putMetaDataValue("type", JiraFieldType.SELECT.getKey());
        Component[] componentArray = project.getComponents();
        int n3 = componentArray.length;
        n = 0;
        while (n < n3) {
            Component component = componentArray[n];
            components.addOption(component.getName(), component.getId());
            ++n;
        }
        RepositoryTaskAttribute fixVersions = this.addAttribute(data, "attribute.jira.fixversions");
        fixVersions.putMetaDataValue("type", JiraFieldType.MULTISELECT.getKey());
        Version[] versionArray2 = project.getVersions();
        int n4 = versionArray2.length;
        n3 = 0;
        while (n3 < n4) {
            Version version = versionArray2[n3];
            fixVersions.addOption(version.getName(), version.getId());
            ++n3;
        }
        RepositoryTaskAttribute environment = this.addAttribute(data, "attribute.jira.environment");
        environment.putMetaDataValue("type", JiraFieldType.TEXTAREA.getKey());
        RepositoryTaskAttribute newComment = this.addAttribute(data, "task.common.comment.new");
        newComment.putMetaDataValue("type", JiraFieldType.TEXTAREA.getKey());
    }

    private RepositoryTaskAttribute addAttribute(RepositoryTaskData data, String key) {
        data.addAttribute(key, attributeFactory.createAttribute(key));
        return data.getAttribute(key);
    }

    private void updateTaskData(RepositoryTaskData data, Issue jiraIssue, JiraClient client, RepositoryTaskData oldTaskData) throws JiraException {
        RepositoryTaskAttribute[] name;
        Component version;
        IssueType issueType;
        Comment[] attribute8;
        Component[] label2;
        String parentKey = jiraIssue.getParentKey();
        if (parentKey != null) {
            data.setAttributeValue("attribute.jira.issue_parent_key", parentKey);
        } else {
            data.removeAttribute((Object)"attribute.jira.issue_parent_key");
        }
        String parentId = jiraIssue.getParentId();
        if (parentId != null) {
            data.setAttributeValue("attribute.jira.issue_parent_id", parentId);
        } else {
            data.removeAttribute((Object)"attribute.jira.issue_parent_id");
        }
        data.removeAttribute((Object)"attribute.jira.subtask_ids");
        data.removeAttribute((Object)"attribute.jira.subtask_keys");
        Subtask[] subtasks = jiraIssue.getSubtasks();
        if (subtasks != null && subtasks.length > 0) {
            Subtask[] subtaskArray = subtasks;
            int n = subtasks.length;
            int n2 = 0;
            while (n2 < n) {
                Subtask subtask = subtaskArray[n2];
                data.addAttributeValue("attribute.jira.subtask_ids", subtask.getIssueId());
                data.addAttributeValue("attribute.jira.subtask_keys", subtask.getIssueKey());
                ++n2;
            }
        }
        IssueLink[] issueLinks = jiraIssue.getIssueLinks();
        this.removeAttributes(data, "attribute.jira.link::");
        if (issueLinks != null && issueLinks.length > 0) {
            HashMap<String, Comment[]> links = new HashMap<String, Comment[]>();
            int i = 0;
            while (i < issueLinks.length) {
                String desc;
                String key;
                IssueLink link = issueLinks[i];
                if (link.getInwardDescription() == null) {
                    key = String.valueOf(link.getLinkTypeId()) + "outward";
                    desc = link.getOutwardDescription();
                } else {
                    key = String.valueOf(link.getLinkTypeId()) + "inward";
                    desc = link.getInwardDescription();
                }
                label2 = String.valueOf(this.capitalize(desc)) + ":";
                attribute8 = (Comment[])links.get(key);
                if (attribute8 == null) {
                    attribute8 = new RepositoryTaskAttribute("attribute.jira.link::" + key, (String)label2, false);
                    attribute8.setReadOnly(true);
                    attribute8.putMetaDataValue("type", JiraFieldType.ISSUELINKS.getKey());
                    links.put(key, attribute8);
                }
                attribute8.addValue(link.getIssueKey());
                ++i;
            }
            for (RepositoryTaskAttribute attribute2 : links.values()) {
                data.addAttribute(attribute2.getId(), attribute2);
            }
        }
        data.setAttributeValue("task.common.date.created", JiraUtils.dateToString(jiraIssue.getCreated()));
        data.setAttributeValue("task.common.summary", jiraIssue.getSummary());
        data.setAttributeValue("task.common.description", jiraIssue.getDescription());
        data.setAttributeValue("task.common.status", jiraIssue.getStatus().getName());
        data.setAttributeValue("task.common.key", jiraIssue.getKey());
        data.setAttributeValue("task.common.resolution", jiraIssue.getResolution() == null ? "" : jiraIssue.getResolution().getName());
        data.setAttributeValue("task.common.date.modified", JiraUtils.dateToString(jiraIssue.getUpdated()));
        data.setAttributeValue("task.common.user.assigned", this.getAssignee(jiraIssue));
        data.setAttributeValue("task.common.user.reporter", jiraIssue.getReporter());
        data.setAttributeValue("task.common.product", jiraIssue.getProject().getName());
        if (jiraIssue.getPriority() != null) {
            data.setAttributeValue("task.common.priority", jiraIssue.getPriority().getName());
        } else {
            data.removeAttribute((Object)"task.common.priority");
        }
        SecurityLevel securityLevel = jiraIssue.getSecurityLevel();
        if (securityLevel != null) {
            RepositoryTaskAttribute attribute3 = this.addAttribute(data, "attribute.jira.security");
            attribute3.addOption(securityLevel.getName(), securityLevel.getId());
            attribute3.setValue(securityLevel.getName());
        }
        if ((issueType = jiraIssue.getType()) != null) {
            data.setAttributeValue("attribute.jira.type", issueType.getName());
            if (issueType.isSubTaskType()) {
                RepositoryTaskAttribute attribute4 = data.getAttribute("attribute.jira.type");
                attribute4.setReadOnly(true);
                attribute4.clearOptions();
            }
        } else {
            data.removeAttribute((Object)"attribute.jira.type");
        }
        data.setAttributeValue("attribute.jira.estimate", Long.toString(jiraIssue.getEstimate() / 60L));
        if (jiraIssue.getDue() != null) {
            data.setAttributeValue("attribute.jira.due", JiraUtils.dateToString(jiraIssue.getDue()));
        } else {
            data.removeAttribute((Object)"attribute.jira.due");
        }
        this.removeAttributeValues(data, "attribute.jira.components");
        if (jiraIssue.getComponents() != null) {
            label2 = jiraIssue.getComponents();
            int desc = label2.length;
            int key = 0;
            while (key < desc) {
                Component component = label2[key];
                data.addAttributeValue("attribute.jira.components", component.getName());
                ++key;
            }
        }
        this.removeAttributeValues(data, "attribute.jira.affectsversions");
        if (jiraIssue.getReportedVersions() != null) {
            label2 = jiraIssue.getReportedVersions();
            int desc = label2.length;
            int key = 0;
            while (key < desc) {
                version = label2[key];
                data.addAttributeValue("attribute.jira.affectsversions", version.getName());
                ++key;
            }
        }
        this.removeAttributeValues(data, "attribute.jira.fixversions");
        if (jiraIssue.getFixVersions() != null) {
            label2 = jiraIssue.getFixVersions();
            int desc = label2.length;
            int key = 0;
            while (key < desc) {
                version = label2[key];
                data.addAttributeValue("attribute.jira.fixversions", version.getName());
                ++key;
            }
        }
        if (jiraIssue.getEnvironment() != null) {
            data.setAttributeValue("attribute.jira.environment", jiraIssue.getEnvironment());
        } else {
            data.removeAttribute((Object)"attribute.jira.environment");
        }
        int x = 1;
        attribute8 = jiraIssue.getComments();
        int label2 = attribute8.length;
        int desc = 0;
        while (desc < label2) {
            Comment comment = attribute8[desc];
            TaskComment taskComment = new TaskComment((AbstractAttributeFactory)attributeFactory, x++);
            taskComment.addAttribute("task.common.comment.author", this.createAuthorAttribute(comment.getAuthor()));
            String commentText = comment.getComment();
            if (comment.isMarkupDetected()) {
                commentText = JiraTaskDataHandler.stripTags(commentText);
            }
            taskComment.addAttributeValue("task.common.comment.text", commentText);
            taskComment.addAttributeValue("task.common.comment.date", this.formatDate(comment.getCreated()));
            data.addComment(taskComment);
            ++desc;
        }
        attribute8 = jiraIssue.getAttachments();
        label2 = attribute8.length;
        desc = 0;
        while (desc < label2) {
            Comment attachment = attribute8[desc];
            RepositoryAttachment taskAttachment = new RepositoryAttachment((AbstractAttributeFactory)attributeFactory);
            taskAttachment.setCreator(attachment.getAuthor());
            taskAttachment.setRepositoryKind("jira");
            taskAttachment.setRepositoryUrl(client.getBaseUrl());
            taskAttachment.setTaskId(jiraIssue.getKey());
            taskAttachment.setAttributeValue("task.common.attachment.id", attachment.getId());
            taskAttachment.setAttributeValue("filename", attachment.getName());
            if ("mylyn-context.zip".equals(attachment.getName())) {
                taskAttachment.setAttributeValue("task.common.description", "mylyn/context/zip");
            } else if ("mylar-context.zip".equals(attachment.getName())) {
                taskAttachment.setAttributeValue("task.common.description", "mylar/context/zip");
            } else {
                taskAttachment.setAttributeValue("task.common.description", attachment.getName());
            }
            taskAttachment.setAttributeValue("task.common.user.assigned", attachment.getAuthor());
            taskAttachment.setAttributeValue("task.common.attachment.size", String.valueOf(attachment.getSize()));
            taskAttachment.setAttributeValue("task.common.attachment.date", this.formatDate(attachment.getCreated()));
            taskAttachment.setAttributeValue("task.common.attachment.url", String.valueOf(client.getBaseUrl()) + "/secure/attachment/" + attachment.getId() + "/" + attachment.getName());
            data.addAttachment(taskAttachment);
            ++desc;
        }
        this.removeAttributes(data, "attribute.jira.custom::");
        attribute8 = jiraIssue.getCustomFields();
        label2 = attribute8.length;
        desc = 0;
        while (desc < label2) {
            Comment field = attribute8[desc];
            String mappedKey = attributeFactory.mapCommonAttributeKey(field.getId());
            name = String.valueOf(field.getName().replace("&", "&&")) + ":";
            RepositoryTaskAttribute attribute5 = new RepositoryTaskAttribute(mappedKey, (String)name, attributeFactory.isHidden(mappedKey));
            String type = field.getKey();
            attribute5.putMetaDataValue("type", type);
            attribute5.setReadOnly(field.isReadOnly());
            for (String value : field.getValues()) {
                attribute5.addValue(value);
            }
            data.addAttribute(attribute5.getId(), attribute5);
            ++desc;
        }
        this.updateMarkup(data, jiraIssue, client, oldTaskData);
        HashSet<String> editableKeys = new HashSet<String>();
        if (!jiraIssue.getStatus().isClosed()) {
            if (this.useCachedInformation(jiraIssue, oldTaskData)) {
                for (RepositoryTaskAttribute attribute6 : oldTaskData.getAttributes()) {
                    if (attribute6.isReadOnly()) continue;
                    editableKeys.add(attribute6.getId());
                }
                RepositoryTaskAttribute attribute7 = oldTaskData.getAttribute("attribute.jira.read-only");
                if (attribute7 != null) {
                    data.addAttribute("attribute.jira.read-only", attribute7);
                }
            } else {
                try {
                    RepositoryTaskAttribute[] editableAttributes = client.getEditableAttributes(jiraIssue.getKey());
                    if (editableAttributes != null) {
                        name = editableAttributes;
                        int mappedKey = editableAttributes.length;
                        int attribute8 = 0;
                        while (attribute8 < mappedKey) {
                            RepositoryTaskAttribute attribute9 = name[attribute8];
                            editableKeys.add(attributeFactory.mapCommonAttributeKey(attribute9.getId()));
                            ++attribute8;
                        }
                    }
                }
                catch (JiraInsufficientPermissionException jiraInsufficientPermissionException) {
                    RepositoryTaskAttribute attribute10 = new RepositoryTaskAttribute("attribute.jira.read-only", "Read-only", true);
                    data.addAttribute("attribute.jira.read-only", attribute10);
                }
            }
        }
        Iterator iterator = data.getAttributes().iterator();
        while (iterator.hasNext()) {
            RepositoryTaskAttribute attribute11;
            boolean editable = editableKeys.contains((attribute11 = (RepositoryTaskAttribute)iterator.next()).getId().toLowerCase());
            attribute11.setReadOnly(!editable);
            if (editable && (attribute11.getId().startsWith("attribute.jira.custom::") || !attributeFactory.isHidden(attribute11.getId()))) {
                attribute11.setHidden(false);
            }
            if ("task.common.comment.new".equals(attribute11.getId())) {
                attribute11.setReadOnly(false);
                continue;
            }
            String key = attribute11.getMetaDataValue("type");
            List options = attribute11.getOptions();
            if (JiraFieldType.SELECT.getKey().equals(key) && (options == null || options.isEmpty() || attribute11.isReadOnly())) {
                attribute11.setReadOnly(true);
                continue;
            }
            if (!JiraFieldType.MULTISELECT.getKey().equals(key) || options != null && !options.isEmpty()) continue;
            attribute11.setReadOnly(true);
        }
    }

    private boolean useCachedInformation(Issue issue, RepositoryTaskData oldTaskData) {
        return oldTaskData != null && oldTaskData.getStatus().equals(issue.getStatus().getName());
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", Locale.US).format(date);
    }

    private void removeAttributes(RepositoryTaskData data, String keyPrefix) {
        for (RepositoryTaskAttribute attribute : data.getAttributes()) {
            if (!attribute.getName().startsWith(keyPrefix)) continue;
            data.removeAttribute((Object)attribute.getId());
        }
    }

    private void removeAttributeValues(RepositoryTaskData data, String keyPrefix) {
        for (RepositoryTaskAttribute attribute : data.getAttributes()) {
            if (!attribute.getId().startsWith(keyPrefix)) continue;
            ListIterator it = attribute.getValues().listIterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
    }

    private String capitalize(String s) {
        char c;
        char uc;
        if (s.length() > 1 && (uc = Character.toUpperCase(c = s.charAt(0))) != c) {
            return String.valueOf(uc) + s.substring(1);
        }
        return s;
    }

    private RepositoryTaskAttribute createAuthorAttribute(String value) {
        RepositoryTaskAttribute attr = attributeFactory.createAttribute("task.common.comment.author");
        attr.setHidden(true);
        attr.setReadOnly(true);
        attr.setValue(value);
        return attr;
    }

    private String getAssignee(Issue jiraIssue) {
        String assignee = jiraIssue.getAssignee();
        return assignee == null || "-1".equals(assignee) ? "" : assignee;
    }

    public static String stripTags(String text) {
        int len;
        char[] chars;
        block4: {
            if (text == null || text.length() == 0) {
                return "";
            }
            StringReader stringReader = new StringReader(text);
            HTML2TextReader html2TextReader = new HTML2TextReader((Reader)stringReader);
            try {
                chars = new char[text.length()];
                len = html2TextReader.read(chars, 0, text.length());
                if (len != -1) break block4;
                return "";
            }
            catch (IOException iOException) {
                return text;
            }
        }
        return new String(chars, 0, len);
    }

    private void updateMarkup(RepositoryTaskData data, Issue jiraIssue, JiraClient client, RepositoryTaskData oldTaskData) throws JiraException {
        if (!jiraIssue.isMarkupDetected()) {
            return;
        }
        if (jiraIssue.getUpdated() != null && oldTaskData != null) {
            String value = oldTaskData.getAttributeValue("task.common.date.modified");
            if (jiraIssue.getUpdated().equals(JiraUtils.stringToDate(value))) {
                if (data.getAttribute("task.common.description") != null) {
                    data.setAttributeValue("task.common.description", oldTaskData.getAttributeValue("task.common.description"));
                }
                if (data.getAttribute("attribute.jira.environment") != null) {
                    data.setAttributeValue("attribute.jira.environment", oldTaskData.getAttributeValue("attribute.jira.environment"));
                }
                CustomField[] customFieldArray = jiraIssue.getCustomFields();
                int n = customFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RepositoryTaskAttribute oldAttribute;
                    CustomField field = customFieldArray[n2];
                    if (field.isMarkupDetected() && (oldAttribute = oldTaskData.getAttribute(field.getId())) != null) {
                        RepositoryTaskAttribute attribute = data.getAttribute(field.getId());
                        attribute.setValues(new ArrayList(oldAttribute.getValues()));
                    }
                    ++n2;
                }
                return;
            }
        }
        RemoteIssue remoteIssue = client.getRemoteIssueByKey(jiraIssue.getKey());
        if (data.getAttribute("task.common.description") != null) {
            if (remoteIssue.getDescription() == null) {
                data.setAttributeValue("task.common.description", "");
            } else {
                data.setAttributeValue("task.common.description", remoteIssue.getDescription());
            }
        }
        if (data.getAttribute("attribute.jira.environment") != null) {
            if (remoteIssue.getEnvironment() == null) {
                data.setAttributeValue("attribute.jira.environment", "");
            } else {
                data.setAttributeValue("attribute.jira.environment", remoteIssue.getEnvironment());
            }
        }
        RemoteCustomFieldValue[] fields = remoteIssue.getCustomFieldValues();
        CustomField[] customFieldArray = jiraIssue.getCustomFields();
        int n = customFieldArray.length;
        int n3 = 0;
        while (n3 < n) {
            CustomField field = customFieldArray[n3];
            if (field.isMarkupDetected()) {
                RemoteCustomFieldValue[] remoteCustomFieldValueArray = fields;
                int n4 = fields.length;
                int n5 = 0;
                while (n5 < n4) {
                    RemoteCustomFieldValue remoteField = remoteCustomFieldValueArray[n5];
                    if (field.getId().equals(remoteField.getCustomfieldId())) {
                        RepositoryTaskAttribute attribute = data.getAttribute(field.getId());
                        if (attribute == null) break;
                        attribute.setValues(Arrays.asList(remoteField.getValues()));
                        break;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
    }

    public void addOperations(RepositoryTaskData data, Issue issue, JiraClient client, RepositoryTaskData oldTaskData) throws JiraException {
        RepositoryOperation[] availableOperations;
        if (this.useCachedInformation(issue, oldTaskData)) {
            for (RepositoryOperation operation : oldTaskData.getOperations()) {
                data.addOperation(operation);
            }
            return;
        }
        Status status = issue.getStatus();
        RepositoryOperation leaveOperation = new RepositoryOperation(LEAVE_OPERATION, "Leave as " + issue.getStatus().getName());
        leaveOperation.setChecked(true);
        data.addOperation(leaveOperation);
        if (status.getId().equals("1") || status.getId().equals("3") || status.getId().equals("4")) {
            RepositoryOperation reassignOperation = new RepositoryOperation(REASSIGN_OPERATION, "Reassign to");
            reassignOperation.setInputName(JiraAttribute.USER_ASSIGNED.getParamName());
            reassignOperation.setInputValue(client.getUserName());
            data.addOperation(reassignOperation);
        }
        if ((availableOperations = client.getAvailableOperations(issue.getKey())) != null) {
            RepositoryOperation[] repositoryOperationArray = availableOperations;
            int n = availableOperations.length;
            int n2 = 0;
            while (n2 < n) {
                String[] fields;
                RepositoryOperation operation = repositoryOperationArray[n2];
                String[] stringArray = fields = client.getActionFields(issue.getKey(), operation.getKnobName());
                int n3 = fields.length;
                int n4 = 0;
                while (n4 < n3) {
                    String field = stringArray[n4];
                    if ("task.common.resolution".equals(attributeFactory.mapCommonAttributeKey(field))) {
                        operation.setInputName(field);
                        operation.setUpOptions(field);
                        this.addResolutions(client, operation);
                    }
                    ++n4;
                }
                data.addOperation(operation);
                ++n2;
            }
        }
    }

    private void addResolutions(JiraClient client, RepositoryOperation operation) {
        Resolution[] resolutions = client.getResolutions();
        if (resolutions.length > 0) {
            Resolution[] resolutionArray = resolutions;
            int n = resolutions.length;
            int n2 = 0;
            while (n2 < n) {
                Resolution resolution = resolutionArray[n2];
                operation.addOption(resolution.getName(), resolution.getId());
                if ("1".equals(resolution.getId())) {
                    operation.setOptionSelection(resolution.getName());
                }
                ++n2;
            }
        } else {
            operation.addOption("Fixed", "1");
            operation.addOption("Won't Fix", "2");
            operation.addOption("Duplicate", "3");
            operation.addOption("Incomplete", "4");
            operation.addOption("Cannot Reproduce", "5");
            operation.setOptionSelection("Fixed");
        }
    }

    public String postTaskData(TaskRepository repository, RepositoryTaskData taskData, IProgressMonitor monitor) throws CoreException {
        JiraClient client = this.clientFactory.getJiraClient(repository);
        if (client == null) {
            throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.mylyn.internal.jira.core", 4, "Unable to create Jira client", null));
        }
        try {
            String value;
            String inputName;
            if (!client.hasDetails()) {
                client.refreshDetails((IProgressMonitor)new NullProgressMonitor());
            }
            Issue issue = this.buildJiraIssue(taskData, client);
            if (taskData.isNew()) {
                if ((issue = issue.getType().isSubTaskType() && issue.getParentId() != null ? client.createSubTask(issue) : client.createIssue(issue)) == null) {
                    throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.mylyn.internal.jira.core", 0, "Could not create ticket.", null));
                }
                return issue.getKey();
            }
            RepositoryOperation operation = taskData.getSelectedOperation();
            if (operation == null) {
                operation = new RepositoryOperation(LEAVE_OPERATION, "");
            }
            if ((inputName = operation.getInputName()) != null && (value = operation.hasOptions() ? operation.getOptionValue(operation.getOptionSelection()) : operation.getInputValue()) != null) {
                issue.setValue(inputName, value);
            }
            if (LEAVE_OPERATION.equals(operation.getKnobName()) || REASSIGN_OPERATION.equals(operation.getKnobName())) {
                if (!issue.getStatus().isClosed() && taskData.getAttribute("attribute.jira.read-only") == null) {
                    client.updateIssue(issue, taskData.getNewComment());
                } else if (taskData.getNewComment() != null && taskData.getNewComment().length() > 0) {
                    client.addCommentToIssue(issue, taskData.getNewComment());
                }
            } else {
                client.advanceIssueWorkflow(issue, operation.getKnobName(), taskData.getNewComment());
            }
            return "";
        }
        catch (JiraException e) {
            IStatus status = JiraCorePlugin.toStatus((TaskRepository)repository, (Throwable)e);
            JiraTaskDataHandler.trace(status);
            throw new CoreException(status);
        }
    }

    public boolean initializeTaskData(TaskRepository repository, RepositoryTaskData data, IProgressMonitor monitor) throws CoreException {
        Project project;
        String projectName = data.getAttributeValue("task.common.product");
        if (projectName == null) {
            return false;
        }
        JiraClient client = this.clientFactory.getJiraClient(repository);
        if (!client.hasDetails()) {
            try {
                client.refreshDetails(monitor);
            }
            catch (JiraException ex) {
                IStatus status = JiraCorePlugin.toStatus((TaskRepository)repository, (Throwable)ex);
                JiraTaskDataHandler.trace(status);
                throw new CoreException(status);
            }
        }
        if ((project = this.getProject(client, projectName)) == null) {
            project = client.getProjectByKey(projectName);
        }
        if (project == null) {
            return false;
        }
        this.initializeTaskData(data, client, project);
        data.setAttributeValue("task.common.product", project.getName());
        return true;
    }

    public boolean initializeSubTaskData(TaskRepository repository, RepositoryTaskData taskData, RepositoryTaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        try {
            Project project;
            monitor.beginTask("Creating subtask", -1);
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
            if (!client.hasDetails()) {
                client.refreshDetails((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if ((project = this.getProject(client, parentTaskData.getProduct())) == null) {
                throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.mylyn.internal.jira.core", 0, "The parent task does not have a valid project.", null));
            }
            this.initializeTaskData(taskData, client, project);
            this.cloneTaskData(parentTaskData, taskData);
            taskData.setDescription("");
            taskData.setSummary("");
            taskData.setAttributeValue("task.common.user.assigned", parentTaskData.getAssignedTo());
            taskData.setAttributeValue("task.common.product", project.getName());
            RepositoryTaskAttribute typeAttribute = taskData.getAttribute("attribute.jira.type");
            typeAttribute.clearOptions();
            IssueType[] jiraIssueTypes = client.getIssueTypes();
            int i = 0;
            while (i < jiraIssueTypes.length) {
                IssueType type = jiraIssueTypes[i];
                if (type.isSubTaskType()) {
                    typeAttribute.addOption(type.getName(), type.getId());
                }
                ++i;
            }
            List options = typeAttribute.getOptions();
            if (options.size() == 0) {
                throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.mylyn.internal.jira.core", 0, "The repository does not support subtasks.", null));
            }
            if (options.size() == 1) {
                typeAttribute.setReadOnly(true);
            }
            typeAttribute.setValue((String)options.get(0));
            RepositoryTaskAttribute attribute = taskData.getAttribute("attribute.jira.issue_parent_id");
            attribute.setValue(parentTaskData.getId());
            attribute = taskData.getAttribute("attribute.jira.issue_parent_key");
            attribute.setValue(parentTaskData.getTaskKey());
            return true;
        }
        catch (JiraException e) {
            IStatus status = JiraCorePlugin.toStatus((TaskRepository)repository, (Throwable)e);
            JiraTaskDataHandler.trace(status);
            throw new CoreException(status);
        }
        finally {
            monitor.done();
        }
    }

    public boolean canInitializeSubTaskData(AbstractTask task, RepositoryTaskData parentTaskData) {
        return true;
    }

    private Project getProject(JiraClient client, String projectName) {
        Project[] projectArray = client.getProjects();
        int n = projectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Project project = projectArray[n2];
            if (project.getName().equals(projectName)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public AbstractAttributeFactory getAttributeFactory(String repositoryUrl, String repositoryKind, String taskKind) {
        return attributeFactory;
    }

    public AbstractAttributeFactory getAttributeFactory(RepositoryTaskData taskData) {
        return this.getAttributeFactory(taskData.getRepositoryUrl(), taskData.getRepositoryKind(), taskData.getTaskKind());
    }

    private Issue buildJiraIssue(RepositoryTaskData taskData, JiraClient client) {
        RepositoryTaskAttribute affectsVersionAttr;
        RepositoryTaskAttribute fixVersionAttr;
        Project project;
        String estimate;
        RepositoryTaskAttribute attribute;
        Issue issue = new Issue();
        issue.setId(taskData.getId());
        issue.setKey(taskData.getTaskKey());
        issue.setSummary(taskData.getAttributeValue("task.common.summary"));
        issue.setDescription(taskData.getAttributeValue("task.common.description"));
        issue.setDue(JiraUtils.stringToDate(taskData.getAttributeValue("attribute.jira.due")));
        String parentId = taskData.getAttributeValue("attribute.jira.issue_parent_id");
        if (parentId != null) {
            issue.setParentId(parentId);
        }
        if ((attribute = taskData.getAttribute("attribute.jira.security")) != null) {
            SecurityLevel securityLevel = new SecurityLevel();
            securityLevel.setId(attribute.getOptionParameter(attribute.getValue()));
            issue.setSecurityLevel(securityLevel);
        }
        if ((estimate = taskData.getAttributeValue("attribute.jira.estimate")) != null) {
            try {
                issue.setInitialEstimate(Long.parseLong(estimate) * 60L);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((project = this.getProject(client, taskData.getAttributeValue("task.common.product"))) != null) {
            issue.setProject(project);
        }
        Object object = client.getIssueTypes();
        int n = ((IssueType[])object).length;
        int n2 = 0;
        while (n2 < n) {
            IssueType type = object[n2];
            if (type.getName().equals(taskData.getAttributeValue("attribute.jira.type"))) {
                issue.setType(type);
                break;
            }
            ++n2;
        }
        object = client.getStatuses();
        n = ((Status[])object).length;
        n2 = 0;
        while (n2 < n) {
            IssueType status = object[n2];
            if (status.getName().equals(taskData.getAttributeValue("task.common.status"))) {
                issue.setStatus((Status)status);
                break;
            }
            ++n2;
        }
        RepositoryTaskAttribute componentsAttr = taskData.getAttribute("attribute.jira.components");
        if (componentsAttr != null) {
            ArrayList<Component> components = new ArrayList<Component>();
            for (String compStr : taskData.getAttributeValues("attribute.jira.components")) {
                if (componentsAttr.getOptionParameter(compStr) != null) {
                    Component comp = new Component();
                    comp.setId(componentsAttr.getOptionParameter(compStr));
                    comp.setName(compStr);
                    components.add(comp);
                    continue;
                }
                StatusHandler.log((IStatus)new org.eclipse.core.runtime.Status(2, "org.eclipse.mylyn.jira.ui", "Error setting component for JIRA issue. Component id is null: " + compStr));
            }
            issue.setComponents(components.toArray(new Component[components.size()]));
        }
        if ((fixVersionAttr = taskData.getAttribute("attribute.jira.fixversions")) != null) {
            ArrayList<Version> fixversions = new ArrayList<Version>();
            for (String fixStr : taskData.getAttributeValues("attribute.jira.fixversions")) {
                if (fixVersionAttr.getOptionParameter(fixStr) != null) {
                    Version version = new Version();
                    version.setId(fixVersionAttr.getOptionParameter(fixStr));
                    version.setName(fixStr);
                    fixversions.add(version);
                    continue;
                }
                StatusHandler.log((IStatus)new org.eclipse.core.runtime.Status(2, "org.eclipse.mylyn.jira.ui", "Error setting fix version for JIRA issue. Version id is null: " + fixStr));
            }
            issue.setFixVersions(fixversions.toArray(new Version[fixversions.size()]));
        }
        if ((affectsVersionAttr = taskData.getAttribute("attribute.jira.affectsversions")) != null) {
            ArrayList<Version> affectsversions = new ArrayList<Version>();
            for (String fixStr : taskData.getAttributeValues("attribute.jira.affectsversions")) {
                if (affectsVersionAttr.getOptionParameter(fixStr) != null) {
                    Version version = new Version();
                    version.setId(affectsVersionAttr.getOptionParameter(fixStr));
                    version.setName(fixStr);
                    affectsversions.add(version);
                    continue;
                }
                StatusHandler.log((IStatus)new org.eclipse.core.runtime.Status(2, "org.eclipse.mylyn.jira.ui", "Error setting affects version for JIRA issue. Version id is null: " + fixStr));
            }
            issue.setReportedVersions(affectsversions.toArray(new Version[affectsversions.size()]));
        }
        issue.setReporter(taskData.getAttributeValue("task.common.user.reporter"));
        RepositoryOperation operation = taskData.getSelectedOperation();
        String assignee = operation != null && REASSIGN_OPERATION.equals(operation.getKnobName()) ? operation.getInputValue() : taskData.getAttributeValue("task.common.user.assigned");
        issue.setAssignee(JiraRepositoryConnector.getAssigneeFromAttribute(assignee));
        issue.setEnvironment(taskData.getAttributeValue("attribute.jira.environment"));
        Priority[] priorityArray = client.getPriorities();
        int n3 = priorityArray.length;
        int version = 0;
        while (version < n3) {
            Priority priority = priorityArray[version];
            if (priority.getName().equals(taskData.getAttributeValue("task.common.priority"))) {
                issue.setPriority(priority);
                break;
            }
            ++version;
        }
        ArrayList<CustomField> customFields = new ArrayList<CustomField>();
        for (RepositoryTaskAttribute attr : taskData.getAttributes()) {
            if (!attr.getId().startsWith("attribute.jira.custom::")) continue;
            String id = attr.getId().substring("attribute.jira.custom::".length());
            CustomField field = new CustomField(id, attr.getMetaDataValue("type"), attr.getName(), attr.getValues());
            field.setReadOnly(attr.isReadOnly());
            customFields.add(field);
        }
        issue.setCustomFields(customFields.toArray(new CustomField[customFields.size()]));
        return issue;
    }

    public Set<String> getSubTaskIds(RepositoryTaskData taskData) {
        HashSet<String> subIds = new HashSet<String>();
        RepositoryTaskAttribute attribute = taskData.getAttribute(JiraAttribute.SUBTASK_IDS.getId());
        if (attribute != null) {
            subIds.addAll(attribute.getValues());
        }
        return subIds;
    }

    private static void trace(IStatus status) {
        if (TRACE_ENABLED) {
            JiraUiPlugin.getDefault().getLog().log(status);
        }
    }
}

