/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.ui.JiraCustomQuery;
import org.eclipse.mylyn.internal.jira.ui.JiraRepositoryQuery;
import org.eclipse.mylyn.internal.jira.ui.JiraTask;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskListFactory;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraTaskListFactory
extends AbstractTaskListFactory {
    private static final String KEY_JIRA = "Jira";
    private static final String KEY_CUSTOM = "JiraCustom";
    private static final String KEY_JIRA_QUERY = "JiraQuery";
    private static final String KEY_JIRA_CUSTOM = "JiraJiraCustomQuery";
    private static final String KEY_JIRA_ISSUE = "JiraIssue";
    private static final String KEY_FILTER_NAME = "FilterName";
    private static final String KEY_FILTER_ID = "FilterID";
    private static final String KEY_FILTER_CUSTOM = "FilterCustom";
    private static final String KEY_FILTER_CUSTOM_URL = "FilterCustomUrl";
    private static final String KEY_KEY = "Key";

    public String getTaskElementName() {
        return KEY_JIRA_ISSUE;
    }

    public Set<String> getQueryElementNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(KEY_JIRA_QUERY);
        names.add(KEY_JIRA_CUSTOM);
        return names;
    }

    public boolean canCreate(AbstractRepositoryQuery category) {
        return category instanceof JiraRepositoryQuery || category instanceof JiraCustomQuery;
    }

    public boolean canCreate(AbstractTask task) {
        return task instanceof JiraTask;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractRepositoryQuery createQuery(String repositoryUrl, String queryString, String label, Element element) {
        String custom = element.getAttribute(KEY_FILTER_CUSTOM);
        String customUrl = element.getAttribute(KEY_FILTER_CUSTOM_URL);
        if (custom != null && custom.length() > 0) {
            FilterDefinition filter = this.decodeFilter(custom);
            if (filter == null) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.jira.ui", "Failed to restore custom query " + element.getAttribute(KEY_FILTER_ID)));
                return null;
            }
            filter.setName(element.getAttribute(KEY_FILTER_ID));
            return new JiraCustomQuery(repositoryUrl, filter, TasksUiPlugin.getRepositoryManager().getRepository("jira", repositoryUrl).getCharacterEncoding());
        }
        if (customUrl != null && customUrl.length() > 0) {
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("jira", repositoryUrl);
            if (repository == null) return null;
            return new JiraCustomQuery(element.getAttribute(KEY_FILTER_ID), customUrl, repositoryUrl, repository.getCharacterEncoding());
        }
        NamedFilter namedFilter = new NamedFilter();
        namedFilter.setId(element.getAttribute(KEY_FILTER_ID));
        namedFilter.setName(element.getAttribute(KEY_FILTER_NAME));
        return new JiraRepositoryQuery(repositoryUrl, namedFilter);
    }

    public void setAdditionalAttributes(AbstractRepositoryQuery query, Element node) {
        if (query instanceof JiraRepositoryQuery) {
            NamedFilter filter = ((JiraRepositoryQuery)query).getNamedFilter();
            node.setAttribute(KEY_FILTER_ID, filter.getId());
            node.setAttribute(KEY_FILTER_NAME, filter.getName());
        } else if (query instanceof JiraCustomQuery) {
            JiraCustomQuery customQuery = (JiraCustomQuery)query;
            node.setAttribute(KEY_FILTER_ID, customQuery.getSummary());
            node.setAttribute(KEY_FILTER_NAME, customQuery.getSummary());
            node.setAttribute(KEY_FILTER_CUSTOM_URL, customQuery.getUrl());
        }
    }

    private FilterDefinition decodeFilter(String filter) {
        byte[] buff = new byte[filter.length() / 2];
        char[] chars = filter.toCharArray();
        int i = 0;
        int k = 0;
        while (i < chars.length) {
            buff[k] = (byte)((chars[i] - 65 << 4 | chars[i + 1] - 65) & 0xFF);
            i += 2;
            ++k;
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buff));
            return (FilterDefinition)ois.readObject();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setAdditionalAttributes(AbstractTask task, Element element) {
        element.setAttribute(KEY_KEY, ((JiraTask)task).getTaskKey());
    }

    public AbstractTask createTask(String repositoryUrl, String taskId, String summary, Element element) {
        JiraTask task = new JiraTask(repositoryUrl, taskId, summary);
        if (element.hasAttribute(KEY_KEY)) {
            String key = element.getAttribute(KEY_KEY);
            task.setTaskKey(key);
        }
        return task;
    }

    public String getQueryElementName(AbstractRepositoryQuery query) {
        if (query instanceof JiraRepositoryQuery) {
            return KEY_JIRA_QUERY;
        }
        if (query instanceof JiraCustomQuery) {
            return KEY_JIRA_CUSTOM;
        }
        return "";
    }
}

