/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.jira.ui.JiraUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class JiraUtils {
    private static final boolean TRACE_ENABLED = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.mylyn.internal.jira.ui/general"));
    private static final String REPOSITORY_UPDATE_TIME_STAMP = "jira.lastIssueUpdate";
    private static final String CHARACTER_ENCODING_VALIDATED = "jira.characterEncodingValidated";
    private static final String COMPRESSION_KEY = "compression";
    private static final String REFRESH_CONFIGURATION_KEY = "refreshConfiguration";

    public static void setLastUpdate(TaskRepository repository, Date date) {
        repository.setProperty(REPOSITORY_UPDATE_TIME_STAMP, JiraUtils.dateToString(date));
    }

    public static Date getLastUpdate(TaskRepository repository) {
        return JiraUtils.stringToDate(repository.getProperty(REPOSITORY_UPDATE_TIME_STAMP));
    }

    public static void setCompression(TaskRepository taskRepository, boolean compression) {
        taskRepository.setProperty(COMPRESSION_KEY, String.valueOf(compression));
    }

    public static boolean getCompression(TaskRepository taskRepository) {
        return Boolean.parseBoolean(taskRepository.getProperty(COMPRESSION_KEY));
    }

    public static void setCharacterEncodingValidated(TaskRepository taskRepository, boolean validated) {
        taskRepository.setProperty(CHARACTER_ENCODING_VALIDATED, String.valueOf(validated));
    }

    public static boolean getCharacterEncodingValidated(TaskRepository taskRepository) {
        return Boolean.parseBoolean(taskRepository.getProperty(CHARACTER_ENCODING_VALIDATED));
    }

    public static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        return String.valueOf(date.getTime());
    }

    public static Date stringToDate(String dateString) {
        if (dateString == null || dateString.length() == 0) {
            return null;
        }
        try {
            return new Date(Long.parseLong(dateString));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", Locale.US).parse(dateString);
            }
            catch (ParseException e) {
                JiraUtils.trace((IStatus)new Status(2, "org.eclipse.mylyn.jira.ui", 0, "Error while parsing date string " + dateString, (Throwable)e));
                return null;
            }
        }
    }

    public static void trace(IStatus status) {
        if (TRACE_ENABLED) {
            JiraUiPlugin.getDefault().getLog().log(status);
        }
    }

    public static boolean getAutoRefreshConfiguration(TaskRepository repository) {
        return Boolean.parseBoolean(repository.getProperty(REFRESH_CONFIGURATION_KEY));
    }

    public static void setAutoRefreshConfiguration(TaskRepository repository, boolean autoRefreshConfiguration) {
        repository.setProperty(REFRESH_CONFIGURATION_KEY, String.valueOf(autoRefreshConfiguration));
    }
}

