/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.editor;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mylyn.internal.jira.ui.JiraFieldType;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class JiraTaskEditor
extends AbstractRepositoryTaskEditor {
    public JiraTaskEditor(FormEditor editor) {
        super(editor);
    }

    protected void addSelfToCC(Composite composite) {
    }

    protected void addCCList(Composite attributesComposite) {
    }

    protected void createAttributeLayout(Composite attributesComposite) {
    }

    protected void addRadioButtons(Composite buttonComposite) {
        super.addRadioButtons(buttonComposite);
    }

    protected void addActionButtons(Composite buttonComposite) {
        super.addActionButtons(buttonComposite);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
    }

    protected void createCustomAttributeLayout(Composite attributesComposite) {
        Label label;
        GridData data;
        int numColumns = ((GridLayout)attributesComposite.getLayout()).numColumns;
        int currentCol = 1;
        for (final RepositoryTaskAttribute attribute : this.taskData.getAttributes()) {
            if (attribute.isHidden() || attribute.isReadOnly() && (attribute.getValue() == null || attribute.getValue().length() == 0)) continue;
            JiraFieldType type = JiraFieldType.valueByKey(attribute.getMetaDataValue("type"));
            List options = attribute.getOptions();
            if (type.equals((Object)JiraFieldType.SELECT) && (options == null || options.isEmpty() || attribute.isReadOnly())) {
                type = JiraFieldType.TEXTFIELD;
            } else if (type.equals((Object)JiraFieldType.MULTISELECT) && (options == null || options.isEmpty())) {
                type = JiraFieldType.TEXTFIELD;
            }
            switch (type) {
                case TEXTAREA: 
                case ISSUELINKS: {
                    break;
                }
                case SELECT: {
                    String value;
                    Label label2 = this.createLabel(attributesComposite, attribute);
                    GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)label2);
                    final CCombo combo = new CCombo(attributesComposite, 0x800008);
                    this.getManagedForm().getToolkit().adapt((Control)combo, true, true);
                    combo.setFont(TEXT_FONT);
                    combo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                    data = new GridData(16384, 128, false, false);
                    data.horizontalSpan = 1;
                    data.widthHint = 140;
                    combo.setLayoutData((Object)data);
                    if (attribute.getOptions() != null) {
                        for (String val : attribute.getOptions()) {
                            combo.add(val);
                        }
                    }
                    if ((value = attribute.getValue()) == null) {
                        value = "";
                    }
                    if (combo.indexOf(value) != -1) {
                        combo.select(combo.indexOf(value));
                    }
                    combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            if (combo.getSelectionIndex() > -1) {
                                String sel = combo.getItem(combo.getSelectionIndex());
                                attribute.setValue(sel);
                                JiraTaskEditor.this.attributeChanged(attribute);
                            }
                        }
                    });
                    if (this.hasChanged(attribute)) {
                        combo.setBackground(this.getColorIncoming());
                    }
                    currentCol += 2;
                    break;
                }
                case MULTISELECT: {
                    Label label2 = this.createLabel(attributesComposite, attribute);
                    GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)label2);
                    final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(attributesComposite, 0x800202);
                    this.getManagedForm().getToolkit().adapt((Control)list, true, true);
                    list.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                    list.setFont(TEXT_FONT);
                    data = new GridData(16384, 128, false, false);
                    data.horizontalSpan = 1;
                    data.widthHint = 125;
                    data.heightHint = 45;
                    list.setLayoutData((Object)data);
                    if (!attribute.getOptions().isEmpty()) {
                        list.setItems(attribute.getOptions().toArray(new String[1]));
                        for (String value : attribute.getValues()) {
                            list.select(list.indexOf(value));
                        }
                        final RepositoryTaskAttribute attr = attribute;
                        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                attr.clearValues();
                                attr.setValues(Arrays.asList(list.getSelection()));
                                JiraTaskEditor.this.attributeChanged(attr);
                            }
                        });
                        list.showSelection();
                    }
                    if (this.hasChanged(attribute)) {
                        list.setBackground(this.getColorIncoming());
                    }
                    currentCol += 2;
                    break;
                }
                case ISSUELINK: {
                    Label label2 = this.createLabel(attributesComposite, attribute);
                    GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)label2);
                    TextViewer viewer = this.addTextViewer(this.repository, attributesComposite, attribute.getValue(), 0x800008);
                    StyledText text = viewer.getTextWidget();
                    GridData data2 = new GridData(16384, 128, false, false);
                    data2.horizontalSpan = 1;
                    data2.widthHint = 135;
                    text.setLayoutData((Object)data2);
                    if (this.hasChanged(attribute)) {
                        text.setBackground(this.getColorIncoming());
                    }
                    currentCol += 2;
                    break;
                }
                default: {
                    Label label2 = this.createLabel(attributesComposite, attribute);
                    GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)label2);
                    int style = attribute.isReadOnly() ? 8 : 0;
                    StyledText text = this.createTextField(attributesComposite, attribute, 0x800000 | style);
                    GridData data2 = new GridData(16384, 128, false, false);
                    data2.horizontalSpan = 1;
                    data2.widthHint = 135;
                    text.setLayoutData((Object)data2);
                    if (this.hasContentAssist(attribute)) {
                        ContentAssistCommandAdapter adapter = this.applyContentAssist((Text)text, this.createContentProposalProvider(attribute));
                        ILabelProvider propsalLabelProvider = this.createProposalLabelProvider(attribute);
                        if (propsalLabelProvider != null) {
                            adapter.setLabelProvider(propsalLabelProvider);
                        }
                        adapter.setProposalAcceptanceStyle(2);
                    }
                    if (this.hasChanged(attribute)) {
                        text.setBackground(this.getColorIncoming());
                    }
                    currentCol += 2;
                }
            }
            if (currentCol <= numColumns) continue;
            currentCol -= numColumns;
        }
        if (currentCol > 1) {
            while (currentCol <= numColumns) {
                this.getManagedForm().getToolkit().createLabel(attributesComposite, "");
                ++currentCol;
            }
        }
        for (final RepositoryTaskAttribute attribute : this.taskData.getAttributes()) {
            if (attribute.isHidden() || !JiraFieldType.ISSUELINKS.getKey().equals(attribute.getMetaDataValue("type"))) continue;
            label = this.createLabel(attributesComposite, attribute);
            GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)label);
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (String key : attribute.getValues()) {
                sb.append(sep).append(key);
                sep = ", ";
            }
            TextViewer viewer = this.addTextViewer(this.repository, attributesComposite, sb.toString(), 8388682);
            data = new GridData(4, 128, true, false, 3, 1);
            data.horizontalSpan = 3;
            data.widthHint = 380;
            StyledText text = viewer.getTextWidget();
            text.setLayoutData((Object)data);
            this.getManagedForm().getToolkit().adapt((Control)text, true, true);
            if (!this.hasChanged(attribute)) continue;
            text.setBackground(this.getColorIncoming());
        }
        for (final RepositoryTaskAttribute attribute : this.taskData.getAttributes()) {
            if (attribute.isHidden() || !JiraFieldType.TEXTAREA.getKey().equals(attribute.getMetaDataValue("type")) || attribute.isReadOnly() && (attribute.getValue() == null || attribute.getValue().length() == 0)) continue;
            label = this.createLabel(attributesComposite, attribute);
            GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)label);
            int style = attribute.isReadOnly() ? 8 : 0;
            TextViewer viewer = new TextViewer(attributesComposite, 0x800242 | style);
            viewer.setDocument((IDocument)new Document(attribute.getValue()));
            final StyledText text = viewer.getTextWidget();
            data = new GridData(4, 128, true, false);
            data.horizontalSpan = 3;
            data.widthHint = 380;
            data.heightHint = 55;
            text.setLayoutData((Object)data);
            this.getManagedForm().getToolkit().adapt((Control)text, true, true);
            if (attribute.isReadOnly()) {
                viewer.setEditable(false);
            } else {
                viewer.setEditable(true);
                text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                text.setData((Object)attribute);
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String newValue = text.getText();
                        RepositoryTaskAttribute attribute = (RepositoryTaskAttribute)text.getData();
                        attribute.setValue(newValue);
                        JiraTaskEditor.this.attributeChanged(attribute);
                    }
                });
            }
            if (!this.hasChanged(attribute)) continue;
            text.setBackground(this.getColorIncoming());
        }
        this.getManagedForm().getToolkit().paintBordersFor(attributesComposite);
    }

    protected void validateInput() {
    }

    protected String getHistoryUrl() {
        if (this.taskData != null) {
            String url;
            String taskId = this.taskData.getTaskKey();
            String repositoryUrl = this.taskData.getRepositoryUrl();
            if (this.getConnector() != null && repositoryUrl != null && taskId != null && (url = this.getConnector().getTaskUrl(repositoryUrl, taskId)) != null) {
                return String.valueOf(url) + "?page=history";
            }
        }
        return super.getHistoryUrl();
    }

    protected boolean hasContentAssist(RepositoryTaskAttribute attribute) {
        String key = attribute.getMetaDataValue("type");
        if (JiraFieldType.USERPICKER.getKey().equals(key)) {
            return true;
        }
        return super.hasContentAssist(attribute);
    }

    protected boolean hasContentAssist(RepositoryOperation repositoryOperation) {
        if ("assignee".equals(repositoryOperation.getInputName())) {
            return true;
        }
        return super.hasContentAssist(repositoryOperation);
    }
}

