/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.editor;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeEditorToolkit;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeManager;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class JiraTaskEditor2
extends AbstractTaskEditorPage {
    private AttributeEditorFactory attributeEditorFactory;
    private AttributeEditorToolkit attributeEditorToolkit;

    public JiraTaskEditor2(FormEditor editor) {
        super(editor);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.attributeEditorFactory = new AttributeEditorFactory(this.getAttributeManager());
        this.attributeEditorToolkit = new AttributeEditorToolkit(){

            public void adapt(AbstractAttributeEditor editor) {
                super.adapt(editor);
                if (JiraTaskEditor2.this.getAttributeManager().hasIncomingChanges(editor.getTaskAttribute())) {
                    editor.decorate(JiraTaskEditor2.this.getColorIncoming());
                }
            }

            public void configureContextMenuManager(MenuManager menuManager, TextViewer textViewer) {
                JiraTaskEditor2.this.getParentEditor().configureContextMenuManager(menuManager, textViewer);
            }
        };
        super.createFormContent(managedForm);
    }

    protected AttributeEditorFactory getAttributeEditorFactory() {
        return this.attributeEditorFactory;
    }

    public AttributeEditorToolkit getAttributeEditorToolkit() {
        return this.attributeEditorToolkit;
    }

    protected String getHistoryUrl() {
        String url;
        RepositoryTaskData taskData = this.getAttributeManager().getTaskData();
        String taskKey = taskData.getTaskKey();
        String repositoryUrl = taskData.getRepositoryUrl();
        if (this.getConnector() != null && repositoryUrl != null && taskKey != null && (url = this.getConnector().getTaskUrl(repositoryUrl, taskKey)) != null) {
            return String.valueOf(url) + "?page=history";
        }
        return super.getHistoryUrl();
    }

    protected AttributeManager createAttributeManager(TaskRepository taskRepository, String storageUrl, String storageId) {
        return new AttributeManager(taskRepository, storageUrl, storageId);
    }
}

