/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.model.filter.ProjectFilter;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.ui.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.ui.JiraCustomQuery;
import org.eclipse.mylyn.internal.jira.ui.JiraTask;
import org.eclipse.mylyn.internal.tasks.core.TaskDataManager;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraProjectPage
extends WizardPage {
    private static final String DESCRIPTION = "Pick a project to open the new bug editor.\nPress the Update button if the project is not in the list.";
    private static final String LABEL_UPDATE = "Update Projects from Repository";
    private FilteredTree projectTree;
    private final TaskRepository repository;

    public JiraProjectPage(TaskRepository repository) {
        super("jiraProject");
        this.setTitle("New JIRA Task");
        this.setDescription(DESCRIPTION);
        this.repository = repository;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.projectTree = new FilteredTree(composite, 2052, new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                Project project;
                if (element instanceof Project && this.wordMatches((project = (Project)element).getKey())) {
                    return true;
                }
                return super.isLeafMatch(viewer, element);
            }
        });
        this.projectTree.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(-1, 200).create());
        TreeViewer projectTreeViewer = this.projectTree.getViewer();
        projectTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Project) {
                    Project project = (Project)element;
                    return String.valueOf(project.getName()) + "  (" + project.getKey() + ")";
                }
                return "";
            }
        });
        projectTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Project[]) {
                    return (Project[])parentElement;
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.updateProjectsFromRepository(false);
        final Project project = this.discoverProject();
        if (project != null) {
            new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    TreeViewer viewer = JiraProjectPage.this.projectTree.getViewer();
                    if (viewer != null && viewer.getTree() != null && !viewer.getTree().isDisposed()) {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)project));
                        viewer.reveal((Object)project);
                        viewer.getTree().showSelection();
                        viewer.getTree().setFocus();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule(300L);
        }
        projectTreeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (JiraProjectPage.this.getSelectedProject() == null) {
                    JiraProjectPage.this.setErrorMessage("You must select a project");
                } else {
                    JiraProjectPage.this.setErrorMessage(null);
                }
                JiraProjectPage.this.getWizard().getContainer().updateButtons();
            }
        });
        projectTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (JiraProjectPage.this.getWizard().canFinish() && JiraProjectPage.this.getWizard().performFinish()) {
                    ((WizardDialog)JiraProjectPage.this.getContainer()).close();
                }
            }
        });
        Button updateButton = new Button(composite, 16392);
        updateButton.setText(LABEL_UPDATE);
        updateButton.setLayoutData((Object)new GridData());
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JiraProjectPage.this.updateProjectsFromRepository(true);
            }
        });
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        return this.getSelectedProject() != null;
    }

    private void updateProjectsFromRepository(boolean force) {
        JiraClient client = JiraClientFactory.getDefault().getJiraClient(this.repository);
        if (!client.hasDetails() || force) {
            try {
                IRunnableWithProgress runner = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                JiraClient client = JiraClientFactory.getDefault().getJiraClient(JiraProjectPage.this.repository);
                                client.refreshDetails(monitor);
                            }
                            catch (JiraException e) {
                                throw new InvocationTargetException(new CoreException(JiraCorePlugin.toStatus((TaskRepository)JiraProjectPage.this.repository, (Throwable)e)));
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                throw new InterruptedException();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                if (this.getContainer().getShell().isVisible()) {
                    this.getContainer().run(true, true, runner);
                } else {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runner);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    this.setErrorMessage(((CoreException)e.getCause()).getMessage());
                } else {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.jira.ui", "Error updating attributes", (Throwable)e));
                }
                return;
            }
        }
        Project[] projects = client.getProjects();
        this.projectTree.getViewer().setInput((Object)projects);
        this.getWizard().getContainer().updateButtons();
        if (projects.length == 1 && this.projectTree.getViewer().getSelection().isEmpty()) {
            this.projectTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)projects[0]));
        } else {
            this.projectTree.setFocus();
        }
    }

    public Project getSelectedProject() {
        IStructuredSelection selection = (IStructuredSelection)this.projectTree.getViewer().getSelection();
        return (Project)selection.getFirstElement();
    }

    private Project discoverProject() {
        Project project;
        TaskSelection taskSelection;
        ProjectFilter projectFilter;
        JiraClient client;
        FilterDefinition filter;
        JiraCustomQuery query;
        TaskDataManager taskDataManager;
        Project project2;
        JiraTask jiraTask;
        Object element;
        IStructuredSelection selection = this.getSelection();
        if (selection != null) {
            element = selection.getFirstElement();
        } else {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return null;
            }
            IEditorPart editor = page.getActiveEditor();
            if (editor == null) {
                return null;
            }
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof TaskEditorInput) {
                element = ((TaskEditorInput)editorInput).getTask();
            } else if (editorInput instanceof AbstractRepositoryTaskEditorInput) {
                element = ((AbstractRepositoryTaskEditorInput)editorInput).getOldTaskData();
            } else {
                return null;
            }
        }
        if (element == null) {
            return null;
        }
        if (element instanceof JiraTask && (jiraTask = (JiraTask)((Object)element)).getRepositoryUrl().equals(this.repository.getUrl()) && (project2 = this.getProject((taskDataManager = TasksUiPlugin.getTaskDataManager()).getNewTaskData(this.repository.getUrl(), jiraTask.getTaskId()))) != null) {
            return project2;
        }
        if (element instanceof JiraCustomQuery && (query = (JiraCustomQuery)((Object)element)).getRepositoryUrl().equals(this.repository.getUrl()) && (filter = query.getFilterDefinition(client = JiraClientFactory.getDefault().getJiraClient(this.repository), false)) != null && (projectFilter = filter.getProjectFilter()) != null) {
            return projectFilter.getProject();
        }
        RepositoryTaskData taskData = null;
        if (element instanceof RepositoryTaskData) {
            taskData = (RepositoryTaskData)JiraProjectPage.getAdapter(element, RepositoryTaskData.class);
        }
        if (taskData == null && (taskSelection = (TaskSelection)JiraProjectPage.getAdapter(element, TaskSelection.class)) != null) {
            taskData = taskSelection.getTaskData();
        }
        if (taskData != null && taskData.getRepositoryUrl().equals(this.repository.getUrl()) && (project = this.getProject(taskData)) != null) {
            return project;
        }
        return null;
    }

    private Project getProject(RepositoryTaskData taskData) {
        String projectName;
        if (taskData != null && (projectName = taskData.getProduct()) != null && projectName.length() > 0) {
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(this.repository);
            Project[] projectArray = client.getProjects();
            int n = projectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Project project = projectArray[n2];
                if (projectName.equals(project.getName())) {
                    return project;
                }
                ++n2;
            }
            return client.getProjectByKey(projectName);
        }
        return null;
    }

    private static Object getAdapter(Object adaptable, Class<?> adapterType) {
        Object adapter;
        if (adaptable.getClass().isAssignableFrom(adapterType)) {
            return adaptable;
        }
        if (adaptable instanceof IAdaptable && (adapter = ((IAdaptable)adaptable).getAdapter(adapterType)) != null) {
            return adapter;
        }
        return Platform.getAdapterManager().getAdapter(adaptable, adapterType);
    }

    private IStructuredSelection getSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }
}

