/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.dev.views;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class RepositorySpyView
extends ViewPart {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action refreshViewAction;
    private Action clearConfigLastUpdateAction;
    private Action doubleClickAction;

    private KeyValuePair[] MaptoArray(TaskRepository repository) {
        Map map = repository.getProperties();
        KeyValuePair[] results = new KeyValuePair[map.size()];
        int i = 0;
        for (Object key : map.keySet()) {
            results[i++] = new KeyValuePair(key, map.get(key), repository);
        }
        return results;
    }

    public void refresh() {
        this.viewer.getContentProvider().inputChanged((Viewer)this.viewer, null, null);
        this.viewer.refresh();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RepositorySpyView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.refreshViewAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.clearConfigLastUpdateAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshViewAction);
        manager.add((IAction)this.clearConfigLastUpdateAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshViewAction);
        manager.add((IAction)this.clearConfigLastUpdateAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.refreshViewAction = new RefreshAction(this);
        this.refreshViewAction.setText("Refresh");
        this.refreshViewAction.setToolTipText("Rebuild Repository List");
        this.refreshViewAction.setImageDescriptor(TasksUiImages.REFRESH);
        this.clearConfigLastUpdateAction = new Action(){

            public void run() {
                ISelection selection = RepositorySpyView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && obj instanceof KeyValuePair) {
                    if (RepositorySpyView.this.askDeleteMessage((KeyValuePair)obj)) {
                        KeyValuePair kvp = (KeyValuePair)obj;
                        ((TaskRepository)kvp.getParent()).removeProperty((String)kvp.getKey());
                        TasksUiPlugin.getRepositoryManager().saveRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
                        RepositorySpyView.this.viewer.refresh();
                    }
                } else if (obj == null) {
                    List repositories = TasksUiPlugin.getRepositoryManager().getAllRepositories();
                    for (TaskRepository repository : repositories) {
                        repository.removeProperty("config.lastupdate");
                        TasksUiPlugin.getRepositoryManager().saveRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
                        RepositorySpyView.this.viewer.refresh();
                    }
                    RepositorySpyView.this.showMessage("Removed config.lastupdate property");
                }
            }
        };
        this.clearConfigLastUpdateAction.setText("Clear Config Update");
        this.clearConfigLastUpdateAction.setToolTipText("Forget last config update date");
        this.clearConfigLastUpdateAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = RepositorySpyView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof KeyValuePair && RepositorySpyView.this.askDeleteMessage((KeyValuePair)obj)) {
                    KeyValuePair kvp = (KeyValuePair)obj;
                    ((TaskRepository)kvp.getParent()).removeProperty((String)kvp.getKey());
                    TasksUiPlugin.getRepositoryManager().saveRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
                    RepositorySpyView.this.viewer.refresh();
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RepositorySpyView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Repository Spy View", (String)message);
    }

    private boolean askDeleteMessage(KeyValuePair obj) {
        return MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)"Repository Spy View", (String)("Do you want to clear property '" + obj.getKey().toString() + "' from '" + obj.getParent().toString() + "'"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class KeyValuePair {
        Object key;
        Object value;
        Object parent;

        public KeyValuePair(Object key, Object value, Object parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        public String toString() {
            return String.valueOf(this.key.toString()) + " : " + this.value.toString();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getParent() {
            return this.parent;
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class RefreshAction
    extends Action {
        RepositorySpyView view = null;

        public RefreshAction(RepositorySpyView repositorySpyView2) {
            this.view = repositorySpyView2;
        }

        public void run() {
            RepositorySpyView.this.viewer.getContentProvider().inputChanged((Viewer)RepositorySpyView.this.viewer, null, null);
            this.view.refresh();
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        List<TaskRepository> repositories = null;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput instanceof List || newInput == null) {
                this.repositories = (List)newInput;
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(RepositorySpyView.this.getViewSite())) {
                if (this.repositories == null) {
                    this.initialize();
                }
                return this.getChildren(this.repositories);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof List) {
                return this.repositories.toArray();
            }
            if (parent instanceof TaskRepository) {
                TaskRepository repository = (TaskRepository)parent;
                Object[] result = RepositorySpyView.this.MaptoArray(repository);
                return result;
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof List) {
                return this.repositories.size() > 0;
            }
            if (parent instanceof TaskRepository) {
                TaskRepository repository = (TaskRepository)parent;
                return repository.getProperties().size() > 0;
            }
            return false;
        }

        private void initialize() {
            if (this.repositories == null) {
                this.repositories = TasksUiPlugin.getRepositoryManager().getAllRepositories();
            }
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof List) {
                return "Repositories";
            }
            if (obj instanceof TaskRepository) {
                TaskRepository repository = (TaskRepository)obj;
                return repository.getRepositoryLabel();
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof List) {
                return TasksUiImages.REPOSITORIES.createImage();
            }
            if (obj instanceof TaskRepository) {
                return TasksUiImages.REPOSITORY.createImage();
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

