/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.StackTrace;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaReportInfo {
    private static final int MAX_LABEL_LENGTH = 150;
    private static final long serialVersionUID = 3257004367222419506L;
    private BugzillaTask hit;
    private boolean isExact = false;
    private List<StackTrace> stackTraces;
    private RepositoryTaskData bug;

    public BugzillaReportInfo(float initialValue, BugzillaTask hit, boolean isExact) {
        this.hit = hit;
        this.isExact = isExact;
        this.bug = null;
        this.stackTraces = new ArrayList<StackTrace>();
    }

    public BugzillaTask getHit() {
        return this.hit;
    }

    public String toString() {
        return this.hit.toString();
    }

    public boolean isExact() {
        return this.isExact;
    }

    public void setExact(boolean isExact) {
        this.isExact = isExact;
    }

    public RepositoryTaskData getBug() throws CoreException {
        if (this.bug == null) {
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("bugzilla", this.hit.getRepositoryUrl());
            BugzillaRepositoryConnector bugzillaConnector = (BugzillaRepositoryConnector)TasksUiPlugin.getRepositoryManager().getRepositoryConnector("bugzilla");
            AbstractTaskDataHandler handler = bugzillaConnector.getTaskDataHandler();
            this.bug = handler.getTaskData(repository, this.hit.getTaskId(), (IProgressMonitor)new NullProgressMonitor());
        }
        return this.bug;
    }

    public void setBug(RepositoryTaskData bug) {
        this.bug = bug;
    }

    public List<StackTrace> getStackTraces() {
        return this.stackTraces;
    }

    public boolean hasStackTraces() {
        return !this.stackTraces.isEmpty();
    }

    public void addStackTrace(StackTrace stackTrace) {
        this.stackTraces.add(stackTrace);
    }

    public void addStackTraces(StackTrace[] stackTracesToAdd) {
        int i = 0;
        while (i < stackTracesToAdd.length) {
            this.stackTraces.add(stackTracesToAdd[i]);
            ++i;
        }
    }

    public String getName() {
        String description = this.hit.getSummary();
        int length = description.length();
        if (length > 150) {
            description = String.valueOf(description.substring(0, 150)) + "..";
        }
        return "bug " + this.hit.getTaskId() + ": " + description;
    }

    public String getElementHandle() {
        return String.valueOf(this.hit.getRepositoryUrl()) + ";" + this.hit.getTaskId();
    }
}

