/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaContextLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskOutlinePage;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaUiBridge
extends AbstractContextUiBridge {
    protected BugzillaContextLabelProvider labelProvider = new BugzillaContextLabelProvider();

    public void open(IInteractionElement node) {
        int bugId;
        String handle;
        String bugHandle = handle = node.getHandleIdentifier();
        String server = handle.substring(0, handle.indexOf(";"));
        int next = (handle = handle.substring(handle.indexOf(";") + 1)).indexOf(";");
        if (next == -1) {
            bugId = Integer.parseInt(handle);
        } else {
            bugId = Integer.parseInt(handle.substring(0, handle.indexOf(";")));
            bugHandle = bugHandle.substring(0, next);
        }
        AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(handle);
        if (task != null) {
            TasksUiUtil.openEditor((AbstractTask)task, (boolean)false);
        } else {
            String bugUrl = BugzillaClient.getBugUrlWithoutLogin((String)server, (String)("" + bugId));
            TasksUiUtil.openRepositoryTask((String)server, (String)("" + bugId), (String)bugUrl);
        }
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void close(IInteractionElement node) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            IEditorReference[] references = page.getEditorReferences();
            int i = 0;
            while (i < references.length) {
                IEditorPart part = references[i].getEditor(false);
                if (part != null) {
                    if (part instanceof AbstractRepositoryTaskEditor) {
                        ((AbstractRepositoryTaskEditor)part).close();
                    } else if (part instanceof TaskEditor) {
                        ((TaskEditor)part).close(true);
                    }
                }
                ++i;
            }
        }
    }

    public boolean acceptsEditor(IEditorPart editorPart) {
        return editorPart instanceof AbstractRepositoryTaskEditor;
    }

    public List<TreeViewer> getContentOutlineViewers(IEditorPart editor) {
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        TreeViewer outline = this.getOutlineTreeViewer(editor);
        if (outline != null) {
            viewers.add(outline);
        }
        return viewers;
    }

    protected TreeViewer getOutlineTreeViewer(IEditorPart editor) {
        AbstractRepositoryTaskEditor abe;
        RepositoryTaskOutlinePage outline;
        if (editor instanceof AbstractRepositoryTaskEditor && (outline = (abe = (AbstractRepositoryTaskEditor)editor).getOutline()) != null) {
            return outline.getOutlineTreeViewer();
        }
        return null;
    }

    public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
        return null;
    }

    public void restoreEditor(IInteractionElement document) {
    }

    public IInteractionElement getElement(IEditorInput input) {
        return null;
    }

    public String getContentType() {
        return "bugzilla";
    }
}

