/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.actions;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.sandbox.ui.SandboxUiPlugin;
import org.eclipse.mylyn.internal.sandbox.ui.actions.ContextCapturePauseAction;
import org.eclipse.mylyn.internal.tasks.ui.ComboSelectionDialog;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class SwitchTaskDataFolderAction
extends Action
implements IViewActionDelegate {
    protected static final String TITLE = "Switch Task Data Folder";
    protected static final String PROMPT = "Select the folder to switch to:";
    protected static final String MAIN_LOCAL_DATA_DIR = "Main Task Data Folder";
    protected Shell shell = null;

    public void init(IViewPart view) {
        this.shell = view.getViewSite().getShell();
    }

    public void run(IAction action) {
        String[] folderStrings = this.getFolderStrings();
        String targetFolder = null;
        if (folderStrings != null) {
            targetFolder = this.showComboSelectionDialog(folderStrings);
        }
        if (targetFolder != null && !targetFolder.trim().equals("")) {
            this.switchTaskDataFolder(targetFolder);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected String showComboSelectionDialog(String[] folderStrings) {
        ComboSelectionDialog dialog = new ComboSelectionDialog(this.shell, TITLE, PROMPT, folderStrings, 0);
        dialog.open();
        return dialog.getSelectedString();
    }

    public String[] getFolderStrings() {
        ArrayList<String> folders;
        block11: {
            File rootDir;
            block10: {
                String sharedDataPath;
                block9: {
                    folders = new ArrayList<String>();
                    sharedDataPath = "<not implemented>";
                    if (!sharedDataPath.trim().equals("")) break block9;
                    MessageDialog.openError((Shell)this.shell, (String)"Switch Task Folder Error", (String)"Please specify a root shared task folder in the Mylyn Reports preference page.");
                    return null;
                }
                rootDir = new File(sharedDataPath);
                if (rootDir.exists() && rootDir.isDirectory()) break block10;
                MessageDialog.openError((Shell)this.shell, (String)"Switch Task Folder Error", (String)"The root folder specified in the Mylyn Reports preference page could not be found.");
                return null;
            }
            if (SandboxUiPlugin.getDefault().getSharedDataDirectoryManager().isSharedDataDirectoryEnabled()) {
                folders.add(MAIN_LOCAL_DATA_DIR);
            }
            File[] files = rootDir.listFiles();
            int i = 0;
            while (i < files.length) {
                File currFile = files[i];
                if (currFile.isDirectory() && this.containsTaskData(currFile) && !TasksUiPlugin.getDefault().getDataDirectory().endsWith(currFile.getName())) {
                    folders.add(currFile.getName());
                }
                ++i;
            }
            if (folders.size() > 0) break block11;
            MessageDialog.openError((Shell)this.shell, (String)"Switch Task Folder Error", (String)"No task data folders were found in the root folder specified in the Mylyn Reports preference page.");
            return null;
        }
        try {
            String[] folderStrings = new String[folders.size()];
            int i = 0;
            while (i < folderStrings.length) {
                folderStrings[i] = (String)folders.get(i);
                ++i;
            }
            return folderStrings;
        }
        catch (RuntimeException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.sandbox.ui", "Could not create list of task folders to switch to.", (Throwable)e));
            return null;
        }
    }

    protected boolean containsTaskData(File folder) {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File currFile = files[i];
            if (currFile.isFile() && currFile.getName().equals("tasklist.xml.zip")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void switchTaskDataFolder(String targetFolder) {
        TasksUiPlugin.getTaskListManager().saveTaskList();
        if (targetFolder.equals(MAIN_LOCAL_DATA_DIR)) {
            SandboxUiPlugin.getDefault().getSharedDataDirectoryManager().setSharedDataDirectoryEnabled(false);
            new ContextCapturePauseAction().resume();
            ContextCorePlugin.getContextManager().setActivationHistorySuppressed(false);
        } else {
            String dataDirPath = "<not implemented>";
            SandboxUiPlugin.getDefault().getSharedDataDirectoryManager().setSharedDataDirectory(dataDirPath);
            SandboxUiPlugin.getDefault().getSharedDataDirectoryManager().setSharedDataDirectoryEnabled(true);
            new ContextCapturePauseAction().pause();
            ContextCorePlugin.getContextManager().setActivationHistorySuppressed(true);
        }
    }
}

