/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.views;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskDelegate;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.ui.IMemento;

public class TaskActivityViewSorter
extends ViewerSorter {
    private static final String activitySortColumn = "org.eclipse.mylyn.tasklist.ui.views.taskactivitysorter.sortcolumn";
    private static final String activityViewSorterSettings = "org.eclipse.mylyn.tasklist.ui.views.taskactivitysorter.sortsettings";
    private int[] directions;
    private static final int ASCENDING = 1;
    private static final int DESCENDING = -1;
    private static final int PRIORITY = 0;
    private static final int DESCRIPTION = 1;
    private static final int ELAPSED = 2;
    private static final int ESTIMATED = 3;
    private static final int REMINDER = 4;
    private static final int LAST_ACTIVE = 5;
    private int sortColumn = 5;
    static final int[] DEFAULT_DIRECTIONS = new int[]{1, 1, 1, -1, -1, -1, -1};

    public TaskActivityViewSorter() {
        this.resetState();
    }

    public void reverseDirection() {
        int n = this.sortColumn;
        this.directions[n] = this.directions[n] * -1;
    }

    public void setSortDirection(int direction) {
        if (direction == 1 || direction == -1) {
            this.directions[this.sortColumn] = direction;
        }
    }

    public int getDirection() {
        return this.directions[this.sortColumn];
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(int col) {
        this.sortColumn = col < 0 || col >= this.directions.length ? 5 : col;
    }

    public void resetState() {
        this.directions = new int[DEFAULT_DIRECTIONS.length];
        System.arraycopy(DEFAULT_DIRECTIONS, 0, this.directions, 0, this.directions.length);
    }

    private int compare(ScheduledTaskDelegate task1, ScheduledTaskDelegate task2) {
        if (this.sortColumn >= this.directions.length) {
            return 0;
        }
        switch (this.sortColumn) {
            case 0: {
                AbstractTask.PriorityLevel a = AbstractTask.PriorityLevel.fromString((String)task1.getPriority());
                AbstractTask.PriorityLevel b = AbstractTask.PriorityLevel.fromString((String)task2.getPriority());
                int result = a.compareTo((Enum)b);
                return result * this.directions[this.sortColumn];
            }
            case 1: {
                String description1 = task1.getSummary();
                String description2 = task2.getSummary();
                int result = this.getComparator().compare(description1, description2);
                return result * this.directions[this.sortColumn];
            }
            case 2: {
                long elapsed1 = task1.getDateRangeContainer().getElapsed((AbstractTask)task1);
                long elapsed2 = task2.getDateRangeContainer().getElapsed((AbstractTask)task2);
                int result = new Long(elapsed1).compareTo(new Long(elapsed2));
                return result * this.directions[this.sortColumn];
            }
            case 3: {
                int estimate1 = task1.getEstimateTimeHours();
                int estimate2 = task2.getEstimateTimeHours();
                int result = estimate1 - estimate2;
                return result * this.directions[this.sortColumn];
            }
            case 4: {
                int result = 0;
                if (task1.getScheduledForDate() != null && task2.getScheduledForDate() != null) {
                    long reminder1 = task1.getScheduledForDate().getTime();
                    long reminder2 = task2.getScheduledForDate().getTime();
                    result = new Long(reminder1).compareTo(new Long(reminder2));
                } else if (task1.getScheduledForDate() != null) {
                    result = 1;
                } else if (task2.getScheduledForDate() != null) {
                    result = -1;
                }
                return result * this.directions[this.sortColumn];
            }
            case 5: {
                long active1 = task1.getStart();
                long active2 = task2.getStart();
                int result = new Long(active1).compareTo(new Long(active2));
                return result * this.directions[this.sortColumn];
            }
        }
        return 0;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof ScheduledTaskContainer) {
            if (o2 instanceof ScheduledTaskContainer) {
                ScheduledTaskContainer dateRangeTaskContainer1 = (ScheduledTaskContainer)o1;
                ScheduledTaskContainer dateRangeTaskContainer2 = (ScheduledTaskContainer)o2;
                return -1 * dateRangeTaskContainer2.getStart().compareTo(dateRangeTaskContainer1.getStart());
            }
            return -1;
        }
        if (o1 instanceof AbstractTask) {
            if (o2 instanceof AbstractTaskContainer) {
                return -1;
            }
            if (o2 instanceof ScheduledTaskDelegate) {
                ScheduledTaskDelegate task1 = (ScheduledTaskDelegate)o1;
                ScheduledTaskDelegate task2 = (ScheduledTaskDelegate)o2;
                return this.compare(task1, task2);
            }
        }
        return 0;
    }

    public void saveState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento sortingMemento = memento.createChild(activityViewSorterSettings);
        if (sortingMemento != null) {
            int i = 0;
            while (i < this.directions.length) {
                sortingMemento.putInteger("direction" + i, this.directions[i]);
                ++i;
            }
            sortingMemento.putInteger(activitySortColumn, this.sortColumn);
        }
    }

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento sortingMemento = memento.getChild(activityViewSorterSettings);
        if (sortingMemento != null) {
            try {
                int i = 0;
                while (i < this.directions.length) {
                    this.directions[i] = sortingMemento.getInteger("direction" + i);
                    ++i;
                }
                this.sortColumn = sortingMemento.getInteger(activitySortColumn);
            }
            catch (NumberFormatException numberFormatException) {
                this.resetState();
            }
        }
    }
}

