/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.mylyn.internal.jira.core.model.Attachment;
import org.eclipse.mylyn.internal.jira.core.model.Comment;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.IssueLink;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.SecurityLevel;
import org.eclipse.mylyn.internal.jira.core.model.Status;
import org.eclipse.mylyn.internal.jira.core.model.Subtask;
import org.eclipse.mylyn.internal.jira.core.model.Version;

public class Issue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String key;
    private String parentId;
    private String parentKey;
    private String summary;
    private String environment;
    private String description;
    private Project project;
    private IssueType type;
    private Priority priority;
    private Status status;
    private Resolution resolution;
    private String assigneeName;
    private String reporterName;
    private Date created;
    private Date updated;
    private Version[] reportedVersions = null;
    private Version[] fixVersions = null;
    private Component[] components = null;
    private Date due;
    private int votes;
    private Comment[] comments = new Comment[0];
    private long initialEstimate;
    private long estimate;
    private long actual;
    private boolean isWatched;
    private boolean hasVote;
    private String url;
    private Attachment[] attachments = new Attachment[0];
    private CustomField[] customFields = new CustomField[0];
    private Subtask[] subtasks = new Subtask[0];
    private IssueLink[] issueLinks = new IssueLink[0];
    private SecurityLevel securityLevel;
    private boolean markupDetected;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(String parentKey) {
        this.parentKey = parentKey;
    }

    public String getAssignee() {
        return this.assigneeName;
    }

    public void setAssignee(String asignee) {
        this.assigneeName = asignee;
    }

    public Component[] getComponents() {
        return this.components;
    }

    public void setComponents(Component[] components) {
        this.components = components;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDue() {
        return this.due;
    }

    public void setDue(Date due) {
        this.due = due;
    }

    public Version[] getFixVersions() {
        return this.fixVersions;
    }

    public void setFixVersions(Version[] fixVersions) {
        this.fixVersions = fixVersions;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getReporter() {
        return this.reporterName;
    }

    public void setReporter(String reporter) {
        this.reporterName = reporter;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public IssueType getType() {
        return this.type;
    }

    public void setType(IssueType type) {
        this.type = type;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public Version[] getReportedVersions() {
        return this.reportedVersions;
    }

    public void setReportedVersions(Version[] reportedVersions) {
        this.reportedVersions = reportedVersions;
    }

    public int getVotes() {
        return this.votes;
    }

    public void setVotes(int votes) {
        this.votes = votes;
    }

    public Comment[] getComments() {
        return this.comments;
    }

    public void setComments(Comment[] comments) {
        this.comments = comments;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public long getActual() {
        return this.actual;
    }

    public void setActual(long actual) {
        this.actual = actual;
    }

    public long getInitialEstimate() {
        return this.initialEstimate;
    }

    public void setInitialEstimate(long initialEstimate) {
        this.initialEstimate = initialEstimate;
    }

    public long getEstimate() {
        return this.estimate;
    }

    public void setEstimate(long estimate) {
        this.estimate = estimate;
    }

    public void setWatched(boolean isWatched) {
        this.isWatched = isWatched;
    }

    public boolean isWatched() {
        return this.isWatched;
    }

    public boolean canUserVote(String user) {
        return this.getResolution() == null && !user.equals(this.getReporter());
    }

    public void setHasVote(boolean hasVote) {
        this.hasVote = hasVote;
    }

    public boolean getHasVote() {
        return this.hasVote;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return String.valueOf(this.key) + " " + this.summary;
    }

    public Attachment[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Attachment[] attachments) {
        this.attachments = attachments;
    }

    public Attachment getAttachmentById(String id) {
        int i = 0;
        while (i < this.attachments.length) {
            if (this.attachments[i].getId().equals(id)) {
                return this.attachments[i];
            }
            ++i;
        }
        return null;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public CustomField getCustomFieldById(String fieldId) {
        CustomField[] customFieldArray = this.getCustomFields();
        int n = customFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomField field = customFieldArray[n2];
            if (fieldId.equals(field.getId())) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    public Subtask[] getSubtasks() {
        return this.subtasks;
    }

    public void setSubtasks(Subtask[] subtasks) {
        this.subtasks = subtasks;
    }

    public IssueLink[] getIssueLinks() {
        return this.issueLinks;
    }

    public void setIssueLinks(IssueLink[] issueLinks) {
        this.issueLinks = issueLinks;
    }

    public String[] getFieldValues(String field) {
        if ("summary".equals(field)) {
            return new String[]{this.getSummary()};
        }
        if ("description".equals(field)) {
            return new String[]{this.getDescription()};
        }
        if ("resolution".equals(field)) {
            if (this.resolution != null) {
                return new String[]{this.resolution.getId()};
            }
        } else {
            if ("assignee".equals(field)) {
                return new String[]{this.assigneeName};
            }
            if ("reporter".equals(field)) {
                return new String[]{this.reporterName};
            }
            if ("issuetype".equals(field)) {
                if (this.type != null) {
                    return new String[]{this.type.getId()};
                }
            } else if ("priority".equals(field)) {
                if (this.priority != null) {
                    return new String[]{this.getPriority().getId()};
                }
            } else if ("components".equals(field)) {
                if (this.components != null) {
                    String[] res = new String[this.components.length];
                    int i = 0;
                    while (i < this.components.length) {
                        res[i] = this.components[i].getId();
                        ++i;
                    }
                    return res;
                }
            } else if ("versions".equals(field)) {
                if (this.reportedVersions != null) {
                    String[] res = new String[this.reportedVersions.length];
                    int i = 0;
                    while (i < this.reportedVersions.length) {
                        res[i] = this.reportedVersions[i].getId();
                        ++i;
                    }
                    return res;
                }
            } else if ("fixVersions".equals(field)) {
                if (this.fixVersions != null) {
                    String[] res = new String[this.fixVersions.length];
                    int i = 0;
                    while (i < this.fixVersions.length) {
                        res[i] = this.fixVersions[i].getId();
                        ++i;
                    }
                    return res;
                }
            } else if ("environment".equals(field)) {
                if (this.environment != null) {
                    return new String[]{this.environment};
                }
            } else if ("duedate".equals(field)) {
                if (this.due != null) {
                    return new String[]{new SimpleDateFormat("dd/MMM/yy").format(this.due)};
                }
            } else if ("timetracking".equals(field)) {
                return new String[]{String.valueOf(Long.toString(this.getInitialEstimate() / 60L)) + "m"};
            }
        }
        if (field.startsWith("customfield_")) {
            int i = 0;
            while (i < this.customFields.length) {
                CustomField customField = this.customFields[i];
                if (customField.getId().equals(field)) {
                    List<String> values = customField.getValues();
                    return values.toArray(new String[values.size()]);
                }
                ++i;
            }
        }
        return null;
    }

    public void setValue(String field, String value) {
        if ("resolution".equals(field)) {
            if (value != null) {
                this.resolution = new Resolution();
                this.resolution.setId(value);
            }
        } else if ("assignee".equals(field)) {
            this.assigneeName = value;
        } else if (field.startsWith("customfield_")) {
            boolean found = false;
            int i = 0;
            while (i < this.customFields.length) {
                CustomField customField = this.customFields[i];
                if (customField.getId().equals(field)) {
                    this.customFields[i] = new CustomField(customField.getId(), customField.getKey(), customField.getKey(), Collections.singletonList(value));
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                List<CustomField> list = Arrays.asList(this.customFields);
                list.add(new CustomField(field, "", "", Collections.singletonList(value)));
                this.customFields = list.toArray(new CustomField[list.size()]);
            }
        }
    }

    public SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(SecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
    }

    public boolean isMarkupDetected() {
        return this.markupDetected;
    }

    public void setMarkupDetected(boolean markupDetected) {
        this.markupDetected = markupDetected;
    }
}

