/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.Version;

public class Project
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String key;
    private String description;
    private String lead;
    private String projectUrl;
    private String url;
    private Component[] components;
    private Version[] versions;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLead() {
        return this.lead;
    }

    public void setLead(String lead) {
        this.lead = lead;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Component getComponent(String name) {
        int i = 0;
        while (i < this.components.length) {
            if (this.components[i].getName().equals(name)) {
                return this.components[i];
            }
            ++i;
        }
        return null;
    }

    public Component[] getComponents() {
        return this.components;
    }

    public void setComponents(Component[] components) {
        this.components = components;
    }

    public Version getVersion(String name) {
        int i = 0;
        while (i < this.versions.length) {
            if (this.versions[i].getName().equals(name)) {
                return this.versions[i];
            }
            ++i;
        }
        return null;
    }

    public void setVersions(Version[] versions) {
        this.versions = versions;
    }

    public Version[] getReleasedVersions() {
        ArrayList<Version> releasedVersions = new ArrayList<Version>();
        int i = 0;
        while (i < this.versions.length) {
            Version version = this.versions[i];
            if (version.isReleased()) {
                releasedVersions.add(version);
            }
            ++i;
        }
        return releasedVersions.toArray(new Version[releasedVersions.size()]);
    }

    public Version[] getUnreleasedVersions() {
        ArrayList<Version> unreleasedVersions = new ArrayList<Version>();
        int i = 0;
        while (i < this.versions.length) {
            Version version = this.versions[i];
            if (!version.isReleased()) {
                unreleasedVersions.add(version);
            }
            ++i;
        }
        return unreleasedVersions.toArray(new Version[unreleasedVersions.size()]);
    }

    public Version[] getArchivedVersions() {
        ArrayList<Version> archivedVersions = new ArrayList<Version>();
        int i = 0;
        while (i < this.versions.length) {
            Version version = this.versions[i];
            if (version.isArchived()) {
                archivedVersions.add(version);
            }
            ++i;
        }
        return archivedVersions.toArray(new Version[archivedVersions.size()]);
    }

    public Version[] getVersions() {
        return this.versions;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project that = (Project)obj;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

