/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.Status;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraClientData;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.mylyn.web.core.AuthenticationCredentials;
import org.eclipse.mylyn.web.core.AuthenticationType;

public abstract class AbstractJiraClient
implements JiraClient {
    private volatile JiraClientData data;
    private final String baseUrl;
    private final AbstractWebLocation location;
    private final boolean useCompression;
    private String characterEncoding;
    private boolean attemptedToDetermineCharacterEncoding;

    public AbstractJiraClient(AbstractWebLocation location, boolean useCompression) {
        if (location == null) {
            throw new IllegalArgumentException("baseURL may not be null");
        }
        this.baseUrl = location.getUrl();
        this.location = location;
        this.useCompression = useCompression;
        this.data = new JiraClientData();
    }

    public synchronized void refreshDetails(IProgressMonitor monitor) throws JiraException {
        monitor.beginTask("Updating repository configuration", -1);
        JiraClientData newData = new JiraClientData();
        this.initializeServerInfo(newData);
        this.advance(monitor, 1);
        this.initializeProjects(newData);
        this.advance(monitor, 1);
        this.initializePriorities(newData);
        this.advance(monitor, 1);
        this.initializeIssueTypes(newData);
        this.advance(monitor, 1);
        this.initializeResolutions(newData);
        this.advance(monitor, 1);
        this.initializeStatuses(newData);
        this.advance(monitor, 1);
        newData.lastUpdate = System.currentTimeMillis();
        this.data = newData;
        monitor.done();
    }

    public synchronized void refreshServerInfo(IProgressMonitor monitor) throws JiraException {
        try {
            monitor.beginTask("Getting server information", -1);
            this.initializeServerInfo(this.data);
        }
        finally {
            monitor.done();
        }
    }

    private void advance(IProgressMonitor monitor, int worked) {
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public boolean hasDetails() {
        return this.data.lastUpdate != 0L;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getUserName() {
        AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
        return credentials != null ? credentials.getUserName() : "";
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    private void initializeProjects(JiraClientData data) throws JiraException {
        String version = data.serverInfo.getVersion();
        data.projects = new JiraVersion(version).compareTo(JiraVersion.JIRA_3_4) >= 0 ? this.getProjectsRemoteNoSchemes() : this.getProjectsRemote();
        data.projectsById = new HashMap<String, Project>(data.projects.length);
        data.projectsByKey = new HashMap<String, Project>(data.projects.length);
        int i = 0;
        while (i < data.projects.length) {
            Project project = data.projects[i];
            project.setComponents(this.getComponentsRemote(project.getKey()));
            project.setVersions(this.getVersionsRemote(project.getKey()));
            data.projectsById.put(project.getId(), project);
            data.projectsByKey.put(project.getKey(), project);
            ++i;
        }
    }

    public abstract Project[] getProjectsRemote() throws JiraException;

    public abstract Project[] getProjectsRemoteNoSchemes() throws JiraException;

    public abstract Version[] getVersionsRemote(String var1) throws JiraException;

    public abstract Component[] getComponentsRemote(String var1) throws JiraException;

    public Project getProjectById(String id) {
        return this.data.projectsById.get(id);
    }

    public Project getProjectByKey(String key) {
        return this.data.projectsByKey.get(key);
    }

    public Project[] getProjects() {
        return this.data.projects;
    }

    private void initializePriorities(JiraClientData data) throws JiraException {
        data.priorities = this.getPrioritiesRemote();
        data.prioritiesById = new HashMap<String, Priority>(data.priorities.length);
        int i = 0;
        while (i < data.priorities.length) {
            Priority priority = data.priorities[i];
            data.prioritiesById.put(priority.getId(), priority);
            ++i;
        }
    }

    public abstract Priority[] getPrioritiesRemote() throws JiraException;

    public Priority getPriorityById(String id) {
        return this.data.prioritiesById.get(id);
    }

    public Priority[] getPriorities() {
        return this.data.priorities;
    }

    private void initializeIssueTypes(JiraClientData data) throws JiraException {
        IssueType issueType;
        IssueType[] issueTypes = this.getIssueTypesRemote();
        String version = data.serverInfo.getVersion();
        IssueType[] subTaskIssueTypes = new JiraVersion(version).compareTo(JiraVersion.JIRA_3_3) >= 0 ? this.getSubTaskIssueTypesRemote() : new IssueType[]{};
        data.issueTypesById = new HashMap<String, IssueType>(issueTypes.length + subTaskIssueTypes.length);
        IssueType[] issueTypeArray = issueTypes;
        int n = issueTypes.length;
        int n2 = 0;
        while (n2 < n) {
            issueType = issueTypeArray[n2];
            data.issueTypesById.put(issueType.getId(), issueType);
            ++n2;
        }
        issueTypeArray = subTaskIssueTypes;
        n = subTaskIssueTypes.length;
        n2 = 0;
        while (n2 < n) {
            issueType = issueTypeArray[n2];
            issueType.setSubTaskType(true);
            data.issueTypesById.put(issueType.getId(), issueType);
            ++n2;
        }
        data.issueTypes = new IssueType[issueTypes.length + subTaskIssueTypes.length];
        System.arraycopy(issueTypes, 0, data.issueTypes, 0, issueTypes.length);
        System.arraycopy(subTaskIssueTypes, 0, data.issueTypes, issueTypes.length, subTaskIssueTypes.length);
    }

    public abstract IssueType[] getIssueTypesRemote() throws JiraException;

    public abstract IssueType[] getSubTaskIssueTypesRemote() throws JiraException;

    public IssueType getIssueTypeById(String id) {
        return this.data.issueTypesById.get(id);
    }

    public IssueType[] getIssueTypes() {
        return this.data.issueTypes;
    }

    private void initializeStatuses(JiraClientData data) throws JiraException {
        data.statuses = this.getStatusesRemote();
        data.statusesById = new HashMap<String, Status>(data.statuses.length);
        int i = 0;
        while (i < data.statuses.length) {
            Status status = data.statuses[i];
            data.statusesById.put(status.getId(), status);
            ++i;
        }
    }

    public abstract Status[] getStatusesRemote() throws JiraException;

    public Status getStatusById(String id) {
        return this.data.statusesById.get(id);
    }

    public Status[] getStatuses() {
        return this.data.statuses;
    }

    private void initializeResolutions(JiraClientData data) throws JiraException {
        data.resolutions = this.getResolutionsRemote();
        data.resolutionsById = new HashMap<String, Resolution>(data.resolutions.length);
        int i = 0;
        while (i < data.resolutions.length) {
            Resolution resolution = data.resolutions[i];
            data.resolutionsById.put(resolution.getId(), resolution);
            ++i;
        }
    }

    public abstract Resolution[] getResolutionsRemote() throws JiraException;

    public Resolution getResolutionById(String id) {
        return this.data.resolutionsById.get(id);
    }

    public Resolution[] getResolutions() {
        return this.data.resolutions;
    }

    private void initializeServerInfo(JiraClientData data) throws JiraException {
        data.serverInfo = this.getServerInfoRemote();
    }

    public ServerInfo getServerInfo() throws JiraException {
        ServerInfo info = this.data.serverInfo;
        if (info == null) {
            info = this.getServerInfoRemote();
        }
        this.data.serverInfo = info;
        return info;
    }

    public abstract ServerInfo getServerInfoRemote() throws JiraException;

    public boolean equals(Object obj) {
        if (obj instanceof AbstractJiraClient) {
            return this.getBaseUrl().equals(((AbstractJiraClient)obj).getBaseUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.getBaseUrl().hashCode();
    }

    public String toString() {
        return this.getBaseUrl();
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    public void setData(JiraClientData data) {
        this.data = data;
    }

    public JiraClientData getData() {
        return this.data;
    }

    public String getCharacterEncoding() throws JiraException {
        if (this.characterEncoding == null) {
            String serverEncoding = this.getServerInfo().getCharacterEncoding();
            if (serverEncoding != null) {
                return serverEncoding;
            }
            if (!this.attemptedToDetermineCharacterEncoding) {
                this.refreshServerInfo((IProgressMonitor)new NullProgressMonitor());
                serverEncoding = this.getServerInfo().getCharacterEncoding();
                if (serverEncoding != null) {
                    return serverEncoding;
                }
            }
            return "UTF-8";
        }
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }
}

