/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service;

import java.io.File;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.jira.core.model.Attachment;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.Issue;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Query;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.Status;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteIssue;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.web.core.AbstractWebLocation;

public interface JiraClient {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final int ASSIGNEE_DEFAULT = 1;
    public static final int ASSIGNEE_CURRENT = 2;
    public static final int ASSIGNEE_NONE = 3;
    public static final int ASSIGNEE_USER = 4;
    public static final int ASSIGNEE_SELF = 5;

    public boolean useCompression();

    public String getBaseUrl();

    public String getUserName();

    @Deprecated
    public void login() throws JiraException;

    public void logout();

    public Project getProjectById(String var1);

    public Project getProjectByKey(String var1);

    public Project[] getProjects();

    public Priority getPriorityById(String var1);

    public Priority[] getPriorities();

    public IssueType getIssueTypeById(String var1);

    public IssueType[] getIssueTypes();

    public Status getStatusById(String var1);

    public Status[] getStatuses();

    public Resolution getResolutionById(String var1);

    public Resolution[] getResolutions();

    public Issue getIssueByKey(String var1) throws JiraException;

    public Issue getIssueById(String var1) throws JiraException;

    public String getKeyFromId(String var1) throws JiraException;

    public RepositoryOperation[] getAvailableOperations(String var1) throws JiraException;

    public String[] getActionFields(String var1, String var2) throws JiraException;

    public RepositoryTaskAttribute[] getEditableAttributes(String var1) throws JiraException;

    public CustomField[] getCustomAttributes() throws JiraException;

    public void search(Query var1, IssueCollector var2) throws JiraException;

    public ServerInfo getServerInfo() throws JiraException;

    public NamedFilter[] getNamedFilters() throws JiraException;

    public void addCommentToIssue(Issue var1, String var2) throws JiraException;

    public void updateIssue(Issue var1, String var2) throws JiraException;

    public void assignIssueTo(Issue var1, int var2, String var3, String var4) throws JiraException;

    public void advanceIssueWorkflow(Issue var1, String var2, String var3) throws JiraException;

    public void attachFile(Issue var1, String var2, PartSource var3, String var4) throws JiraException;

    public void attachFile(Issue var1, String var2, String var3, byte[] var4, String var5) throws JiraException;

    public void attachFile(Issue var1, String var2, String var3, File var4, String var5) throws JiraException;

    public byte[] retrieveFile(Issue var1, Attachment var2) throws JiraException;

    public void retrieveFile(Issue var1, Attachment var2, OutputStream var3) throws JiraException;

    public Issue createIssue(Issue var1) throws JiraException;

    public Issue createSubTask(Issue var1) throws JiraException;

    public void watchIssue(Issue var1) throws JiraException;

    public void unwatchIssue(Issue var1) throws JiraException;

    public void voteIssue(Issue var1) throws JiraException;

    public void unvoteIssue(Issue var1) throws JiraException;

    public void refreshDetails(IProgressMonitor var1) throws JiraException;

    public void refreshServerInfo(IProgressMonitor var1) throws JiraException;

    public boolean hasDetails();

    public String getCharacterEncoding() throws JiraException;

    public AbstractWebLocation getLocation();

    public void deleteIssue(Issue var1) throws JiraException;

    public RemoteIssue getRemoteIssueByKey(String var1) throws JiraException;
}

