/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.soap;

import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.transport.http.HTTPConstants;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.JiraSoapServiceServiceLocator;
import org.eclipse.mylyn.web.core.AbstractWebLocation;

public class GZipJiraSoapServiceServiceLocator
extends JiraSoapServiceServiceLocator {
    private AbstractWebLocation location;
    private boolean compression;

    public GZipJiraSoapServiceServiceLocator() {
    }

    public GZipJiraSoapServiceServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public GZipJiraSoapServiceServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public Call createCall() throws ServiceException {
        Call call = super.createCall();
        if (this.compression) {
            call.setProperty("transport.http.acceptGzip", (Object)Boolean.TRUE);
        }
        call.setProperty("org.eclipse.mylyn.jira.location", (Object)this.location);
        Hashtable<String, Boolean> headers = new Hashtable<String, Boolean>();
        headers.put(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED, Boolean.FALSE);
        call.setProperty("HTTP-Request-Headers", headers);
        return call;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    public void setLocation(AbstractWebLocation location) {
        this.location = location;
    }
}

