/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web.rss;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraRemoteMessageException;
import org.eclipse.mylyn.internal.jira.core.service.JiraServiceUnavailableException;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSessionCallback;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.RssReader;

public abstract class RssFeedProcessorCallback
implements JiraWebSessionCallback {
    private static final int MAX_REDIRECTS = 1;
    private final boolean useCompression;
    private final IssueCollector collector;

    public RssFeedProcessorCallback(boolean useCompression, IssueCollector collector) {
        this.useCompression = useCompression;
        this.collector = collector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void execute(HttpClient client, JiraClient server, String baseUrl) throws JiraException, IOException {
        String rssUrl = this.getRssUrl(baseUrl);
        boolean i = false;
        if (i > true) throw new JiraException("Maximum number of query redirects exceeded: " + rssUrl);
        GetMethod rssRequest = new GetMethod(rssUrl);
        rssRequest.setFollowRedirects(false);
        if (this.useCompression) {
            rssRequest.setRequestHeader("Accept-Encoding", "gzip");
        }
        try {
            int code = client.executeMethod((HttpMethod)rssRequest);
            if (code == 302) {
                Header locationHeader = rssRequest.getResponseHeader("location");
                if (locationHeader == null) {
                    throw new JiraServiceUnavailableException("Invalid server response, missing redirect location");
                }
                String url = locationHeader.getValue();
                if (!url.startsWith(String.valueOf(baseUrl) + "/browse/")) {
                    throw new JiraException("Server redirected to unexpected location: " + url);
                }
                rssRequest.releaseConnection();
                rssUrl = String.valueOf(url) + "?decorator=none&view=rss";
            } else if (code != 200) {
                StringBuilder sb = new StringBuilder("Unexpected result code ");
                sb.append(code);
                sb.append(" while running query: ");
                sb.append(rssUrl);
                throw new JiraRemoteMessageException(sb.toString(), rssRequest.getResponseBodyAsString());
            }
            if (!this.isXMLOrRSS((HttpMethod)rssRequest)) {
                return;
            }
            this.parseResult(server, baseUrl, rssRequest);
            return;
        }
        finally {
            rssRequest.releaseConnection();
        }
    }

    private void parseResult(JiraClient server, String baseUrl, GetMethod rssRequest) throws IOException, JiraException {
        InputStream in = rssRequest.getResponseBodyAsStream();
        try {
            if (this.isResponseGZipped((HttpMethod)rssRequest)) {
                in = new GZIPInputStream(rssRequest.getResponseBodyAsStream());
            }
            new RssReader(server, this.collector).readRssFeed(in, baseUrl);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    protected abstract String getRssUrl(String var1) throws JiraException;

    private boolean isResponseGZipped(HttpMethod method) {
        Header contentEncoding = method.getResponseHeader("Content-Encoding");
        return contentEncoding != null && "gzip".equals(contentEncoding.getValue());
    }

    private boolean isXMLOrRSS(HttpMethod method) throws HttpException {
        Header contentType = method.getResponseHeader("Content-Type");
        if (contentType == null) {
            return false;
        }
        HeaderElement[] values = contentType.getElements();
        int i = 0;
        while (i < values.length) {
            HeaderElement element = values[i];
            if (element.getName().startsWith("text/xml")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

