/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web.rss;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSession;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.RssFeedProcessorCallback;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.RssJiraFilterConverterFactory;

public class RssJiraFilterService {
    private final JiraClient server;
    private final boolean useGZipCompression;

    public RssJiraFilterService(JiraClient server) {
        this.server = server;
        this.useGZipCompression = server.useCompression();
    }

    public void findIssues(final FilterDefinition filterDefinition, final IssueCollector collector) throws JiraException {
        JiraWebSession session = new JiraWebSession(this.server);
        session.doInSession(new RssFeedProcessorCallback(this.useGZipCompression, collector){

            protected String getRssUrl(String baseUrl) throws JiraException {
                StringBuffer rssUrlBuffer = new StringBuffer(baseUrl);
                String version = RssJiraFilterService.this.server.getServerInfo().getVersion();
                if (new JiraVersion(version).compareTo(JiraVersion.JIRA_3_7) >= 0) {
                    rssUrlBuffer.append("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?decorator=none&reset=true&");
                    if (collector.getMaxHits() != -1) {
                        rssUrlBuffer.append("tempMax=").append(collector.getMaxHits()).append('&');
                    }
                } else {
                    rssUrlBuffer.append("/secure/IssueNavigator.jspa?view=rss&decorator=none&reset=true&");
                    if (collector.getMaxHits() != -1) {
                        rssUrlBuffer.append("tempMax=").append(collector.getMaxHits()).append('&');
                    }
                }
                rssUrlBuffer.append(RssJiraFilterConverterFactory.getConverter(RssJiraFilterService.this.server).convert(filterDefinition, RssJiraFilterService.this.server.getCharacterEncoding()));
                return rssUrlBuffer.toString();
            }
        });
    }

    public void executeNamedFilter(final NamedFilter filter, final IssueCollector collector) throws JiraException {
        JiraWebSession session = new JiraWebSession(this.server);
        session.doInSession(new RssFeedProcessorCallback(this.useGZipCompression, collector){

            protected String getRssUrl(String baseUrl) throws JiraException {
                StringBuffer rssUrlBuffer = new StringBuffer(baseUrl);
                String version = RssJiraFilterService.this.server.getServerInfo().getVersion();
                if (new JiraVersion(version).compareTo(JiraVersion.JIRA_3_7) >= 0) {
                    rssUrlBuffer.append("/sr/jira.issueviews:searchrequest-xml/").append(filter.getId()).append("/SearchRequest-").append(filter.getId()).append(".xml");
                    if (collector.getMaxHits() != -1) {
                        rssUrlBuffer.append("?tempMax=").append(collector.getMaxHits());
                    }
                } else {
                    rssUrlBuffer.append("/secure/IssueNavigator.jspa?view=rss&decorator=none&");
                    if (collector.getMaxHits() != -1) {
                        rssUrlBuffer.append("tempMax=").append(collector.getMaxHits()).append('&');
                    }
                    rssUrlBuffer.append("requestId=").append(filter.getId());
                }
                return rssUrlBuffer.toString();
            }
        });
    }

    public void quickSearch(final String searchString, final IssueCollector collector) throws JiraException {
        JiraWebSession session = new JiraWebSession(this.server);
        session.doInSession(new RssFeedProcessorCallback(this.useGZipCompression, collector){

            protected String getRssUrl(String baseUrl) {
                StringBuffer rssUrlBuffer = new StringBuffer(baseUrl);
                rssUrlBuffer.append("/secure/QuickSearch.jspa?view=rss&decorator=none&reset=true&");
                if (collector.getMaxHits() != -1) {
                    rssUrlBuffer.append("tempMax=").append(collector.getMaxHits()).append('&');
                }
                try {
                    rssUrlBuffer.append("searchString=").append(URLEncoder.encode(searchString, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                return rssUrlBuffer.toString();
            }
        });
    }

    public void getIssueByKey(final String issueKey, IssueCollector collector) throws JiraException {
        JiraWebSession session = new JiraWebSession(this.server);
        session.doInSession(new RssFeedProcessorCallback(this.useGZipCompression, collector){

            protected String getRssUrl(String baseUrl) throws JiraException {
                StringBuffer rssUrlBuffer = new StringBuffer(baseUrl);
                String version = RssJiraFilterService.this.server.getServerInfo().getVersion();
                if (new JiraVersion(version).compareTo(JiraVersion.JIRA_3_7) >= 0) {
                    rssUrlBuffer.append("/si/jira.issueviews:issue-xml/");
                    rssUrlBuffer.append(issueKey);
                    rssUrlBuffer.append("/");
                    rssUrlBuffer.append(issueKey);
                    rssUrlBuffer.append(".xml");
                } else {
                    rssUrlBuffer.append("/browse/");
                    rssUrlBuffer.append(issueKey);
                    rssUrlBuffer.append("?view=rss&decorator=none&reset=true&tempMax=1");
                }
                return rssUrlBuffer.toString();
            }
        });
    }
}

