/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import org.eclipse.mylyn.internal.jira.ui.JiraFieldType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JiraAttribute {
    ISSUE_KEY("task.common.key", JiraFieldType.TEXTFIELD, "Issue ID:"),
    SUMMARY("task.common.summary", JiraFieldType.TEXTFIELD, "Summary:", true, false, "summary"),
    DESCRIPTION("task.common.description", JiraFieldType.TEXTFIELD, "Description:", true, false, "description"),
    STATUS("task.common.status", JiraFieldType.SELECT, "Status:"),
    RESOLUTION("task.common.resolution", JiraFieldType.SELECT, "Resolution:", true, false, "resolution"),
    DATE_CREATION("task.common.date.created", JiraFieldType.TEXTFIELD, "Created:"),
    DATE_MODIFIED("task.common.date.modified", JiraFieldType.TEXTFIELD, "Modified:"),
    USER_ASSIGNED("task.common.user.assigned", JiraFieldType.USERPICKER, "Assigned to:", true, false, "assignee"),
    USER_REPORTER("task.common.user.reporter", JiraFieldType.USERPICKER, "Reported by:"),
    PRODUCT("task.common.product", JiraFieldType.PROJECT, "Project:", false, true),
    PRIORITY("task.common.priority", JiraFieldType.SELECT, "Priority:", false, false, "priority"),
    TYPE("attribute.jira.type", JiraFieldType.SELECT, "Type:", false, false, "issuetype"),
    PARENT_KEY("attribute.jira.issue_parent_key", JiraFieldType.ISSUELINK, "Parent:", false, true),
    PARENT_ID("attribute.jira.issue_parent_id", JiraFieldType.ISSUELINK, "Parent ID:", true, true),
    COMPONENTS("attribute.jira.components", JiraFieldType.MULTISELECT, "Components:", false, false, "components"),
    AFFECTSVERSIONS("attribute.jira.affectsversions", JiraFieldType.MULTISELECT, "Affects Versions:", false, false, "versions"),
    FIXVERSIONS("attribute.jira.fixversions", JiraFieldType.MULTISELECT, "Fix Versions:", false, false, "fixVersions"),
    ESTIMATE("attribute.jira.estimate", JiraFieldType.TEXTFIELD, "Estimate:", false, false, "timetracking"),
    DUE("attribute.jira.due", JiraFieldType.TEXTFIELD, "Due Date:", true, false, "duedate"),
    ENVIRONMENT("attribute.jira.environment", JiraFieldType.TEXTAREA, "Environment:", false, false, "environment"),
    COMMENT_NEW("task.common.comment.new", JiraFieldType.TEXTAREA, "New Comment:", true, false, "comment"),
    COMMENT_AUTHOR("task.common.comment.author", JiraFieldType.TEXTAREA, "Author:"),
    COMMENT_TEXT("task.common.comment.text", JiraFieldType.TEXTAREA, "Comment:"),
    COMMENT_DATE("task.common.comment.date", JiraFieldType.TEXTAREA, "Date:"),
    SUBTASK_IDS("attribute.jira.subtask_ids", JiraFieldType.TEXTFIELD, "Subtask ids:", true, true),
    SUBTASK_KEYS("attribute.jira.subtask_keys", JiraFieldType.ISSUELINKS, "Subtasks:", false, true),
    SECURITY_LEVEL("attribute.jira.security", JiraFieldType.SELECT, "Security Level:", false, true),
    UNKNOWN(null, JiraFieldType.UNKNOWN, "unknown:", true, true);

    private final String id;
    private final String name;
    private final JiraFieldType type;
    private final boolean isHidden;
    private final boolean isReadOnly;
    private final String paramName;

    private JiraAttribute(String id, JiraFieldType type, String name) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.isHidden = true;
        this.isReadOnly = true;
        this.paramName = null;
    }

    private JiraAttribute(String id, JiraFieldType type, String name, boolean isHidden, boolean isReadOnly) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.isHidden = isHidden;
        this.isReadOnly = isReadOnly;
        this.paramName = null;
    }

    private JiraAttribute(String id, JiraFieldType type, String name, boolean isHidden, boolean isReadOnly, String paramName) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.isHidden = isHidden;
        this.isReadOnly = isReadOnly;
        this.paramName = paramName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public JiraFieldType getType() {
        return this.type;
    }

    public String getKey() {
        return this.type.getKey();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public static JiraAttribute valueById(String id) {
        JiraAttribute[] jiraAttributeArray = JiraAttribute.values();
        int n = jiraAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JiraAttribute attribute = jiraAttributeArray[n2];
            if (id.equals(attribute.getId())) {
                return attribute;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public String getParamName() {
        return this.paramName;
    }
}

