/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.jira.ui.JiraAttribute;
import org.eclipse.mylyn.internal.jira.ui.JiraFieldType;
import org.eclipse.mylyn.internal.jira.ui.JiraUtils;
import org.eclipse.mylyn.internal.tasks.core.AbstractAttributeMapper;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;

public class JiraAttributeFactory
extends AbstractAttributeFactory {
    private static final long serialVersionUID = 8000933300692372211L;
    public static final String ATTRIBUTE_TYPE = "attribute.jira.type";
    public static final String ATTRIBUTE_ISSUE_PARENT_KEY = "attribute.jira.issue_parent_key";
    public static final String ATTRIBUTE_ISSUE_PARENT_ID = "attribute.jira.issue_parent_id";
    public static final String ATTRIBUTE_ENVIRONMENT = "attribute.jira.environment";
    public static final String ATTRIBUTE_COMPONENTS = "attribute.jira.components";
    public static final String ATTRIBUTE_FIXVERSIONS = "attribute.jira.fixversions";
    public static final String ATTRIBUTE_AFFECTSVERSIONS = "attribute.jira.affectsversions";
    public static final String ATTRIBUTE_ESTIMATE = "attribute.jira.estimate";
    public static final String ATTRIBUTE_DUE_DATE = "attribute.jira.due";
    public static final String ATTRIBUTE_SUBTASK_IDS = "attribute.jira.subtask_ids";
    public static final String ATTRIBUTE_SUBTASK_KEYS = "attribute.jira.subtask_keys";
    public static final String ATTRIBUTE_CUSTOM_PREFIX = "attribute.jira.custom::";
    public static final String ATTRIBUTE_LINK_PREFIX = "attribute.jira.link::";
    public static final String ATTRIBUTE_SECURITY_LEVEL = "attribute.jira.security";
    public static final String ATTRIBUTE_READ_ONLY = "attribute.jira.read-only";
    public static final String JIRA_DATE_FORMAT = "dd MMM yyyy HH:mm:ss z";
    public static final String TYPE_KEY = "type";
    private final JiraAttributeMapper attributeMapper = new JiraAttributeMapper(this);

    public RepositoryTaskAttribute createAttribute(String key) {
        RepositoryTaskAttribute attribute = super.createAttribute(key);
        attribute.putMetaDataValue(TYPE_KEY, JiraAttribute.valueById(attribute.getId()).getKey());
        return attribute;
    }

    public boolean isHidden(String key) {
        return JiraAttribute.valueById(key).isHidden();
    }

    public String getName(String key) {
        return JiraAttribute.valueById(key).getName();
    }

    public boolean isReadOnly(String key) {
        return JiraAttribute.valueById(key).isReadOnly();
    }

    public String mapCommonAttributeKey(String key) {
        if ("summary".equals(key)) {
            return "task.common.summary";
        }
        if ("description".equals(key)) {
            return "task.common.description";
        }
        if ("priority".equals(key)) {
            return "task.common.priority";
        }
        if ("resolution".equals(key)) {
            return "task.common.resolution";
        }
        if ("assignee".equals(key)) {
            return "task.common.user.assigned";
        }
        if ("environment".equals(key)) {
            return ATTRIBUTE_ENVIRONMENT;
        }
        if ("issuetype".equals(key)) {
            return ATTRIBUTE_TYPE;
        }
        if ("components".equals(key)) {
            return ATTRIBUTE_COMPONENTS;
        }
        if ("versions".equals(key)) {
            return ATTRIBUTE_AFFECTSVERSIONS;
        }
        if ("fixVersions".equals(key)) {
            return ATTRIBUTE_FIXVERSIONS;
        }
        if ("timetracking".equals(key)) {
            return ATTRIBUTE_ESTIMATE;
        }
        if ("duedate".equals(key)) {
            return ATTRIBUTE_DUE_DATE;
        }
        if ("task.common.component".equals(key)) {
            return ATTRIBUTE_COMPONENTS;
        }
        if (key.startsWith("issueLink")) {
            return ATTRIBUTE_LINK_PREFIX + key;
        }
        if (key.startsWith("customfield")) {
            return ATTRIBUTE_CUSTOM_PREFIX + key;
        }
        return key;
    }

    public Date getDateForAttributeType(String attributeKey, String dateString) {
        if (dateString == null || dateString.equals("")) {
            return null;
        }
        try {
            return JiraUtils.stringToDate(dateString);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.jira.ui", "Error parsing date for attribute \"" + attributeKey + "\": \"" + dateString + "\"", (Throwable)e));
            return null;
        }
    }

    public AbstractAttributeMapper getAttributeMapper() {
        return this.attributeMapper;
    }

    private class JiraAttributeMapper
    extends AbstractAttributeMapper {
        public JiraAttributeMapper(AbstractAttributeFactory attributeFactory) {
            super(attributeFactory);
        }

        public String getType(RepositoryTaskAttribute taskAttribute) {
            if ("task.common.date.created".equals(taskAttribute.getId()) || "task.common.date.modified".equals(taskAttribute.getId())) {
                return "date";
            }
            JiraFieldType type = JiraFieldType.valueByKey(taskAttribute.getMetaDataValue(JiraAttributeFactory.TYPE_KEY));
            List options = taskAttribute.getOptions();
            if (type.equals((Object)JiraFieldType.SELECT) && (options == null || options.isEmpty() || taskAttribute.isReadOnly())) {
                type = JiraFieldType.TEXTFIELD;
            } else if (type.equals((Object)JiraFieldType.MULTISELECT) && (options == null || options.isEmpty())) {
                type = JiraFieldType.TEXTFIELD;
            }
            switch (type) {
                case DATEPICKER: {
                    return "date";
                }
                case ISSUELINK: {
                    return "taskDepenedency";
                }
                case ISSUELINKS: {
                    return "taskDepenedency";
                }
                case MULTISELECT: {
                    return "multiSelect";
                }
                case SELECT: {
                    return "singleSelect";
                }
                case TEXTAREA: {
                    return "longText";
                }
            }
            return "shortText";
        }
    }
}

