/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.internal.jira.ui.JiraUiPlugin;
import org.eclipse.swt.graphics.Image;

public class JiraImages {
    private static ImageRegistry imageRegistry;
    private static final String T_VIEW = "eview16";
    private static final URL baseURL;
    public static final ImageDescriptor OVERLAY_JIRA;
    public static final ImageDescriptor OVERLAY_BUG;
    public static final ImageDescriptor OVERLAY_FEATURE;
    public static final ImageDescriptor OVERLAY_IMPROVEMENT;
    public static final ImageDescriptor OVERLAY_TASK;
    public static final ImageDescriptor OVERLAY_SUB_TASK;

    static {
        baseURL = JiraUiPlugin.getDefault().getBundle().getEntry("/icons/");
        OVERLAY_JIRA = JiraImages.create(T_VIEW, "overlay-jira.gif");
        OVERLAY_BUG = JiraImages.create(T_VIEW, "overlay-bug.gif");
        OVERLAY_FEATURE = JiraImages.create(T_VIEW, "overlay-feature.gif");
        OVERLAY_IMPROVEMENT = JiraImages.create(T_VIEW, "overlay-improvement.gif");
        OVERLAY_TASK = JiraImages.create(T_VIEW, "overlay-task.gif");
        OVERLAY_SUB_TASK = JiraImages.create(T_VIEW, "overlay-sub-task.gif");
    }

    public static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)JiraImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = JiraImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage();
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }
}

