/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.model.Issue;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Query;
import org.eclipse.mylyn.internal.jira.core.model.Status;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.DateRangeFilter;
import org.eclipse.mylyn.internal.jira.core.model.filter.FilterDefinition;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.model.filter.Order;
import org.eclipse.mylyn.internal.jira.core.model.filter.RelativeDateRangeFilter;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.ui.InvalidJiraQueryException;
import org.eclipse.mylyn.internal.jira.ui.JiraAttachmentHandler;
import org.eclipse.mylyn.internal.jira.ui.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.ui.JiraCustomQuery;
import org.eclipse.mylyn.internal.jira.ui.JiraIssueCollector;
import org.eclipse.mylyn.internal.jira.ui.JiraRepositoryQuery;
import org.eclipse.mylyn.internal.jira.ui.JiraTask;
import org.eclipse.mylyn.internal.jira.ui.JiraTaskDataHandler;
import org.eclipse.mylyn.internal.jira.ui.JiraUiPlugin;
import org.eclipse.mylyn.internal.jira.ui.JiraUtils;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraRepositoryConnector
extends AbstractRepositoryConnector {
    private static final String ERROR_REPOSITORY_CONFIGURATION = "The repository returned an unknown project. Please update the repository attributes.";
    private static final int MAX_MARK_STALE_QUERY_HITS = 500;
    private static final boolean TRACE_ENABLED = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.mylyn.internal.jira.ui/connector"));
    public static final String ISSUE_URL_PREFIX = "/browse/";
    public static final String FILTER_URL_PREFIX = "/secure/IssueNavigator.jspa?mode=hide";
    private JiraTaskDataHandler offlineHandler;
    private JiraAttachmentHandler attachmentHandler;
    private final TasksFacade mylynFacade;
    public static final String NEW_TASK_DESC = "New Task";
    public static final int RETURN_ALL_HITS = -1;

    public JiraRepositoryConnector(TasksFacade mylynFacade) {
        this.mylynFacade = mylynFacade;
        this.offlineHandler = new JiraTaskDataHandler(JiraClientFactory.getDefault());
        this.attachmentHandler = new JiraAttachmentHandler();
    }

    public JiraRepositoryConnector() {
        this(new TasksFacade());
    }

    public String getLabel() {
        return "JIRA (supports 3.3.3 and later)";
    }

    public String getConnectorKind() {
        return "jira";
    }

    public AbstractAttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler;
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.offlineHandler;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public IStatus performQuery(AbstractRepositoryQuery repositoryQuery, TaskRepository repository, IProgressMonitor monitor, ITaskCollector resultCollector) {
        monitor.beginTask("Running query", -1);
        try {
            NamedFilter filter;
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
            try {
                if (!client.hasDetails()) {
                    client.refreshDetails(monitor);
                }
            }
            catch (JiraException e) {
                IStatus iStatus = JiraCorePlugin.toStatus((TaskRepository)repository, (Throwable)e);
                monitor.done();
                return iStatus;
            }
            boolean isSearch = false;
            if (repositoryQuery instanceof JiraRepositoryQuery) {
                filter = ((JiraRepositoryQuery)repositoryQuery).getNamedFilter();
            } else if (repositoryQuery instanceof JiraCustomQuery) {
                try {
                    filter = ((JiraCustomQuery)repositoryQuery).getFilterDefinition(client, true);
                    isSearch = ((JiraCustomQuery)repositoryQuery).isSearch();
                }
                catch (InvalidJiraQueryException e) {
                    org.eclipse.core.runtime.Status status = new org.eclipse.core.runtime.Status(4, "org.eclipse.mylyn.jira.ui", 0, "The query parameters do not match the repository configuration, please check the query properties: " + e.getMessage(), null);
                    monitor.done();
                    return status;
                }
            } else {
                org.eclipse.core.runtime.Status status = new org.eclipse.core.runtime.Status(4, "org.eclipse.mylyn.jira.ui", 0, "Invalid query type: " + repositoryQuery.getClass(), null);
                return status;
            }
            ArrayList<Issue> issues = new ArrayList<Issue>();
            client.search((Query)filter, (IssueCollector)new JiraIssueCollector(monitor, issues, 5000));
            int n = 0;
            for (Issue issue : issues) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = org.eclipse.core.runtime.Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (issue.getProject() == null) {
                    org.eclipse.core.runtime.Status status = new org.eclipse.core.runtime.Status(4, "org.eclipse.mylyn.jira.ui", 0, ERROR_REPOSITORY_CONFIGURATION, null);
                    return status;
                }
                monitor.subTask(String.valueOf(++n) + "/" + issues.size() + " " + issue.getKey() + " " + issue.getSummary());
                if (isSearch) {
                    AbstractTask task = this.taskList.getTask(repository.getUrl(), issue.getId());
                    if (!(task instanceof JiraTask)) {
                        task = this.createTask(repository.getUrl(), issue.getId(), issue.getSummary());
                        JiraRepositoryConnector.updateTaskFromIssue(repository.getUrl(), (JiraTask)task, issue);
                    }
                    resultCollector.accept(task);
                    continue;
                }
                RepositoryTaskData oldTaskData = this.mylynFacade.getNewTaskData(repository.getUrl(), issue.getId());
                resultCollector.accept(this.offlineHandler.createTaskData(repository, client, issue, oldTaskData));
            }
            IStatus iStatus = org.eclipse.core.runtime.Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public boolean markStaleTasks(TaskRepository repository, Set<AbstractTask> tasks, IProgressMonitor monitor) throws CoreException {
        Date lastUpdate;
        block9: {
            JiraClient client;
            ArrayList<Issue> issues;
            Date now;
            block8: {
                now = new Date();
                FilterDefinition changedFilter = this.getSynchronizationFilter(repository, tasks, now);
                if (changedFilter == null) {
                    repository.setSynchronizationTimeStamp(JiraUtils.dateToString(now));
                    return true;
                }
                issues = new ArrayList<Issue>();
                client = JiraClientFactory.getDefault().getJiraClient(repository);
                JiraIssueCollector issueCollector = new JiraIssueCollector((IProgressMonitor)new NullProgressMonitor(), issues, 500);
                client.search((Query)changedFilter, (IssueCollector)issueCollector);
                if (!issues.isEmpty()) break block8;
                repository.setSynchronizationTimeStamp(JiraUtils.dateToString(now));
                return false;
            }
            try {
                for (Issue issue : issues) {
                    AbstractTask task = this.mylynFacade.getTask(repository.getUrl(), issue.getId());
                    if (task == null) continue;
                    if (issue.getProject() == null) {
                        throw new CoreException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.mylyn.jira.ui", 0, ERROR_REPOSITORY_CONFIGURATION, null));
                    }
                    monitor.subTask(String.valueOf(issue.getKey()) + " " + issue.getSummary());
                    RepositoryTaskData oldTaskData = this.mylynFacade.getNewTaskData(repository.getUrl(), issue.getId());
                    RepositoryTaskData taskData = this.offlineHandler.createTaskData(repository, client, issue, oldTaskData);
                    this.mylynFacade.saveIncoming(task, taskData);
                    this.updateTaskFromTaskData(repository, task, taskData);
                }
                repository.setSynchronizationTimeStamp(JiraUtils.dateToString(now));
                lastUpdate = ((Issue)issues.get(0)).getUpdated();
                Date repositoryUpdateTimeStamp = JiraUtils.getLastUpdate(repository);
                if (repositoryUpdateTimeStamp == null || !repositoryUpdateTimeStamp.equals(lastUpdate)) break block9;
                return false;
            }
            catch (JiraException e) {
                IStatus status = JiraCorePlugin.toStatus((TaskRepository)repository, (Throwable)e);
                this.trace(status);
                throw new CoreException(status);
            }
        }
        if (lastUpdate != null) {
            JiraUtils.setLastUpdate(repository, lastUpdate);
        }
        return true;
    }

    public FilterDefinition getSynchronizationFilter(TaskRepository repository, Set<AbstractTask> tasks, Date now) {
        if (tasks.isEmpty()) {
            return null;
        }
        Date lastSyncDate = JiraUtils.stringToDate(repository.getSynchronizationTimeStamp());
        if (lastSyncDate == null) {
            for (AbstractTask task : tasks) {
                task.setStale(true);
            }
            return null;
        }
        long nowTime = now.getTime();
        long lastSyncTime = lastSyncDate.getTime();
        if (lastSyncTime >= nowTime) {
            this.trace((IStatus)new org.eclipse.core.runtime.Status(2, "org.eclipse.mylyn.jira.ui", 0, "Synchronization time stamp clock skew detected for " + repository.getUrl() + ": " + lastSyncTime + " >= " + now, null));
            lastSyncDate = null;
            for (AbstractTask task : tasks) {
                Date date = JiraUtils.stringToDate(task.getLastReadTimeStamp());
                if (lastSyncDate != null && (date == null || !date.after(lastSyncDate))) continue;
                lastSyncDate = date;
            }
            if (lastSyncDate == null) {
                return null;
            }
            FilterDefinition changedFilter = new FilterDefinition("Changed Tasks");
            changedFilter.setUpdatedDateFilter((DateFilter)new DateRangeFilter(lastSyncDate, null));
            changedFilter.setOrdering(new Order[]{new Order(Order.Field.UPDATED, false)});
            return changedFilter;
        }
        FilterDefinition changedFilter = new FilterDefinition("Changed Tasks");
        long minutes = (now.getTime() - lastSyncDate.getTime()) / 60000L + 1L;
        changedFilter.setUpdatedDateFilter((DateFilter)new RelativeDateRangeFilter(RelativeDateRangeFilter.RangeType.MINUTE, -minutes));
        changedFilter.setOrdering(new Order[]{new Order(Order.Field.UPDATED, false)});
        return changedFilter;
    }

    public String getSynchronizationTimestamp(TaskRepository repository, Set<AbstractTask> changedTasks) {
        return repository.getSynchronizationTimeStamp();
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public void updateTaskFromRepository(TaskRepository repository, AbstractTask repositoryTask, IProgressMonitor monitor) {
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf(ISSUE_URL_PREFIX);
        return index == -1 ? null : url.substring(0, index);
    }

    public String getTaskIdFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf(ISSUE_URL_PREFIX);
        return index == -1 ? null : url.substring(index + ISSUE_URL_PREFIX.length());
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        return String.valueOf(repositoryUrl) + ISSUE_URL_PREFIX + taskId;
    }

    public String[] getTaskIdsFromComment(TaskRepository repository, String comment) {
        JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
        Project[] projects = client.getProjects();
        if (projects != null && projects.length > 0) {
            StringBuffer sb = new StringBuffer("(");
            String sep = "";
            Project[] projectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                Project project = projectArray[n2];
                sb.append(sep).append("(?:" + project.getKey() + "\\-\\d+?)");
                sep = "|";
                ++n2;
            }
            sb.append(")(?:\\D|\\z)");
            Pattern p = Pattern.compile(sb.toString(), 42);
            Matcher m = p.matcher(comment);
            if (m.find()) {
                HashSet<String> ids = new HashSet<String>();
                do {
                    ids.add(m.group(1));
                } while (m.find());
                return ids.toArray(new String[ids.size()]);
            }
        }
        return super.getTaskIdsFromComment(repository, comment);
    }

    public static void updateTaskFromIssue(String repositoryUrl, JiraTask task, Issue issue) {
        if (issue.getKey() != null) {
            task.setTaskKey(issue.getKey());
            task.setUrl(JiraRepositoryConnector.getTaskUrlFromKey(repositoryUrl, issue.getKey()));
            if (issue.getDescription() != null) {
                task.setSummary(issue.getSummary());
            }
        }
        task.setCreationDate(issue.getCreated());
        if (JiraRepositoryConnector.isCompleted(issue.getStatus())) {
            task.setCompleted(true);
            task.setCompletionDate(issue.getUpdated());
        } else {
            task.setCompleted(false);
            task.setCompletionDate(null);
        }
        if (issue.getType() != null) {
            task.setTaskKind(issue.getType().getName());
        }
        task.setPriority(JiraRepositoryConnector.getPriorityLevel(issue.getPriority()).toString());
        task.setOwner(issue.getAssignee());
    }

    public static String getTaskUrlFromKey(String repositoryUrl, String key) {
        return String.valueOf(repositoryUrl) + ISSUE_URL_PREFIX + key;
    }

    private static boolean isCompleted(Status status) {
        return status != null && (status.isClosed() || status.isResolved());
    }

    public AbstractTask createTask(String repositoryUrl, String id, String summary) {
        JiraTask jiraTask = new JiraTask(repositoryUrl, id, summary);
        jiraTask.setCreationDate(new Date());
        return jiraTask;
    }

    public void updateTaskFromTaskData(TaskRepository repository, AbstractTask repositoryTask, RepositoryTaskData taskData) {
        if (repositoryTask instanceof JiraTask) {
            JiraTask jiraTask = (JiraTask)repositoryTask;
            jiraTask.setSummary(taskData.getAttributeValue("task.common.summary"));
            jiraTask.setOwner(taskData.getAttributeValue("task.common.user.assigned"));
            jiraTask.setTaskKey(taskData.getAttributeValue("task.common.key"));
            jiraTask.setTaskKind(taskData.getAttributeValue("attribute.jira.type"));
            jiraTask.setUrl(JiraRepositoryConnector.getTaskUrlFromKey(repository.getUrl(), repositoryTask.getTaskKey()));
            jiraTask.setCreationDate(JiraUtils.stringToDate(taskData.getAttributeValue("task.common.date.created")));
            jiraTask.setDueDate(JiraUtils.stringToDate(taskData.getAttributeValue("attribute.jira.due")));
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
            jiraTask.setPriority(JiraRepositoryConnector.getPriorityLevel(client, taskData.getAttributeValue("task.common.priority")).toString());
            Status[] statusArray = client.getStatuses();
            int n = statusArray.length;
            int n2 = 0;
            while (n2 < n) {
                Status status = statusArray[n2];
                if (status.getName().equals(taskData.getAttributeValue("task.common.status"))) {
                    if (JiraRepositoryConnector.isCompleted(status)) {
                        jiraTask.setCompleted(true);
                        jiraTask.setCompletionDate(JiraUtils.stringToDate(taskData.getAttributeValue("task.common.date.modified")));
                        break;
                    }
                    jiraTask.setCompleted(false);
                    jiraTask.setCompletionDate(null);
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean updateTaskFromQueryHit(TaskRepository repository, AbstractTask existingTask, AbstractTask newTask) {
        return false;
    }

    private static AbstractTask.PriorityLevel getPriorityLevel(JiraClient client, String jiraPriority) {
        if (jiraPriority != null) {
            Priority[] priorityArray = client.getPriorities();
            int n = priorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Priority priority = priorityArray[n2];
                if (jiraPriority.equals(priority.getName())) {
                    return JiraRepositoryConnector.getPriorityLevel(priority);
                }
                ++n2;
            }
        }
        return AbstractTask.PriorityLevel.getDefault();
    }

    public static AbstractTask.PriorityLevel getPriorityLevel(Priority jiraPriority) {
        if (jiraPriority != null) {
            String priorityId = jiraPriority.getId();
            if ("1".equals(priorityId)) {
                return AbstractTask.PriorityLevel.P1;
            }
            if ("2".equals(priorityId)) {
                return AbstractTask.PriorityLevel.P2;
            }
            if ("3".equals(priorityId)) {
                return AbstractTask.PriorityLevel.P3;
            }
            if ("4".equals(priorityId)) {
                return AbstractTask.PriorityLevel.P4;
            }
            if ("5".equals(priorityId)) {
                return AbstractTask.PriorityLevel.P5;
            }
        }
        return AbstractTask.PriorityLevel.getDefault();
    }

    public String toString() {
        return this.getLabel();
    }

    public void updateAttributes(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
            client.refreshDetails(monitor);
        }
        catch (JiraException e) {
            IStatus status = JiraCorePlugin.toStatus((TaskRepository)repository, (Throwable)e);
            this.trace(status);
            throw new CoreException(status);
        }
    }

    public String getTaskIdPrefix() {
        return "issue";
    }

    public static String getAssigneeFromAttribute(String assignee) {
        return "".equals(assignee) ? "-1" : assignee;
    }

    private void trace(IStatus status) {
        if (TRACE_ENABLED) {
            JiraUiPlugin.getDefault().getLog().log(status);
        }
    }

    public boolean isRepositoryConfigurationStale(TaskRepository repository) throws CoreException {
        return JiraUtils.getAutoRefreshConfiguration(repository);
    }

    public boolean hasCredentialsManagement() {
        return true;
    }

    public static class TasksFacade {
        public AbstractTask getTask(String repositoryUrl, String taskId) {
            return TasksUiPlugin.getTaskListManager().getTaskList().getTask(repositoryUrl, taskId);
        }

        public RepositoryTaskData getNewTaskData(String repositoryUrl, String id) {
            return TasksUiPlugin.getTaskDataManager().getNewTaskData(repositoryUrl, id);
        }

        public void saveIncoming(AbstractTask task, RepositoryTaskData taskData) {
            TasksUiPlugin.getSynchronizationManager().saveIncoming(task, taskData, false);
        }
    }
}

