/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.jira.ui.JiraTask;
import org.eclipse.mylyn.internal.jira.ui.editor.JiraTaskEditor;
import org.eclipse.mylyn.internal.jira.ui.editor.NewJiraTaskEditor;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.FormEditor;

public class JiraTaskEditorFactory
extends AbstractTaskEditorFactory {
    public boolean canCreateEditorFor(AbstractTask task) {
        return task instanceof JiraTask;
    }

    public boolean canCreateEditorFor(IEditorInput input) {
        if (input instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput existingInput = (RepositoryTaskEditorInput)input;
            return existingInput.getTaskData() != null && "jira".equals(existingInput.getRepository().getConnectorKind());
        }
        return false;
    }

    public IEditorPart createEditor(TaskEditor parentEditor, IEditorInput editorInput) {
        if (editorInput instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput taskInput = (RepositoryTaskEditorInput)editorInput;
            if (taskInput.getTaskData().isNew()) {
                return new NewJiraTaskEditor((FormEditor)parentEditor);
            }
            return new JiraTaskEditor((FormEditor)parentEditor);
        }
        if (editorInput instanceof TaskEditorInput) {
            return new JiraTaskEditor((FormEditor)parentEditor);
        }
        return null;
    }

    public IEditorInput createEditorInput(AbstractTask task) {
        JiraTask jiraTask = (JiraTask)task;
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("jira", jiraTask.getRepositoryUrl());
        try {
            return new RepositoryTaskEditorInput(repository, jiraTask.getTaskId(), jiraTask.getUrl());
        }
        catch (Exception e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.jira.ui", "Could not create JIRA editor input", (Throwable)e));
            return null;
        }
    }

    public String getTitle() {
        return "JIRA";
    }

    public boolean providesOutline() {
        return true;
    }
}

