/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.wizards;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.ui.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.ui.JiraCustomQuery;
import org.eclipse.mylyn.internal.jira.ui.JiraRepositoryQuery;
import org.eclipse.mylyn.internal.jira.ui.wizards.JiraQueryPage;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.search.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class JiraQueryWizardPage
extends AbstractRepositoryQueryPage {
    private static final String TITLE = "New Jira Query";
    private static final String DESCRIPTION = "Please select a query type.";
    private static final String WAIT_MESSAGE = "Downloading...";
    private static final String JOB_LABEL = "Downloading Filter Names";
    private NamedFilter[] filters = null;
    private List filterList;
    private Button updateButton = null;
    private Button buttonCustom;
    private Button buttonSaved;
    private JiraQueryPage filterSummaryPage;
    private AbstractRepositoryQuery query;

    public JiraQueryWizardPage(TaskRepository repository) {
        this(repository, null);
    }

    public JiraQueryWizardPage(TaskRepository repository, AbstractRepositoryQuery query) {
        super(TITLE);
        this.repository = repository;
        this.query = query;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        boolean isCustom = this.query == null || this.query instanceof JiraCustomQuery;
        boolean isRepository = this.query instanceof JiraRepositoryQuery;
        Composite innerComposite = new Composite(parent, 0);
        innerComposite.setLayoutData((Object)new GridData());
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        innerComposite.setLayout((Layout)gl);
        this.buttonCustom = new Button(innerComposite, 16);
        this.buttonCustom.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.buttonCustom.setText("&Create query using form");
        this.buttonCustom.setSelection(isCustom);
        this.buttonSaved = new Button(innerComposite, 16);
        this.buttonSaved.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.buttonSaved.setText("Use saved &filter from the repository");
        this.buttonSaved.setSelection(isRepository);
        this.buttonSaved.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = JiraQueryWizardPage.this.buttonSaved.getSelection();
                if (JiraQueryWizardPage.this.filters != null) {
                    JiraQueryWizardPage.this.filterList.setEnabled(selection);
                }
                JiraQueryWizardPage.this.updateButton.setEnabled(selection);
                JiraQueryWizardPage.this.setPageComplete(selection);
            }
        });
        this.filterList = new List(innerComposite, 2560);
        this.filterList.add(WAIT_MESSAGE);
        this.filterList.deselectAll();
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 15;
        this.filterList.setLayoutData((Object)data);
        this.filterList.setEnabled(false);
        this.updateButton = new Button(innerComposite, 16392);
        GridData gridData = new GridData(4, 128, false, true);
        this.updateButton.setLayoutData((Object)gridData);
        this.updateButton.setText("Update from &Repository");
        this.updateButton.setEnabled(isRepository);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraQueryWizardPage.this.filterList.setEnabled(false);
                JiraQueryWizardPage.this.filterList.removeAll();
                JiraQueryWizardPage.this.filterList.add(JiraQueryWizardPage.WAIT_MESSAGE);
                JiraQueryWizardPage.this.filterList.deselectAll();
                JiraQueryWizardPage.this.getContainer().updateButtons();
                JiraQueryWizardPage.this.updateButton.setEnabled(false);
                JiraQueryWizardPage.this.downloadFilters();
            }
        });
        this.setControl((Control)innerComposite);
        this.downloadFilters();
    }

    public boolean isPageComplete() {
        return this.buttonCustom.getSelection() ? super.isPageComplete() : this.filterList.getSelectionCount() == 1;
    }

    public IWizardPage getNextPage() {
        if (!this.buttonCustom.getSelection()) {
            return null;
        }
        if (this.filterSummaryPage == null) {
            this.filterSummaryPage = this.query instanceof JiraCustomQuery ? new JiraQueryPage(this.repository, (JiraCustomQuery)this.query) : new JiraQueryPage(this.repository);
            this.filterSummaryPage.setWizard(this.getWizard());
        }
        return this.filterSummaryPage;
    }

    public boolean canFlipToNextPage() {
        return this.buttonCustom.getSelection();
    }

    protected void downloadFilters() {
        Job job = new Job(JOB_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Downloading list of filters", -1);
                NamedFilter[] loadedFilters = new NamedFilter[]{};
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        JiraClient jiraServer = JiraClientFactory.getDefault().getJiraClient(JiraQueryWizardPage.this.repository);
                        loadedFilters = jiraServer.getNamedFilters();
                        JiraQueryWizardPage.this.filters = loadedFilters;
                    }
                    catch (JiraException e) {
                        status = RepositoryStatus.createStatus((String)JiraQueryWizardPage.this.repository.getUrl(), (int)4, (String)"org.eclipse.mylyn.internal.jira.core", (String)("Could not download saved filters: " + e.getMessage() + "\n" + "Please check repository settings in the Task Repositories view"));
                        IStatus iStatus = Status.CANCEL_STATUS;
                        this.showFilters(loadedFilters, status);
                        monitor.done();
                        return iStatus;
                    }
                    catch (Exception e) {
                        status = RepositoryStatus.createStatus((String)JiraQueryWizardPage.this.repository.getUrl(), (int)4, (String)"org.eclipse.mylyn.internal.jira.core", (String)"Could not download saved filters from Jira repository.\nPlease check repository settings in the Task Repositories view");
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.jira.ui", status.getMessage(), (Throwable)e));
                        IStatus iStatus = Status.CANCEL_STATUS;
                        this.showFilters(loadedFilters, status);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    this.showFilters(loadedFilters, status);
                    monitor.done();
                }
                return status;
            }

            private void showFilters(final NamedFilter[] loadedFilters, final IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!JiraQueryWizardPage.this.filterList.isDisposed()) {
                            JiraQueryWizardPage.this.displayFilters(loadedFilters, status);
                        }
                        if (!JiraQueryWizardPage.this.updateButton.isDisposed() && !JiraQueryWizardPage.this.buttonSaved.isDisposed()) {
                            JiraQueryWizardPage.this.updateButton.setEnabled(JiraQueryWizardPage.this.buttonSaved.getSelection());
                        }
                    }
                });
            }
        };
        job.schedule();
    }

    public void displayFilters(NamedFilter[] filters, IStatus status) {
        if (!status.isOK()) {
            this.setMessage(status.getMessage(), 3);
        }
        this.filterList.removeAll();
        if (filters.length == 0) {
            this.filterList.setEnabled(false);
            this.filterList.add("No filters found");
            this.filterList.deselectAll();
            if (status.isOK()) {
                this.setMessage("No saved filters found. Please create filters using JIRA web interface or follow to the next page to create custom query.", 2);
            }
            this.setPageComplete(false);
            return;
        }
        String id = null;
        if (this.query instanceof JiraRepositoryQuery) {
            id = ((JiraRepositoryQuery)this.query).getNamedFilter().getId();
        }
        int n = 0;
        int i = 0;
        while (i < filters.length) {
            this.filterList.add(filters[i].getName());
            if (filters[i].getId().equals(id)) {
                n = i;
            }
            ++i;
        }
        this.filterList.select(n);
        this.filterList.showSelection();
        this.filterList.setEnabled(this.buttonSaved.getSelection());
        this.setPageComplete(status.isOK());
    }

    private NamedFilter getSelectedFilter() {
        if (this.filters != null && this.filters.length > 0) {
            return this.filters[this.filterList.getSelectionIndex()];
        }
        return null;
    }

    public AbstractRepositoryQuery getQuery() {
        if (this.buttonSaved.getSelection()) {
            return new JiraRepositoryQuery(this.repository.getUrl(), this.getSelectedFilter());
        }
        if (this.filterSummaryPage != null) {
            return this.filterSummaryPage.getQuery();
        }
        return null;
    }
}

