/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.service.JiraAuthenticationException;
import org.eclipse.mylyn.internal.jira.ui.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.ui.JiraUtils;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JiraRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private static final String TITLE = "JIRA Repository Settings";
    private static final String DESCRIPTION = "Example: http://developer.atlassian.com/jira";
    private Button compressionButton;
    private boolean characterEncodingValidated;
    private Button autoRefreshConfigurationButton;

    public JiraRepositorySettingsPage(AbstractRepositoryConnectorUi repositoryUi) {
        super(TITLE, DESCRIPTION, repositoryUi);
        this.setNeedsProxy(true);
        this.setNeedsHttpAuth(true);
    }

    protected void createAdditionalControls(Composite parent) {
        for (RepositoryTemplate template : this.connector.getTemplates()) {
            this.serverUrlCombo.add(template.label);
        }
        if (this.repository != null) {
            this.characterEncodingValidated = JiraUtils.getCharacterEncodingValidated(this.repository);
        }
        this.serverUrlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = JiraRepositorySettingsPage.this.serverUrlCombo.getText();
                RepositoryTemplate template = JiraRepositorySettingsPage.this.connector.getTemplate(text);
                if (template != null) {
                    JiraRepositorySettingsPage.this.repositoryLabelEditor.setStringValue(template.label);
                    JiraRepositorySettingsPage.this.setUrl(this.nvl(template.repositoryUrl));
                    JiraRepositorySettingsPage.this.getContainer().updateButtons();
                }
            }

            private String nvl(String s) {
                return s == null ? "" : s;
            }
        });
        Label compressionLabel = new Label(parent, 0);
        compressionLabel.setText("Compression:");
        this.compressionButton = new Button(parent, 16416);
        if (this.repository != null) {
            this.compressionButton.setSelection(JiraUtils.getCompression(this.repository));
        }
        Label label = new Label(parent, 0);
        label.setText("Automatically refresh attributes:");
        this.autoRefreshConfigurationButton = new Button(parent, 16416);
        this.autoRefreshConfigurationButton.setToolTipText("If checked Mylyn will periodically update the the repository attributes. Note: This can cause a significant load on the repository if it has many projects.");
        if (this.repository != null) {
            this.autoRefreshConfigurationButton.setSelection(JiraUtils.getAutoRefreshConfiguration(this.repository));
        }
    }

    protected boolean isValidUrl(String name) {
        if (name.startsWith("https://") || name.startsWith("http://")) {
            try {
                new URL(name);
                return true;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return false;
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return new JiraValidator(repository);
    }

    public void updateProperties(TaskRepository repository) {
        JiraUtils.setCompression(repository, this.compressionButton.getSelection());
        JiraUtils.setAutoRefreshConfiguration(repository, this.autoRefreshConfigurationButton.getSelection());
        if (this.characterEncodingValidated) {
            JiraUtils.setCharacterEncodingValidated(repository, true);
        }
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        JiraValidator jiraValidator = (JiraValidator)validator;
        ServerInfo serverInfo = jiraValidator.getServerInfo();
        if (serverInfo != null) {
            String url = jiraValidator.getRepositoryUrl();
            if (serverInfo.getBaseUrl() != null && !url.equals(serverInfo.getBaseUrl())) {
                LinkedHashSet<String> urls = new LinkedHashSet<String>();
                urls.add(url);
                urls.add(serverInfo.getBaseUrl());
                if (serverInfo.getWebBaseUrl() != null) {
                    urls.add(serverInfo.getWebBaseUrl());
                }
                UrlSelectionDialog dialog = new UrlSelectionDialog(this.getShell(), urls.toArray(new String[0]));
                dialog.setSelectedUrl(serverInfo.getBaseUrl());
                int result = dialog.open();
                if (result == 0) {
                    this.setUrl(dialog.getSelectedUrl());
                }
            }
            if (serverInfo.getCharacterEncoding() != null) {
                this.setEncoding(serverInfo.getCharacterEncoding());
            } else {
                this.setEncoding("UTF-8");
                jiraValidator.setStatus((IStatus)new Status(2, "org.eclipse.mylyn.jira.ui", 0, "Authentication credentials are valid. Note: The character encoding could not be determined, verify 'Additional Settings'.", null));
            }
            if (serverInfo.isInsecureRedirect()) {
                jiraValidator.setStatus((IStatus)new Status(2, "org.eclipse.mylyn.jira.ui", 0, "Authentication credentials are valid. Note: The server redirected to an insecure location.", null));
            }
            this.characterEncodingValidated = true;
        }
        super.applyValidatorResult(validator);
    }

    private class JiraValidator
    extends AbstractRepositorySettingsPage.Validator {
        final TaskRepository repository;
        private ServerInfo serverInfo;

        public JiraValidator(TaskRepository repository) {
            super((AbstractRepositorySettingsPage)JiraRepositorySettingsPage.this);
            this.repository = repository;
        }

        public ServerInfo getServerInfo() {
            return this.serverInfo;
        }

        public String getRepositoryUrl() {
            return this.repository.getUrl();
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                new URL(this.repository.getUrl());
            }
            catch (MalformedURLException malformedURLException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.jira.ui", 0, "Repository url is invalid.", null));
            }
            AbstractWebLocation location = new TaskRepositoryLocationFactory().createWebLocation(this.repository);
            try {
                this.serverInfo = JiraClientFactory.getDefault().validateConnection(location);
            }
            catch (JiraAuthenticationException jiraAuthenticationException) {
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repository.getUrl(), (int)4, (String)"org.eclipse.mylyn.jira.ui", (String)"Unable to authenticate with repository. Login credentials invalid."));
            }
            catch (Exception e) {
                throw new CoreException(JiraCorePlugin.toStatus((TaskRepository)this.repository, (Throwable)e));
            }
        }
    }

    private static class UrlSelectionDialog
    extends Dialog {
        private String[] locations;
        private String selectedUrl;

        protected UrlSelectionDialog(Shell parentShell, String[] locations) {
            super(parentShell);
            if (locations == null || locations.length < 2) {
                throw new IllegalArgumentException();
            }
            this.locations = locations;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Select repository location");
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            UrlSelectionDialog.applyDialogFont((Control)composite);
            Label label = new Label(composite, 0);
            label.setText("The repository location reported by the server does not match the provided location.");
            ArrayList<Button> buttons = new ArrayList<Button>(this.locations.length);
            if (this.getSelectedUrl() == null) {
                this.setSelectedUrl(this.locations[0]);
            }
            int i = 1;
            while (i < this.locations.length) {
                Button button = new Button(composite, 16);
                button.setText("Use server location: " + this.locations[i]);
                button.setData((Object)this.locations[i]);
                button.setSelection(this.getSelectedUrl().equals(this.locations[i]));
                buttons.add(button);
                ++i;
            }
            Button keepLocationButton = new Button(composite, 16);
            keepLocationButton.setText("Keep current location: " + this.locations[0]);
            keepLocationButton.setData((Object)this.locations[0]);
            keepLocationButton.setSelection(this.getSelectedUrl().equals(this.locations[0]));
            buttons.add(keepLocationButton);
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    Object source = e.getSource();
                    if (source instanceof Button && ((Button)source).getSelection()) {
                        UrlSelectionDialog.this.setSelectedUrl((String)((Button)source).getData());
                    }
                }
            };
            for (Button button : buttons) {
                button.addSelectionListener(listener);
            }
            return composite;
        }

        public void setSelectedUrl(String selectedUrl) {
            this.selectedUrl = selectedUrl;
        }

        public String getSelectedUrl() {
            return this.selectedUrl;
        }
    }
}

