/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.jira.ui.wizards.JiraQueryWizardPage;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class NewJiraQueryWizard
extends Wizard {
    private static final String TITLE = "New JIRA Query";
    private final TaskRepository repository;
    private JiraQueryWizardPage queryPage;

    public NewJiraQueryWizard(TaskRepository repository) {
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public void addPages() {
        this.queryPage = new JiraQueryWizardPage(this.repository);
        this.queryPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.queryPage);
    }

    public boolean performFinish() {
        AbstractRepositoryQuery query = this.queryPage.getQuery();
        if (query != null) {
            TasksUiPlugin.getTaskListManager().getTaskList().addQuery(query);
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
            if (connector != null) {
                TasksUiPlugin.getSynchronizationManager().synchronize(connector, query, null, true);
            }
        }
        return true;
    }

    public boolean canFinish() {
        if (this.queryPage.getNextPage() == null) {
            return this.queryPage.isPageComplete();
        }
        return this.queryPage.getNextPage().isPageComplete();
    }
}

