/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.ui.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.ui.JiraTaskDataHandler;
import org.eclipse.mylyn.internal.jira.ui.wizards.JiraProjectPage;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class NewJiraTaskWizard
extends Wizard
implements INewWizard {
    private final TaskRepository taskRepository;
    private final JiraProjectPage projectPage;
    private final TaskSelection taskSelection;

    public NewJiraTaskWizard(TaskRepository taskRepository, TaskSelection taskSelection) {
        this.taskRepository = taskRepository;
        this.taskSelection = taskSelection;
        this.projectPage = new JiraProjectPage(taskRepository);
        this.setWindowTitle("New Task");
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.projectPage);
    }

    public boolean performFinish() {
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector("jira");
        JiraTaskDataHandler taskDataHandler = (JiraTaskDataHandler)connector.getTaskDataHandler();
        AbstractAttributeFactory attributeFactory = taskDataHandler.getAttributeFactory(this.taskRepository.getUrl(), this.taskRepository.getConnectorKind(), "task");
        RepositoryTaskData taskData = new RepositoryTaskData(attributeFactory, "jira", this.taskRepository.getUrl(), TasksUiPlugin.getDefault().getNextNewRepositoryTaskId());
        taskData.setNew(true);
        JiraClient server = JiraClientFactory.getDefault().getJiraClient(this.taskRepository);
        Project project = this.projectPage.getSelectedProject();
        taskDataHandler.initializeTaskData(taskData, server, project);
        if (this.taskSelection != null) {
            taskDataHandler.cloneTaskData(this.taskSelection.getTaskData(), taskData);
        }
        taskData.setAttributeValue("task.common.product", project.getName());
        NewTaskEditorInput editorInput = new NewTaskEditorInput(this.taskRepository, taskData);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TasksUiUtil.openEditor((IEditorInput)editorInput, (String)"org.eclipse.mylyn.tasks.ui.editors.task", (IWorkbenchPage)page);
        return true;
    }
}

