/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.usage.InteractionEventLogger;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorPlugin;
import org.eclipse.mylyn.internal.monitor.usage.editors.UsageStatsEditorInput;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.usage.ReportGenerator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorFileRolloverJob
extends Job
implements IJobChangeListener {
    private static final String JOB_LABEL = "Mylyn Monitor Log Rollover";
    private static final String NAME_DATA_DIR = ".mylyn";
    private static final String DIRECTORY_MONITOR_BACKUP = "monitor";
    private static final String ZIP_EXTENSION = ".zip";
    private List<IUsageCollector> collectors = null;
    private ReportGenerator generator = null;
    private IEditorInput input = null;
    private boolean forceSyncForTesting = false;
    public static final String BACKUP_FILE_SUFFIX = "monitor-log";

    public MonitorFileRolloverJob(List<IUsageCollector> collectors) {
        super(JOB_LABEL);
        this.collectors = collectors;
    }

    private String getYear(InteractionEvent event) {
        return "" + (event.getDate().getYear() + 1900);
    }

    public void forceSyncForTesting(boolean forceSync) {
        this.forceSyncForTesting = forceSync;
    }

    private String getMonth(int month) {
        switch (month) {
            case 0: {
                return "01";
            }
            case 1: {
                return "02";
            }
            case 2: {
                return "03";
            }
            case 3: {
                return "04";
            }
            case 4: {
                return "05";
            }
            case 5: {
                return "06";
            }
            case 6: {
                return "07";
            }
            case 7: {
                return "08";
            }
            case 8: {
                return "09";
            }
            case 9: {
                return "10";
            }
            case 10: {
                return "11";
            }
            case 11: {
                return "12";
            }
        }
        return "";
    }

    public static String getZippedMonitorFileDirPath() {
        return String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + File.separatorChar + NAME_DATA_DIR + File.separatorChar + DIRECTORY_MONITOR_BACKUP;
    }

    public IStatus run(IProgressMonitor progressMonitor) {
        progressMonitor.beginTask(JOB_LABEL, -1);
        File monitorFile = UiUsageMonitorPlugin.getDefault().getMonitorLogFile();
        InteractionEventLogger logger = UiUsageMonitorPlugin.getDefault().getInteractionLogger();
        logger.stopMonitoring();
        List<InteractionEvent> events = logger.getHistoryFromFile(monitorFile);
        progressMonitor.worked(1);
        int nowMonth = Calendar.getInstance().get(2);
        if (events.size() > 0 && events.get(0).getDate().getMonth() != nowMonth) {
            int currMonth = events.get(0).getDate().getMonth();
            String fileName = String.valueOf(this.getYear(events.get(0))) + "-" + this.getMonth(currMonth) + "-" + BACKUP_FILE_SUFFIX;
            File dir = new File(MonitorFileRolloverJob.getZippedMonitorFileDirPath());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            try {
                File currBackupZipFile = new File(dir, String.valueOf(fileName) + ZIP_EXTENSION);
                if (!currBackupZipFile.exists()) {
                    currBackupZipFile.createNewFile();
                }
                ZipOutputStream zipFileStream = new ZipOutputStream(new FileOutputStream(currBackupZipFile));
                zipFileStream.putNextEntry(new ZipEntry(UiUsageMonitorPlugin.getDefault().getMonitorLogFile().getName()));
                for (InteractionEvent event : events) {
                    String xml;
                    int monthOfCurrEvent = event.getDate().getMonth();
                    if (monthOfCurrEvent == currMonth) {
                        xml = logger.writeLegacyEvent(event);
                        zipFileStream.write(xml.getBytes());
                        continue;
                    }
                    if (monthOfCurrEvent != nowMonth) {
                        progressMonitor.worked(1);
                        zipFileStream.closeEntry();
                        zipFileStream.close();
                        fileName = String.valueOf(this.getYear(event)) + "-" + this.getMonth(monthOfCurrEvent) + "-" + BACKUP_FILE_SUFFIX;
                        currBackupZipFile = new File(dir, String.valueOf(fileName) + ZIP_EXTENSION);
                        if (!currBackupZipFile.exists()) {
                            currBackupZipFile.createNewFile();
                        }
                        zipFileStream = new ZipOutputStream(new FileOutputStream(currBackupZipFile));
                        zipFileStream.putNextEntry(new ZipEntry(UiUsageMonitorPlugin.getDefault().getMonitorLogFile().getName()));
                        currMonth = monthOfCurrEvent;
                        xml = logger.writeLegacyEvent(event);
                        zipFileStream.write(xml.getBytes());
                        continue;
                    }
                    if (monthOfCurrEvent != nowMonth) continue;
                    logger.clearInteractionHistory(false);
                    logger.interactionObserved(event);
                }
                zipFileStream.closeEntry();
                zipFileStream.close();
            }
            catch (FileNotFoundException e) {
                StatusHandler.fail((Throwable)e, (String)"Mylyn monitor log rollover failed", (boolean)true);
            }
            catch (IOException e) {
                StatusHandler.fail((Throwable)e, (String)"Mylyn monitor log rollover failed", (boolean)true);
            }
        }
        progressMonitor.worked(1);
        logger.startMonitoring();
        this.generator = new ReportGenerator(UiUsageMonitorPlugin.getDefault().getInteractionLogger(), this.collectors, this, this.forceSyncForTesting);
        progressMonitor.worked(1);
        ArrayList<File> files = new ArrayList<File>();
        files.add(monitorFile);
        this.input = new UsageStatsEditorInput(files, this.generator);
        progressMonitor.done();
        if (this.forceSyncForTesting) {
            try {
                IEditorInput input = this.input;
                IWorkbenchPage page = UiUsageMonitorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) {
                    return new Status(4, "org.eclipse.mylyn.monitor.usage", 0, "Mylyn Usage Summary", null);
                }
                if (input != null) {
                    page.openEditor(input, "org.eclipse.mylyn.monitor.usage.summary.editor");
                }
            }
            catch (PartInitException e1) {
                StatusHandler.fail((Throwable)e1, (String)"Could not show usage summary", (boolean)true);
            }
        }
        return Status.OK_STATUS;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage page = UiUsageMonitorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page == null) {
                        return;
                    }
                    if (MonitorFileRolloverJob.this.input != null) {
                        page.openEditor(MonitorFileRolloverJob.this.input, "org.eclipse.mylyn.monitor.usage.summary.editor");
                    }
                }
                catch (PartInitException e) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not show usage summary", (Throwable)e));
                }
            }
        });
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

