/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.monitor.usage.MonitorFileRolloverJob;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorPlugin;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageFileSelectionWizardPage
extends WizardPage {
    private static final String PAGE_TITLE = "Select any archived Mylyn usage files you wish to upload";
    private static final String DESCRIPTION = "Please select the archived usage files you want to upload to eclipse.org";
    private Table zippedFilesTable;
    public static final String SUBMISSION_LOG_FILE_NAME = "submittedUsageLogs.txt";

    protected UsageFileSelectionWizardPage(String pageName) {
        super("org.eclipse.mylyn.monitor.usage.fileSelectionPage", PAGE_TITLE, UiUsageMonitorPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.monitor.usage", (String)"icons/wizban/banner-submission.gif"));
        this.setDescription(DESCRIPTION);
    }

    private static List<File> getBackupFiles() {
        ArrayList<File> backupFiles = new ArrayList<File>();
        try {
            String destination = MonitorFileRolloverJob.getZippedMonitorFileDirPath();
            File backupFolder = new File(destination);
            if (backupFolder.exists()) {
                File[] files = backupFolder.listFiles();
                File submissionLogFile = new File(destination, SUBMISSION_LOG_FILE_NAME);
                if (!submissionLogFile.exists()) {
                    submissionLogFile.createNewFile();
                }
                FileInputStream inputStream = new FileInputStream(submissionLogFile);
                int bytesRead = 0;
                byte[] buffer = new byte[1000];
                String fileContents = "";
                if (submissionLogFile.exists()) {
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        fileContents = String.valueOf(fileContents) + new String(buffer, 0, bytesRead);
                    }
                }
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.getName().contains("monitor-log") && !fileContents.contains(file.getName())) {
                        backupFiles.add(file);
                    }
                    ++n2;
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return backupFiles;
    }

    public static boolean unsubmittedLogsExist() {
        List<File> backupFiles = UsageFileSelectionWizardPage.getBackupFiles();
        return backupFiles.size() > 0;
    }

    private void addZippedFileView(Composite composite) {
        this.zippedFilesTable = new Table(composite, 2050);
        GridDataFactory.fillDefaults().span(2, -1).grab(true, true).applyTo((Control)this.zippedFilesTable);
        TableColumn filenameColumn = new TableColumn(this.zippedFilesTable, 16384);
        filenameColumn.setWidth(200);
        List<File> backupFiles = UsageFileSelectionWizardPage.getBackupFiles();
        File[] backupFileArray = backupFiles.toArray(new File[backupFiles.size()]);
        if (backupFileArray != null && backupFileArray.length > 0) {
            Arrays.sort(backupFileArray, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return new Long(file1.lastModified()).compareTo(new Long(file2.lastModified())) * -1;
                }
            });
            File[] fileArray = backupFileArray;
            int n = backupFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                TableItem item = new TableItem(this.zippedFilesTable, 0);
                item.setData((Object)file.getAbsolutePath());
                item.setText(file.getName());
                ++n2;
            }
        }
    }

    public void createControl(Composite parent) {
        try {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.verticalSpacing = 15;
            container.setLayout((Layout)layout);
            this.addZippedFileView(container);
            this.setControl((Control)container);
        }
        catch (RuntimeException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not create import wizard page", (Throwable)e));
        }
    }

    public List<String> getZipFilesSelected() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.zippedFilesTable.getSelectionCount() >= 1) {
            TableItem[] selectedItems = this.zippedFilesTable.getSelection();
            int i = 0;
            while (i < selectedItems.length) {
                list.add(selectedItems[i].getText());
                ++i;
            }
        } else {
            list.add("<unspecified>");
        }
        return list;
    }
}

