/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.core;

import java.io.File;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axis.AxisProperties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.xplanner.core.Messages;
import org.eclipse.mylyn.xplanner.core.XPlannerClientManager;
import org.eclipse.mylyn.xplanner.core.service.exceptions.AuthenticationException;
import org.osgi.framework.BundleContext;

public class XPlannerCorePlugin
extends Plugin {
    public static final String ID = "org.eclipse.mylyn.xplanner.core";
    private static XPlannerCorePlugin plugin;
    private ResourceBundle resourceBundle;
    private XPlannerClientManager clientManager;

    public XPlannerCorePlugin() {
        plugin = this;
        AxisProperties.setProperty((String)"attachments.implementation", (String)"org.eclipse.mylyn.does.not.exist");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        File clientCache = this.getStateLocation().append("serverCache").toFile();
        Logger logger = Logger.getLogger("org.apache.axis.utils.JavaUtils");
        logger.setLevel(Level.SEVERE);
        this.clientManager = new XPlannerClientManager(clientCache);
        this.clientManager.start();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.clientManager != null) {
            this.clientManager.stop();
        }
        plugin = null;
        this.resourceBundle = null;
        this.clientManager = null;
    }

    public static XPlannerCorePlugin getDefault() {
        return plugin;
    }

    public XPlannerClientManager getClientManager() {
        return this.clientManager;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = XPlannerCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.mylyn.xplanner.core.XPlannerCorePluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static void log(int severity, String message, Throwable e) {
        XPlannerCorePlugin.getDefault().getLog().log((IStatus)new Status(severity, ID, -1, message, e));
    }

    public static IStatus toStatus(Throwable e) {
        Status status;
        if (e instanceof AuthenticationException) {
            String errorMessage = MessageFormat.format(Messages.XPlannerValidator_INVALID_CREDENTIALS_ERROR, e.getMessage());
            status = new Status(4, ID, 0, errorMessage, e);
        } else if (e instanceof Exception) {
            String message = e.getMessage();
            if (message == null) {
                message = "";
            }
            String errorMessage = MessageFormat.format(Messages.XPlannerValidator_CONNECTION_ERROR, message);
            status = new Status(4, ID, 0, errorMessage, e);
        } else {
            status = new Status(4, ID, 0, Messages.XPlannerCorePlugin_UNEXPECTED_ERROR, e);
        }
        return status;
    }
}

