/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.xplanner.ui.Messages;
import org.eclipse.mylyn.xplanner.ui.XPlannerClientFacade;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class XPlannerMylynUIPlugin
extends AbstractUIPlugin {
    private static XPlannerMylynUIPlugin INSTANCE;
    public static final String PLUGIN_ID = "org.eclipse.mylyn.xplanner.ui";
    public static final String REPOSITORY_KIND = "xplanner";
    public static final String XPLANNER_CLIENT_LABEL;
    public static final String TITLE_MESSAGE_DIALOG;
    public static final String DELIM_URL_PREFIX = "/do/view/";
    public static final String DELIM_URL_SUFFIX = "?oid=";
    public static final String TASK_URL_PREFIX = "/do/view/task?oid=";
    public static final String USER_STORY_URL_PREFIX = "/do/view/userstory?oid=";
    public static final String ITERATION_URL_PREFIX = "/do/view/iteration?oid=";
    public static final IStatus NO_LICENSE_STATUS;
    public static final String USE_AUTO_TIME_TRACKING_PREFERENCE_NAME = "UseAutoTimeTracking";
    public static final String ROUND_AUTO_TIME_TRACKING_TO_HALF_HOUR_PREFERENCE_NAME = "RoundAutoTimeTrackingToHalfHour";
    public static final String ADD_AUTO_TRACKED_TIME_TO_REPOSITORY_VALUE_PREFERENCE_NAME = "AddAutoTrackedTimeToRepositoryValue";

    static {
        XPLANNER_CLIENT_LABEL = Messages.MylynXPlannerPlugin_CLIENT_LABEL;
        TITLE_MESSAGE_DIALOG = Messages.MylynXPlannerPlugin_CLIENT_DIALOG_TITLE;
        NO_LICENSE_STATUS = new Status(1, PLUGIN_ID, 0, Messages.MylynXPlannerPlugin_NOT_AVAILABLE_IN_SKU, null);
    }

    public XPlannerMylynUIPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setPreferenceDefaults();
    }

    private void setPreferenceDefaults() {
        this.getPreferenceStore().setDefault(USE_AUTO_TIME_TRACKING_PREFERENCE_NAME, false);
        this.getPreferenceStore().setDefault(ROUND_AUTO_TIME_TRACKING_TO_HALF_HOUR_PREFERENCE_NAME, true);
        this.getPreferenceStore().setDefault(ADD_AUTO_TRACKED_TIME_TO_REPOSITORY_VALUE_PREFERENCE_NAME, true);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        INSTANCE = null;
        XPlannerClientFacade.getDefault().logOutFromAll();
    }

    public static void log(final Throwable e, final String message, boolean informUser) {
        if (Platform.isRunning() && informUser) {
            try {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = null;
                        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        }
                        String displayMessage = message == null ? e.getMessage() : String.valueOf(message) + "\n" + e.getMessage();
                        MessageDialog.openError((Shell)shell, (String)Messages.MylynXPlannerPlugin_XPLANNER_ERROR_TITLE, (String)displayMessage);
                    }
                });
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            StatusHandler.log((IStatus)new Status(4, PLUGIN_ID, message == null ? Messages.MylynXPlannerPlugin_XPLANNER_ERROR_TITLE : message, e));
        }
    }

    public static XPlannerMylynUIPlugin getDefault() {
        return INSTANCE;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void setBooleanPreference(String name, boolean value) {
        XPlannerMylynUIPlugin.getDefault().getPreferenceStore().setValue(name, value);
    }

    public static boolean getBooleanPreference(String name) {
        return XPlannerMylynUIPlugin.getDefault().getPreferenceStore().getBoolean(name);
    }
}

