/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskListFactory;
import org.eclipse.mylyn.xplanner.ui.XPlannerCustomQuery;
import org.eclipse.mylyn.xplanner.ui.XPlannerTask;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerTaskListFactory
extends AbstractTaskListFactory {
    private static final String TOKEN_SEPARATOR = ";";
    private static final String KEY_XPLANNER = "XPlanner";
    private static final String KEY_CUSTOM = "XPlannerCustom";
    private static final String KEY_XPLANNER_QUERY = "XPlannerQuery";
    private static final String KEY_XPLANNER_CUSTOM = "XPlannerXPlannerCustomQuery";
    private static final String KEY_XPLANNER_ITEM = "XPlannerItem";
    private static final String KEY_QUERY_CONTENT_ID_TYPE = "QueryContentIdType";
    private static final String KEY_QUERY_IS_TASKS = "QueryIsTasks";
    private static final String KEY_QUERY_CONTENT_ID = "QueryConentId";
    private static final String KEY_QUERY_PERSON_ID = "QueryPersonId";
    private static final String KEY_QUERY_MY_CURRENT_TASKS = "QueryMyCurrentTasks";

    public boolean canReadQuery(Node node) {
        return node.getNodeName().equals(KEY_XPLANNER_QUERY) || node.getNodeName().equals(KEY_XPLANNER_CUSTOM);
    }

    public boolean canCreateElementFor(AbstractRepositoryQuery category) {
        return category instanceof XPlannerCustomQuery;
    }

    public boolean canCreateElementFor(AbstractTask task) {
        return task instanceof XPlannerTask;
    }

    public AbstractRepositoryQuery createQuery(String repositoryUrl, String queryString, String label, Element element) {
        XPlannerCustomQuery query = null;
        query = new XPlannerCustomQuery(repositoryUrl, label);
        this.initializeQuery(query, element);
        return query;
    }

    private void initializeQuery(XPlannerCustomQuery query, Element element) {
        String myCurrentTasks = element.getAttribute(KEY_QUERY_MY_CURRENT_TASKS);
        if (myCurrentTasks != null && Boolean.valueOf(myCurrentTasks).booleanValue()) {
            query.setMyCurrentTasks(true);
        } else {
            String contentIds;
            String personId;
            String useTasks;
            String contentIdType = element.getAttribute(KEY_QUERY_CONTENT_ID_TYPE);
            if (contentIdType != null) {
                query.setContentIdType(XPlannerCustomQuery.ContentIdType.valueOf(contentIdType));
            }
            if ((useTasks = element.getAttribute(KEY_QUERY_IS_TASKS)) != null) {
                query.setUseTasks(Boolean.valueOf(useTasks));
            }
            if ((personId = element.getAttribute(KEY_QUERY_PERSON_ID)) != null) {
                query.setPersonId(Integer.valueOf(personId));
            }
            if ((contentIds = element.getAttribute(KEY_QUERY_CONTENT_ID)) != null) {
                query.setContentIds(this.decodeIds(contentIds));
            }
        }
    }

    private String encodeIds(List<Integer> contentIds) {
        StringBuilder result = new StringBuilder();
        Iterator<Integer> iter = contentIds.iterator();
        while (iter.hasNext()) {
            Integer id = iter.next();
            result.append(id);
            if (!iter.hasNext()) continue;
            result.append(TOKEN_SEPARATOR);
        }
        return result.toString();
    }

    private List<Integer> decodeIds(String encoded) {
        if (encoded == null) {
            return XPlannerCustomQuery.INVALID_IDS;
        }
        StringTokenizer tokens = new StringTokenizer(encoded, TOKEN_SEPARATOR);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        while (tokens.hasMoreTokens()) {
            ids.add(Integer.valueOf(tokens.nextToken()));
        }
        return ids;
    }

    public Set<String> getQueryElementNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(KEY_XPLANNER_CUSTOM);
        return names;
    }

    public void setAdditionalAttributes(AbstractRepositoryQuery query, Element node) {
        XPlannerCustomQuery xplannerCustomQuery = (XPlannerCustomQuery)query;
        boolean isMyCurrentTasks = xplannerCustomQuery.isMyCurrentTasks();
        if (isMyCurrentTasks) {
            node.setAttribute(KEY_QUERY_MY_CURRENT_TASKS, Boolean.toString(true));
        } else {
            node.setAttribute(KEY_QUERY_MY_CURRENT_TASKS, Boolean.toString(false));
            String contentIdType = xplannerCustomQuery.getContentIdType().name();
            node.setAttribute(KEY_QUERY_CONTENT_ID_TYPE, contentIdType);
            boolean isUseTasks = xplannerCustomQuery.isUseTasks();
            node.setAttribute(KEY_QUERY_IS_TASKS, Boolean.toString(isUseTasks));
            List<Integer> contentIds = xplannerCustomQuery.getContentIds();
            node.setAttribute(KEY_QUERY_CONTENT_ID, this.encodeIds(contentIds));
            int personId = xplannerCustomQuery.getPersonId();
            node.setAttribute(KEY_QUERY_PERSON_ID, Integer.toString(personId));
        }
    }

    public String getTaskElementName() {
        return KEY_XPLANNER_ITEM;
    }

    public AbstractTask createTask(String repositoryUrl, String taskId, String summary, Element element) {
        return new XPlannerTask(repositoryUrl, taskId, summary);
    }

    public String getQueryElementName(AbstractRepositoryQuery query) {
        if (query instanceof XPlannerCustomQuery) {
            return KEY_XPLANNER_CUSTOM;
        }
        return "";
    }

    public boolean canCreate(AbstractRepositoryQuery category) {
        return category instanceof XPlannerCustomQuery;
    }

    public boolean canCreate(AbstractTask task) {
        return task instanceof XPlannerTask;
    }
}

