/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractEditQueryWizard;
import org.eclipse.mylyn.xplanner.ui.XPlannerCustomQuery;
import org.eclipse.mylyn.xplanner.ui.wizard.AbstractXPlannerQueryWizardPage;
import org.eclipse.mylyn.xplanner.ui.wizard.MultipleQueryPage;
import org.eclipse.mylyn.xplanner.ui.wizard.XPlannerQueryWizardUtils;

public class EditXPlannerQueryWizard
extends AbstractEditQueryWizard {
    private AbstractXPlannerQueryWizardPage queryPage;

    public EditXPlannerQueryWizard(TaskRepository repository, AbstractRepositoryQuery query) {
        super(repository, query);
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        this.queryPage = XPlannerQueryWizardUtils.addQueryWizardFirstPage((Wizard)this, this.repository, (XPlannerCustomQuery)this.query);
    }

    public boolean performFinish() {
        List<Object> queries = new ArrayList();
        TasksUiPlugin.getTaskListManager().getTaskList().deleteQuery(this.query);
        if (this.queryPage instanceof MultipleQueryPage) {
            queries = ((MultipleQueryPage)((Object)this.queryPage)).getQueries();
        } else {
            AbstractRepositoryQuery abstractRepositoryQuery = this.queryPage.getQuery();
            if (abstractRepositoryQuery != null) {
                queries.add(abstractRepositoryQuery);
            }
        }
        for (AbstractRepositoryQuery abstractRepositoryQuery : queries) {
            this.updateQuery(abstractRepositoryQuery);
        }
        return true;
    }

    private void updateQuery(AbstractRepositoryQuery query) {
        String queryName;
        XPlannerCustomQuery xplannerQuery;
        String handleIdentifier;
        TasksUiPlugin.getTaskListManager().getTaskList().deleteQuery(query);
        if (query instanceof XPlannerCustomQuery && !(handleIdentifier = (xplannerQuery = (XPlannerCustomQuery)query).getHandleIdentifier()).equals(queryName = xplannerQuery.getQueryName())) {
            xplannerQuery.setHandleIdentifier(queryName);
        }
        TasksUiPlugin.getTaskListManager().getTaskList().addQuery(query);
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
        if (connector != null) {
            TasksUiPlugin.getSynchronizationManager().synchronize(connector, query, null, true);
        }
    }

    public boolean canFinish() {
        boolean canFinish = false;
        if (this.queryPage != null) {
            canFinish = this.queryPage.getNextPage() == null ? this.queryPage.isPageComplete() : this.queryPage.getNextPage().isPageComplete();
        }
        return canFinish;
    }
}

